/****************************************************************************
 *                                                                          *
 *                         GNAT RUN-TIME COMPONENTS                         *
 *                                                                          *
 *                                 C _ I O                                  *
 *                                                                          *
 *                          C Implementation File                           *
 *                                                                          *
 *                     Copyright (C) 2008-2009, AdaCore                     *
 *                                                                          *
 * GNAT is free software;  you can  redistribute it  and/or modify it under *
 * terms of the  GNU General Public License as published  by the Free Soft- *
 * ware  Foundation;  either version 2,  or (at your option) any later ver- *
 * sion.  GNAT is distributed in the hope that it will be useful, but WITH- *
 * OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY *
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License *
 * for  more details.  You should have  received  a copy of the GNU General *
 * Public License  distributed with GNAT;  see file COPYING.  If not, write *
 * to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, *
 * Boston, MA 02110-1301, USA.                                              *
 *                                                                          *
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
 *                                                                          *
 * GNAT was originally developed  by the GNAT team at  New York University. *
 * Extensive contributions were provided by Ada Core Technologies Inc.      *
 *                                                                          *
 ****************************************************************************/

static void outb(int port, unsigned char v)
{
  *((volatile unsigned char *)(0x80000000 + port)) = v;
}

void abort (void)
{
  outb (0x92, 0x01);
  while (1)
    ;
}

void exit (int c)
{
  outb(0x92, 0x01);
  while (1)
    ;
}

int putchar(int c)
{
  outb(0x3f8 + 0x00, c);
  return c;
}

void bug_putstring(const char *buf, int len)
{
   int i;
   char c;

   for (i=0; i<len; i++)
     putchar (buf[i]);
}


void bug_putnl(void)
{
  putchar('\n');
}

static void memcpy (unsigned char *d, unsigned char *s, int len)
{
  while (len--)
    *d++ = *s++;
}

static void bzero (unsigned char *d, int len)
{
  while (len--)
    *d++ = 0;
}

extern char __sdata2_load[], __sdata2_start[], __sdata2_end[];
extern char __data_load[], __data_start[], __data_end[];
extern char __sbss2_start[], __sbss2_end[];
extern char __sbss_start[], __sbss_end[];
extern char __bss_start[], __bss_end[];

void cmain (void)
{
  memcpy (__sdata2_start, __sdata2_load, __sdata2_end - __sdata2_start);
  memcpy (__data_start, __data_load, __data_end - __data_start);
  bzero (__sbss2_start, __sbss2_end - __sbss2_start);
  bzero (__sbss_start, __sbss_end - __sbss_start);
  bzero (__bss_start, __bss_end - __bss_start);
  main();
  abort ();
}
