/*
 * _EPPCBug_pollWrite
 *
 *  Output buffer through EPPCBug. Returns only once every character has been
 *  sent (polled output).
 *
 *  Input parameters:
 *    buf - output buffer
 *    len - number of chars to output
 *
 *  Output parameters:  NONE
 *
 *  Return value: 0 if successfull, -1 else
 */
int bug_putstring(
  const char *buf,
  int len
)
{
   int i;
   char c;

   for (i=0; i<len; i++) {
    
     c = buf[i];
     asm volatile( "li 10,0x020          /* Code for .OUTCHR */\n\
                    mr 3, %0             /* character */\n\
                    sc"                  /* Call EPPCBUG */
 	:: "b" (c) : "3", "10" );
   }
  return 0;
}

int putchar(
  const char c
)
{
   int i;

   asm volatile( "li 10,0x020          /* Code for .OUTCHR */\n\
                  mr 3, %0             /* character */\n\
                  sc"                  /* Call EPPCBUG */
		 :: "b" (c) : "3", "10" );
  return 0;
}

int bug_putnl(void)
{
   asm volatile( "li 10,0x026          /* Code for .PCRLF */\n\
                  sc"                  /* Call EPPCBUG */
		 ::: "10" );
  return 0;
}
