with System;
with System.Machine_Code;

package body Ada.Text_IO is

   STDIO : Character;
   for STDIO'Address use System'To_Address (16#52#);

   procedure Put (Item : Character) is
      use System.Machine_Code;
   begin
      --  STDIO := Item;
      Asm ("out 0x32,%0", Inputs => Character'Asm_Input ("r", Item),
           Volatile => True);
   end Put;

   procedure New_Line is
   begin
      Put (ASCII.LF);
   end New_Line;

   procedure Put (Item : String) is
   begin
      for I in Item'Range loop
         Put (Item (I));
      end loop;
   end Put;

   procedure Put_Line (Item : String) is
   begin
      Put (Item);
      New_Line;
   end Put_Line;

end Ada.Text_IO;
