------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUN-TIME COMPONENTS                         --
--                                                                          --
--                       S Y S T E M . I O P O R T S                        --
--                                                                          --
--                    Copyright (C) 2010-2011, AdaCore                      --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.                                     --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

--  This package is specific to powerpc-elf on PREP platform. It provides an
--  interface to the IO ports.

pragma Restrictions (No_Elaboration_Code);

with Interfaces;

package System.IOPorts is
   pragma Preelaborate;

   type Port_Id is range 0 .. 16#ffff#;
   --  IO port range

   procedure Outb (P : Port_Id; B : Interfaces.Unsigned_8);
   pragma Inline (Outb);
   --  Write a byte to a port

   function Inb (P : Port_Id) return Interfaces.Unsigned_8;
   pragma Inline (Inb);
   --  Read a byte from a port
end System.IOPorts;
