/****************************************************************************
 *                                                                          *
 *                         GNAT RUN-TIME COMPONENTS                         *
 *                                                                          *
 *                                 C _ I O                                  *
 *                                                                          *
 *                          C Implementation File                           *
 *                                                                          *
 *                     Copyright (C) 2008-2011, AdaCore                     *
 *                                                                          *
 * GNAT is free software;  you can  redistribute it  and/or modify it under *
 * terms of the  GNU General Public License as published  by the Free Soft- *
 * ware  Foundation;  either version 2,  or (at your option) any later ver- *
 * sion.  GNAT is distributed in the hope that it will be useful, but WITH- *
 * OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY *
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License *
 * for  more details.  You should have  received  a copy of the GNU General *
 * Public License  distributed with GNAT;  see file COPYING.  If not, write *
 * to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, *
 * Boston, MA 02110-1301, USA.                                              *
 *                                                                          *
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
 *                                                                          *
 * GNAT was originally developed  by the GNAT team at  New York University. *
 * Extensive contributions were provided by Ada Core Technologies Inc.      *
 *                                                                          *
 ****************************************************************************/

static void outb(int port, unsigned char v)
{
  *((volatile unsigned char *)(0xf3000000 + port)) = v;
}

void abort (void)
{
  outb (0xe00b0, 0x02);
  while (1)
    ;
}

void exit (int c)
{
  outb(0xe00b0, 0x02);
  while (1)
    ;
}

int putchar(int c)
{
  outb(0x4500 + 0x00, c);
  return c;
}

void bug_putstring(const char *buf, int len)
{
   int i;
   char c;

   for (i=0; i<len; i++)
     putchar (buf[i]);
}


void bug_putnl(void)
{
  putchar('\n');
}

static void memcpy (unsigned char *d, unsigned char *s, int len)
{
  while (len--)
    *d++ = *s++;
}

static void bzero (unsigned char *d, int len)
{
  while (len--)
    *d++ = 0;
}

void cmain (void)
{
  main();
  exit (0);
}
