------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                      S Y S T E M . I M G _ R E A L                       --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--          Copyright (C) 1992-2011, Free Software Foundation, Inc.         --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.                                     --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

--  Dummy implementation for use with ZFP

package body System.Img_Real is

   procedure Image_Ordinary_Fixed_Point
     (V   : Long_Long_Float;
      S   : in out String;
      P   : out Natural;
      Aft : Natural)
   is
      pragma Unreferenced (Aft);
      pragma Unreferenced (V);
   begin
      S (S'First .. S'First + 4) := "Dummy";
      P := 5;
   end Image_Ordinary_Fixed_Point;

   procedure Image_Floating_Point
     (V    : Long_Long_Float;
      S    : in out String;
      P    : out Natural;
      Digs : Natural)
   is
      pragma Unreferenced (Digs);
      pragma Unreferenced (V);
   begin
      S (S'First .. S'First + 4) := "Dummy";
      P := 5;
   end Image_Floating_Point;

   procedure Set_Image_Real
     (V    : Long_Long_Float;
      S    : out String;
      P    : in out Natural;
      Fore : Natural;
      Aft  : Natural;
      Exp  : Natural) is
      pragma Unreferenced (V);
      pragma Unreferenced (S);
      pragma Unreferenced (P);
      pragma Unreferenced (Fore);
      pragma Unreferenced (Aft);
      pragma Unreferenced (Exp);
   begin
      null;
   end Set_Image_Real;

end System.Img_Real;
