#!/bin/sh
# Run time files where moved to GNAT repository as part of K428-027.
# For now, copy them back in order to build. The repository need
# to be reorganized, but that is easier with all files in one location
# to start with.

set -e

CP=cp

if [ "$1" = "-l" ]; then
  CP="ln -sf"
  shift
fi

if [ $# -ne 1 ]; then
  echo "Usage: $0 gnat-src"
  exit 1
fi

gnatsrc=$1


$CP $gnatsrc/system-xi-ppc-full.ads ./runtimes/powerpc/full/system.ads
$CP $gnatsrc/system-xi-ppc-sfp.ads ./runtimes/powerpc/sfp/system.ads
$CP $gnatsrc/a-calend-zfp.ads ./extra-zfp-src/a-calend.ads
$CP $gnatsrc/a-inteio-zfp.adb ./extra-zfp-src/a-inteio.adb
$CP $gnatsrc/a-calend-zfp.adb ./extra-zfp-src/a-calend.adb
$CP $gnatsrc/a-inteio-zfp.ads ./extra-zfp-src/a-inteio.ads
$CP $gnatsrc/s-imgrea-zfp.adb ./extra-zfp-src/s-imgrea.adb
$CP $gnatsrc/s-imgrea-zfp.ads ./extra-zfp-src/s-imgrea.ads
$CP $gnatsrc/s-imglli-zfp.ads ./zfp-src/s-imglli.ads
$CP $gnatsrc/s-imgint-zfp.ads ./zfp-src/s-imgint.ads
$CP $gnatsrc/s-memory-zfp.ads ./zfp-src/s-memory.ads
$CP $gnatsrc/s-memory-zfp.adb ./zfp-src/s-memory.adb
$CP $gnatsrc/a-numeri-zfp.ads ./zfp-src/a-numeri.ads
$CP $gnatsrc/s-imgboo-zfp.adb ./zfp-src/s-imgboo.adb
$CP $gnatsrc/s-imgboo-zfp.ads ./zfp-src/s-imgboo.ads
$CP $gnatsrc/s-imgint-zfp.adb ./zfp-src/s-imgint.adb
$CP $gnatsrc/s-imglli-zfp.adb ./zfp-src/s-imglli.adb
$CP $gnatsrc/s-cmaext-zfp.ads ./runtimes/tests/malloc/s-cmaext.ads
$CP $gnatsrc/s-cmaext-zfp.adb ./runtimes/tests/malloc/s-cmaext.adb
$CP $gnatsrc/s-bbtime-ppc.adb ./runtimes/powerpc/s-bbtime.adb
$CP $gnatsrc/s-bbpara-p2020.ads ./runtimes/powerpc/p2020/s-bbpara.ads
$CP $gnatsrc/s-bbcpsp-6xx.ads ./runtimes/powerpc/6xx/s-bbcpsp.ads
$CP $gnatsrc/s-bbcpsp-6xx.adb ./runtimes/powerpc/6xx/s-bbcpsp.adb
$CP $gnatsrc/s-bbcpsp-spe.ads ./runtimes/powerpc/spe/s-bbcpsp.ads
$CP $gnatsrc/s-bbcpsp-spe.adb ./runtimes/powerpc/spe/s-bbcpsp.adb
$CP $gnatsrc/s-bbinte-ppc.adb ./runtimes/powerpc/s-bbinte.adb
$CP $gnatsrc/s-bbbosu-ppc.ads ./runtimes/powerpc/s-bbbosu.ads
$CP $gnatsrc/s-bbcppr-ppc.ads ./runtimes/powerpc/s-bbcppr.ads
$CP $gnatsrc/s-bbcppr-ppc.adb ./runtimes/powerpc/s-bbcppr.adb
$CP $gnatsrc/s-ioport-prep.ads ./runtimes/powerpc/prep/s-ioport.ads
$CP $gnatsrc/s-ioport-prep.adb ./runtimes/powerpc/prep/s-ioport.adb
$CP $gnatsrc/s-bbpara-ppc.ads ./runtimes/powerpc/s-bbpara.ads
$CP $gnatsrc/s-cerrno-zfp.adb ./runtimes/src/s-cerrno.adb
$CP $gnatsrc/s-cmallo-zfp.adb ./runtimes/src/s-cmallo.adb
$CP $gnatsrc/s-secsta-ppc.adb ./runtimes/src/s-secsta.adb
$CP $gnatsrc/s-c-zfp.ads ./runtimes/src/s-c.ads
$CP $gnatsrc/s-cmallo-zfp.ads ./runtimes/src/s-cmallo.ads
$CP $gnatsrc/s-cerrno-zfp.ads ./runtimes/src/s-cerrno.ads

# textio
$CP $gnatsrc/text_io.ads ./board-common/text_io.ads
$CP $gnatsrc/a-textio-zfp.ads ./board-common/a-textio.ads
$CP $gnatsrc/a-textio-zfp.adb ./board-common/a-textio.adb
$CP $gnatsrc/s-textio-zfp.ads ./board-common/s-textio.ads

# Fixme: use s-textio-prep for qemu (but requires s-ioports)
$CP $gnatsrc/s-textio-stdio.adb ./powerpc-elf/psim/s-textio.adb
$CP $gnatsrc/s-textio-stdio.adb ./powerpc-elf/qemu/s-textio.adb
$CP $gnatsrc/s-textio-stdio.adb ./powerpc-eabispe/qemu/s-textio.adb
$CP $gnatsrc/s-textio-memory.adb ./powerpc-eabispe/itmpc5554/s-textio.adb
$CP $gnatsrc/s-textio-avrtest.adb ./avr/avrtest/s-textio.adb
$CP $gnatsrc/s-textio-null.adb ./avr/at90usb128/s-textio.adb
$CP $gnatsrc/s-textio-erc32.adb ./erc32-elf/s-textio.adb
$CP $gnatsrc/s-textio-leon.adb ./leon-elf/s-textio.adb
$CP $gnatsrc/s-textio-leon3.adb ./leon3-elf/s-textio.adb
$CP $gnatsrc/s-textio-stdio.adb ./native/s-textio.adb

# An empty source when board-support has no sources.
$CP $gnatsrc/s-nil-zfp.ads ./empty-src/s-nil.ads
