static void
cputc (char c)
{
  asm volatile ("out 0x32,%0" : : "r"(c));
  /*  *(volatile char *)0x52 = c; */
}

static void
cputs (const char *s)
{
  while (*s)
    cputc (*s++);
}

void report_stacksize (unsigned int sz)
{
  char str[8];
  int i;

  cputs ("@@@stack size: ");
  str[7] = 0;
  for (i = 6; ; i--)
    {
      str[i] = '0' + (sz % 10);
      sz /= 10;
      if (sz == 0)
        {
          cputs (str + i);
          break;
        }
    }
  cputs (" bytes\n");
}
