/* STACKSIZE = 1 */
STACK_BYTE = 0xa5

SPL = 0x3d
SPH = 0x3e
SREG = 0x3f
RAMPZ = 0x3b

RAMEND = (64 * 1024)

	.weak	__stack
	.set	__stack, RAMEND - 1

.ifdef STACKSIZE
        .weak   __stack_start
       	.set	__stack_start, __stack - 2048
.endif
	.weak	__heap_end
	.set	__heap_end, 0


	.section .vectors,"ax",@progbits
	.global	__vectors
	.func	__vectors
__vectors:
__reset:
	jmp	__init
	.endfunc

	.section .init0,"ax",@progbits
	.weak	__init
;	.func	__init
__init:

	.section .init2,"ax",@progbits
	clr	r1
	out	0x3f, r1
	ldi	r28,lo8(__stack)
	ldi	r29,hi8(__stack)
	out	SPH, r29
	out	SPL, r28

.ifdef STACKSIZE
        /* Set marker in the stack space.  */
        ldi     r17,STACK_BYTE
	ldi	r26, lo8(__stack_start)
	ldi	r27, hi8(__stack_start)
0:      cp      r26, r28
        cpc     r27, r29
	breq	1f

        st      X+,r17
        rjmp    0b
1:
.endif

	/* Only for >64K devices with RAMPZ, replaces the default code
	   provided by libgcc.S which is only linked in if necessary.  */

	.section .init4,"ax",@progbits
	.global __do_copy_data
__do_copy_data:
	.global	__do_clear_bss
__do_clear_bss:
.if 0
	ldi	r17, hi8(__data_end)

	ldi	r26, lo8(__data_start)
	ldi	r27, hi8(__data_start)

	ldi	r30, lo8(__data_load_start)
	ldi	r31, hi8(__data_load_start)
	ldi	r16, hh8(__data_load_start)
	out	RAMPZ, r16

0:
	cpi	r26, lo8(__data_end)
	cpc	r27, r17
	breq	1f

	elpm	r0, Z+
	st	X+, r0
	rjmp	0b
1:
.endif

	.section .init9,"ax",@progbits
	call	main

.ifdef STACKSIZE
__stack_size_compute:
	ldi	r26, lo8(__stack_start)
	ldi	r27, hi8(__stack_start)
0:      ld      r17,X+
        cpi     r17,STACK_BYTE
	breq	0b
       	ldi	r24,lo8(__stack)
	ldi	r25,hi8(__stack)
        sub     r24,r26
        sbc     r25,r27
        adiw    r24, 2	/* Compensate X+ and __stack.  */
        call    report_stacksize
.endif

	jmp	exit
;	.endfunc

	.global	exit
	.func	exit
exit:	out 0x2f, r0
	.endfunc

	.global	abort
	.func	abort
abort:	out 0x29, r0
	.endfunc
