------------------------------------------------------------------------------
--                 S Y S T E M . C . M A L L O C . E X T                    --
--                                                                          --
--                       Copyright (C) 2011, AdaCore                        --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
------------------------------------------------------------------------------

package System.C.Malloc.Ext is
   subtype Image_String is String (1 .. 4 + Standard'Address_Size / 4);
   --  Subtype returned by Image function for an address

   function Image (A : Address) return Image_String;
   --  Return an image of address A.  Not unlike g-debuti.ads

   procedure Disp_Stats;
   --  Disp stats about the heap.

   procedure Check;
   --  Do an internal consistency.

   procedure Disp_Heap;
   --  Display the heap.
end System.C.Malloc.Ext;
