#!/bin/sh

# Ad-hoc script to run the ravenscar testsuite.

flag_continue=
flag_ignore_err=
flag_remove=y

while [ $# -ne 0 ]; do
  case $1 in
      -c) flag_continue=y ;;
      -k) flag_ignore_err=y ;;
      -*) echo "unknown option $1"; exit 1;;
      *) break
  esac
  shift
done

if [ $# -lt 2 ]; then
  echo "usage: $0 [-c] [-k] [config] ravenscar-testsuite-path [tests]"
  echo " -c : continue from previous run"
  echo " -k : do not stop in case of error"
  exit 1
fi

config=$1
testsuite_dir=$2
shift 2

build_file=`pwd`/build_output

case $config in
    ravenscar-sfp/prep-nofpu | ravenscar-sfp/prep | ravenscar-full/prep)
        support_dir=powerpc-elf
        discr="no_libc,no_serial_output,no_cache_control,no_accurate_clock,no_long_delay,powerpc,prep,powerpc-elf"
        cross=powerpc-elf-
        run=run_prep
        ;;
    ravenscar-sfp/leon)
        support_dir=leon-elf
        discr="no_libc,no_accurate_clock,no_cache_control,no_long_delay,sparc,leon"
        cross=sparc-elf-
        run=run_leon
        ;;
    *) echo "$0: unsupported config \"$config\""
        exit 2
        ;;
esac

case $config in
    ravenscar-sfp/*)
        discr="$discr,rts-ravenscar-sfp"
        ;;
    ravenscar-full/*)
        discr="$discr,rts-ravenscar"
        ;;
    *) echo "$0: unsupported config \"$config\" (2)"
        exit 2
        ;;
esac
set -e

run_prep()
{
 ~/work/qemu-couverture/ppc-softmmu/qemu-system-ppc -M prep -nographic -kernel $1 -no-reboot
}

run_leon()
{
 ~/work/qemu-couverture/sparc-softmmu/qemu-system-sparc -M at697 -nographic -kernel $1 -no-reboot
}

if [ "$flag_continue" != "y" ]; then
  rm -f $build_file
  rm -rf ravenscar
  mkdir ravenscar
fi

cd ravenscar
cat > sfp.gpr <<EOF
project sfp extends "../install/runtime" is
  for Source_Dirs use (".",
	"$testsuite_dir/support/target-support/$support_dir",
	"$testsuite_dir/support");
end sfp;
EOF

if [ $# -eq 0 ]; then
  files=`cd $testsuite_dir/tests; echo c/*.ada; echo d/*.ada; echo e/*.ada`
else
  if [ $# -eq 1 ]; then
     flag_remove=no
  fi
  testnames=$*
  files=`cd $testsuite_dir/tests; for i in $testnames; do echo ?/$i.ada; done`
fi

for file in $files;
do
    dead="false"
    xfail="false"
    options="-O0 -fno-inline"
    filename=`basename $file`
    name=${filename%\.*}

    if [ -f $name.res ]; then
        echo "Already run $name"
        continue;
    fi

    if [ -f $testsuite_dir/etc/$name.opt ]; then
      opt_out=`opt_parser $discr,32bits,ALL $testsuite_dir/etc/$name.opt`
      echo $opt_out
      eval "$opt_out"
    fi

    echo "================== $name ==================================";

    if [ "$dead" != "false" ]; then
       echo "$name:DEAD:$dead"
       echo "$name:DEAD:$dead" >> $build_file

    elif [ "$xfail" != "false" ]; then
       echo "$name:XFAIL:$xfail"
       echo "$name:XFAIL:$xfail" >> $build_file

    else
       ${cross}gnatchop -q -gnat05 -w -c $testsuite_dir/tests/$file
       ${cross}gnatmake -Psfp.gpr $options -gnat05 -o $name test

       if [ $? -ne 0 ]; then
          echo "$name:PROBLEM:error during compilation" >> $build_file
       else
          echo "$name:Compilation OK" >> $build_file
       fi

       $run $name | tee $name.res
       if ! grep -q PASSED $name.res; then
           echo "FAILURE : $name"
           echo "$name" >> failed
           if [ ! "$flag_ignore_err" = "y" ]; then
               break
           fi
       else
           if [ "$flag_remove" = "y" ]; then
              rm $name
           fi
       fi

       objs=`echo *.ad? | sed -e s/ad./o/g`
       if [ "$flag_remove" = "y" ]; then
          rm -f $objs *.ad?
       fi

#       leon3-elf-gnatclean test
    fi
done

if [ -f failed ]; then
  echo "Failures:"
  cat failed
  exit 1
fi

#rm *.o
#rm *.ali
#rm *.ads
#rm *.adb

