/* This is an -*- asm -*- file.  */
	.section ".text"
        .global _start

_start:
  	# Load the stack.
        lis   %r1,__stack_end@h
        ori   %r1,%r1,__stack_end@l

        # Allocate a cleared frame
        li    %r0,0
       	mtlr  %r0
	stwu  %r0,-16(1)

#ifndef NOFPU
        # Enable FPU.
	li    %r3,0x2000
	mtmsr %r3
#endif

        # Copy sdata2
	lis   %r11,(__sdata2_start - 1)@ha
	la    %r11,(__sdata2_start - 1)@l(%r11)
	lis   %r10,(__sdata2_end)@ha
        la    %r10,(__sdata2_end)@l(%r10)
        subf  %r10,%r11,%r10
	lis   %r8,(__sdata2_load - 1)@ha
	la    %r8,(__sdata2_load - 1)@l(%r8)
	mtctr %r10
	b     1f
0:      lbzu  %r4,1(%r8)
	stbu  %r4,1(%r11)
1:
	bdnz  0b

        # Copy data
	lis   %r11,(__data_start - 1)@ha
	la    %r11,(__data_start - 1)@l(%r11)
	lis   %r10,(__data_end)@ha
        la    %r10,(__data_end)@l(%r10)
        subf  %r10,%r11,%r10
	lis   %r8,(__data_load - 1)@ha
	la    %r8,(__data_load - 1)@l(%r8)
	mtctr %r10
	b     1f
0:      lbzu  %r4,1(%r8)
	stbu  %r4,1(%r11)
1:
	bdnz  0b

        # Clear sbss2
	lis   %r11,(__sbss2_start - 1)@ha
	la    %r11,(__sbss2_start - 1)@l(%r11)
	lis   %r10,(__sbss2_end)@ha
        la    %r10,(__sbss2_end)@l(%r10)
        subf  %r10,%r11,%r10
	mtctr %r10
	b     1f
0:	stbu  %r0,1(%r11)
1:
	bdnz  0b

        # Clear sbss
	lis   %r11,(__sbss_start - 1)@ha
	la    %r11,(__sbss_start - 1)@l(%r11)
	lis   %r10,(__sbss_end)@ha
        la    %r10,(__sbss_end)@l(%r10)
        subf  %r10,%r11,%r10
	mtctr %r10
	b     1f
0:	stbu  %r0,1(%r11)
1:
	bdnz  0b

        # Clear bss
	lis   %r11,(__bss_start - 1)@ha
	la    %r11,(__bss_start - 1)@l(%r11)
	lis   %r10,(__bss_end)@ha
        la    %r10,(__bss_end)@l(%r10)
        subf  %r10,%r11,%r10
	mtctr %r10
	b     1f
0:	stbu  %r0,1(%r11)
1:
	bdnz  0b

        # Run the program
	bl    main

        # Try to stop the machine
        bl    exit
	.size _start, . - _start

	.global __eabi
__eabi:
	blr
	.size __eabi, . - __eabi

	.section ".reset","ax"
_reset:
	b _start
	.size _reset, . - _reset
