------------------------------------------------------------------------------
--                          S Y S T E M .  I O                              --
--                                                                          --
--                    Copyright (C) 2010-2011, AdaCore                      --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
------------------------------------------------------------------------------

pragma Restrictions (No_Elaboration_Code);

with Interfaces;

package System.IOPorts is
   pragma Preelaborate;

   type Port_Id is range 0 .. 16#ffff#;
   --  IO port range.

   procedure Outb (P : Port_Id; B : Interfaces.Unsigned_8);
   pragma Inline (Outb);
   --  Write a byte to a port.

   function Inb (P : Port_Id) return Interfaces.Unsigned_8;
   pragma Inline (Inb);
   --  Read a byte from a port.

   procedure OS_Exit;
   pragma Export (Asm, OS_Exit, "exit");
   pragma No_Return (OS_Exit);
   --  Reset the board or shut-down the simulator.

   procedure OS_Abort;
   pragma Export (Asm, OS_Abort, "abort");
   pragma No_Return (OS_Abort);
   --  Same as OS_Exit.
end System.IOPorts;
