------------------------------------------------------------------------------
--                          S Y S T E M .  I O                              --
--                                                                          --
--                    Copyright (C) 2010-2011, AdaCore                      --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
------------------------------------------------------------------------------

with Interfaces; use Interfaces;

package body System.IOPorts is
   function Get_Port_Address (P : Port_Id) return Address;
   pragma Inline (Get_Port_Address);

   function Get_Port_Address (P : Port_Id) return Address is
   begin
      return System'To_Address (16#8000_0000# + Port_Id'Pos (P));
   end Get_Port_Address;

   procedure Outb (P : Port_Id; B : Unsigned_8) is
      Port_Byte : Unsigned_8;
      for Port_Byte'Address use Get_Port_Address (P);
   begin
      Port_Byte := B;
   end Outb;

   function Inb (P : Port_Id) return Interfaces.Unsigned_8 is
      Port_Byte : Unsigned_8;
      for Port_Byte'Address use Get_Port_Address (P);
   begin
      return Port_Byte;
   end Inb;

   procedure OS_Exit is
   begin
      Outb (16#92#, 0);
      Outb (16#92#, 1);

      --  Just in case.
      loop
         null;
      end loop;
   end OS_Exit;

   procedure OS_Abort renames OS_Exit;
end System.IOPorts;
