------------------------------------------------------------------------------
--                        S Y S T E M .  I 8 2 5 9                          --
--                                                                          --
--                    Copyright (C) 2010-2011, AdaCore                      --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
------------------------------------------------------------------------------

--  PC/AT-style I8259 interrupt controler (PIC)

pragma Restrictions (No_Elaboration_Code);

with Interfaces;

package System.I8259 is
   pragma Preelaborate;

   type Int_Id is range 0 .. 15;
   --  Interrupt Id.  Note that 0 is the highest priority.

   subtype Master_Int_Id is Int_Id range 0 .. 7;
   subtype Slave_Int_Id is Int_Id range 8 .. 15;

   function Get_Int_Id return Int_Id;
   --  Read the current interrupt

   procedure Initialize;
   --  Initialize the PICs.

   procedure EOI (Id : Int_Id);
   --  Declare end of interrupt.  The Id id needed to know wether the slave
   --  PIC is impacted.

   procedure Mask (Id : Int_Id);
   procedure Unmask (Id : Int_Id);
   --  Mask/Unmask an interrupt.
end System.I8259;
