------------------------------------------------------------------------------
--                                                                          --
--                  GNAT RUN-TIME LIBRARY (GNARL) COMPONENTS                --
--                                                                          --
--                   S Y S T E M . B B . P A R A M E T E R S                --
--                                                                          --
--                                  S p e c                                 --
--                                                                          --
--        Copyright (C) 1999-2002 Universidad Politecnica de Madrid         --
--             Copyright (C) 2003-2005 The European Space Agency            --
--                     Copyright (C) 2003-2010, AdaCore                     --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University.       --
-- Extensive contributions were provided by Ada Core Technologies, Inc.     --
--                                                                          --
-- The porting of GNARL to bare board  targets was initially  developed  by --
-- the Real-Time Systems Group at the Technical University of Madrid.       --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines basic parameters used by the low level tasking system

--  This is the PowerPC/MPC860 version of this package

with System.Parameters;
with System.Storage_Elements;

package System.BB.Parameters is
   pragma Pure;

   -----------------------
   -- Stack information --
   -----------------------

   --  Boundaries of the stack for the environment task, defined by the linker
   --  script file.

   Top_Of_Environment_Stack : constant System.Address;
   pragma Import (Asm, Top_Of_Environment_Stack, "__stack");
   --  Top of the stack to be used by the environment task

   Bottom_Of_Environment_Stack : constant System.Address;
   pragma Import (Asm, Bottom_Of_Environment_Stack, "_stack_start");
   --  Bottom of the stack to be used by the environment task

   --------------------
   -- Hardware clock --
   --------------------

   Clock_Frequency : constant Positive := 3_125_000;
   --  Frequency of the system clock for the decrementer timer

   ----------------
   -- Interrupts --
   ----------------

   --  The followings are PowerPC/MPC860 definitions and they cannot
   --  be modified for an PowerPC/MPC860 target.

   --  These definitions are in this package in order to isolate target
   --  dependencies.

   Interrupt_Levels : constant Positive := 32;
   --  Number of interrupt levels in the PPC architecture

   Trap_Vectors : constant Positive := 32;
   --  The PowerPC architecture supports 32 vectors

   subtype External_Interrupt_Level is Natural range 0 .. 7;
   --  This is an MPC860 specific constant

   subtype Interrupt_Level is Natural range 0 .. Interrupt_Levels;
   --  Type that defines the range of possible interrupt levels

   subtype Range_Of_Vector is Natural range 0 .. 31 * 16#100#;
   --  The PowerPC architecture supports 31 vectors,
   --  each vector has a size of 16#100# byte

   ------------------------
   -- Context Management --
   ------------------------

   --  The PowerPC processor needs to save:
   --
   --   * 32 integer registers of 32 bits (30 GPRs, CR, LR) for normal
   --     processing
   --
   --   * the argument passed in initialize context

   Context_Buffer_Capacity : constant := 34;

   ------------
   -- Stacks --
   ------------

   Interrupt_Stack_Size : constant := 4 * 1024;  --  bytes
   --  Size of each of the interrupt stacks

end System.BB.Parameters;
