##############################################################################
#                                                                            #
#                         Copyright (C) 2005, AdaCore                        #
#                                                                            #
#                               Assembly File                                #
#                                                                            #
##############################################################################

	
#       This file defines functions
#       to access registers of a PowerPC
#
	
	
	MSR_EE=0x00008000

	.globl disable_external_interrupt
	.type  disable_external_interrupt, @function
disable_external_interrupt:
	mfmsr  3
	addis  4, 0, MSR_EE@h
	ori    4, 4, MSR_EE@l
	andc   3, 3, 4
	mtmsr  3
	blr
	
	.globl enable_external_interrupt
	.type  enable_external_interrupt, @function
enable_external_interrupt:
	mfmsr  3
	addis  4, 0, MSR_EE@h
	ori    4, 4, MSR_EE@l
	or     3, 3, 4
	mtmsr  3
	blr
	
	.globl get_decrementer
	.type  get_decrementer, @function
get_decrementer:
	mfdec 3		# get content of decrementer and move it to R3
	blr

	.globl set_decrementer
	.type  set_decrementer, @function
set_decrementer:
	mtdec 3		# load content of R3 to decrementer
	blr

        .globl get_timebase
        .type   get_timebase, @function
get_timebase:
        mftb 3   # move content of time base register to return register R3
        blr      #

        .globl get_timebase_upper
        .type   get_timebase_upper, @function
get_timebase_upper:
        mftbu 3   # move content of time base register to return register R3
        blr      #

	
	        .globl get_srr0
        .type   get_srr0     , @function
get_srr0:
        mfsrr0 3 # move content of SRR0 register to return register R3
        blr      #

        .globl get_srr1
        .type   get_srr1     , @function
get_srr1:
        mfsrr1 3 # move content of SRR1 register to return register R3
        blr      #
	
        .globl get_msr
        .type   get_msr     , @function
get_msr:
        mfmsr 3 # move content of Machine State Register to return R3
        blr      #
	

        .globl set_msr
        .type  set_msr     , @function
set_msr:
        mtmsr 3 # set content of Machine State Register to content of R3
        blr      #

	.globl system_call
	.type  system_call  , @function
system_call:
	sync
	isync
	sc
	blr