#!/bin/sh

# You can use ln for debugging (option --link).
CP=cp

verbose=
objdir=install
debug=0
crossdir=cross-dir
libm=""

set -e

while [ $# -ne 0 ]; do
  case $1 in
      -v) verbose=y ;;
      -d) debug=`expr $debug + 1`;;
      --output=*) objdir=`echo $1 | sed -e s/^--output=//`;;
      --cross-dir=*) crossdir=`echo $1 | sed -e s/^--cross-dir=//`;;
      --objdir=*) objdir=`echo $1 | sed -e s/^--objdir=//`;;
      --libm=*) libm=`echo $1 | sed -e s/^--libm=//`;;
      --link) CP="ln -s";;
      -*) echo "unknown option $1"; exit 1;;
      *) break
  esac
  shift
done

if [ $# -ne 2 ]; then
  echo "Usage: $0 [-v] [-o dir] config gnat-src"
  exit 1
fi

config=$1
gnatsrc=$2

if [ -d $objdir ]; then
  echo "Object dir \"$objdir\" already exists"
  exit 1
fi

# Create directories.
mkdir $objdir
mkdir $objdir/arch
mkdir $objdir/common
mkdir $objdir/obj
mkdir $objdir/lib

discarded_sources="none"

prep_arch_files="../board-common/a-textio.ads ../board-common/text_io.ads
		 powerpc/prep/qemu-rom.ld
		 powerpc/prep/qemu-ram.ld
		 powerpc/prep/start-rom.S
		 powerpc/prep/start-ram.S
		 powerpc/prep/setup.S
		 powerpc/prep/s-ioport.ads powerpc/prep/s-ioport.adb
                 powerpc/prep/s-i8259.ads powerpc/prep/s-i8259.adb
                 powerpc/prep/a-textio.adb"

extra_target_pairs=

# Sources for flexible run-times:
# mem_src: memcpy, memset, memcmp, memmove, last_chance_handler
# img_src: s-imgint, s-imglli, s-imgboo, memory
mem_src="memory_set.ads memory_set.adb
	 memory_copy.ads memory_copy.adb
	 memory_compare.ads memory_compare.adb
	 last_chance_handler.ads last_chance_handler.adb"
img_src="s-imgint.ads s-imgint.adb
	 s-imglli.ads s-imglli.adb
	 s-imgboo.ads s-imgboo.adb
	 s-memory.ads s-memory.adb"

# The RTS which is based on.
# Used to copy file using Makefile.hie
gnat_rts=

# Project file for zfp-support configs
zfp_support_prj_files="$PWD/support-prj/runtime.gpr
        $PWD/support-prj/runtime_build.gpr
        $PWD/support-prj/support.gpr"

case $config in
    "zfp-support/p55-prep")
        gnat_rts=
        # FIXME: use powerpc/prep/a-textio.adb ?
	arch_files="../powerpc-eabispe/qemu/start.s
		   ../board-common/a-textio.ads ../board-common/text_io.ads
		   ../powerpc-elf/a-textio.adb
	           ../powerpc-elf/qemu/c_io.c
		   ../powerpc-elf/qemu/ppc_qemu.ld"
        mem_src="$mem_src
                 secondary_stack.ads secondary_stack.adb"
        $CP $zfp_support_prj_files $objdir/
	;;
    "zfp-support/prep")
        gnat_rts=
	arch_files="../powerpc-elf/qemu/start.s
		   ../board-common/a-textio.ads ../board-common/text_io.ads
		   ../powerpc-elf/a-textio.adb
	           ../powerpc-elf/qemu/c_io.c
		   ../powerpc-elf/qemu/ppc_qemu.ld"
        mem_src="$mem_src
                 secondary_stack.ads secondary_stack.adb"
        $CP $zfp_support_prj_files $objdir/
	;;
    "zfp/prep")
        gnat_rts=zfp
        gnat_target=powerpc-elf
        arch_files=$prep_arch_files
        override_path="powerpc"
        mem_src="$mem_src
                 secondary_stack.ads secondary_stack.adb"
        $CP $PWD/powerpc/prep/zfp.gpr $objdir/runtime.gpr
        $CP $PWD/powerpc/prep/zfp_build.gpr $objdir/runtime_build.gpr
        ;;
    "ravenscar-sfp/prep" \
  | "ravenscar-sfp/prep-nofpu" )
        gnat_rts=ravenscar-sfp
        gnat_target=powerpc-elf
        if [ "$config" = "ravenscar-sfp/prep" ]; then
          sed -e "s/zfp/sfp/g" \
              < powerpc/prep/zfp.gpr > $objdir/runtime.gpr
          sed -e "s/zfp/sfp/g" \
              < powerpc/prep/zfp_build.gpr > $objdir/runtime_build.gpr
        else
          sed -e "s/zfp/sfp/g" -e "s/-mhard-float/-msoft-float/g" \
            < powerpc/prep/zfp.gpr > $objdir/runtime.gpr
          $CP $PWD/powerpc/prep/ravenscar_sfp_nofpu_build.gpr \
	     $objdir/runtime_build.gpr
        fi
        override_path="powerpc/sfp powerpc/prep powerpc src"
        arch_files="$prep_arch_files
		    powerpc/6xx/handler.S powerpc/6xx/context_switch.S"
        discarded_sources="s-bbseou.ads s-bbseou.adb s-sssita.ads s-sssita.adb"
        extra_target_pairs="s-multip.adb:s-multip-raven-default.adb"
        ;;
    "ravenscar-full/prep" )
        gnat_rts=ravenscar
        gnat_target=powerpc-elf
        prj="powerpc/prep/ravenscar_full"
        # Ravenscar depends on -lm (for math routines), which also
        # depends on ravenscar (for errno).
        sed -e 's@(\(.*\)/libzfp.a"@(\1/libravenscar.a",\
                \1/libm.a", \1/libravenscar.a"@' \
            < powerpc/prep/zfp.gpr > $objdir/runtime.gpr
        sed -e "s/zfp/ravenscar/g" \
            < powerpc/prep/zfp_build.gpr > $objdir/runtime_build.gpr
        override_path="powerpc/full powerpc/prep powerpc"
        arch_files="$prep_arch_files
		    powerpc/6xx/handler.S powerpc/6xx/context_switch.S
                    src/s-io.adb src/s-c.ads
                    src/s-cerrno.ads src/s-cerrno.adb
		    src/s-cmallo.ads src/s-cmallo.adb"
        discarded_sources="s-bbseou.ads s-bbseou.adb"
        extra_target_pairs="s-multip.adb:s-multip-raven-default.adb"
        # No need to build img_src as they are already in the RTS.
        img_src=""
        if [ "$libm" = "" ]; then
            echo "installation of libm is required (use --libm=)"
            exit 1
        fi
        ;;
    "ravenscar-sfp/leon")
        gnat_rts=ravenscar-sfp
        gnat_target=leon-elf
        arch_files="../board-common/a-textio.ads ../board-common/text_io.ads
		../leon-elf/a-textio.adb
		$crossdir/bare_board/libbareboard/leon-elf/leon.ld
		$crossdir/bare_board/libbareboard/leon-elf/crt0.S"
        $CP $PWD/sparc/leon/ravenscar_sfp.gpr $objdir/runtime.gpr
        $CP $PWD/sparc/leon/ravenscar_sfp_build.gpr $objdir/runtime_build.gpr
        ;;
    *)
        echo "error: unknown config \"$config\""
        exit 1
        ;;
esac

# Build list of sources.
if [ "$gnat_rts" != "" ]; then
  defs=`make -f $gnatsrc/Makefile.hie RTS=$gnat_rts TARGET=$gnat_target GNAT_SRC_DIR=$gnatsrc show-sources`

  # Get them.
  eval $defs

  if [ $debug -ge 1 ]; then
    echo "Defs:"
    echo $defs
  fi

  set -e

  sedcmd=""
  for i in $extra_target_pairs $TARGET_PAIRS; do
    sedcmd="$sedcmd -e s:$i:"
  done

  # Create the list of source files.
  all_sources="$LIBGNAT_SOURCES $LIBGNARL_SOURCES $LIBGNAT_NON_COMPILABLE_SOURCES"

  for f in $discarded_sources; do
    all_sources=`echo $all_sources | sed -e "s/$f//"`
  done

  if [ "$verbose" = "y" ]; then
    echo "Sources:"
    echo $all_sources
  fi

  # Copy sources.
  for f in $all_sources; do
    dest=$objdir/common/$f

    override=
    for p in $override_path; do
      if [ -f $p/$f ]; then
          override=$PWD/$p/$f
          dest=$objdir/arch/$f
          break
      fi
    done

    if [ "$override" = "" ]; then
#      if [ "$f" = "s-secsta.ads" ]; then
#          sed -e "/Default_Secondary_Stack_Size : /s/ := .*;/ := 512;/" \
#              < $gnatsrc/$tf > $objdir/$f
#      fi
      override=$gnatsrc/`echo $f | sed $sedcmd`
    fi

    if [ "$verbose" = "y" ]; then  
      echo "Copying $override"
    fi
    $CP $override $dest
  done
fi

# Copy some zfp sources
for f in $mem_src $img_src; do
   $CP $PWD/../zfp-src/$f $objdir/common/$f
done

# Copy arch files
for f in $arch_files; do
   case $f in
       /*) $CP $f $objdir/arch/`basename $f`;;
        *) $CP $PWD/$f $objdir/arch/`basename $f`;;
   esac
done

# Create rts path files
if [ "$gnat_rts" != "" ]; then
    echo lib > $objdir/ada_object_path
    cat > $objdir/ada_source_path <<EOF
common
arch
EOF
fi

# Copy libm.
if [ "$libm" != "" ]; then
  $CP $libm $objdir/lib
fi

exit 0
