#!/bin/sh

set -e

GNAT_SRC_DIR=~/Repositories/adacore/gnat
CROSS_DIR=~/Repositories/adacore/cross
TESTSUITE_DIR=~/Repositories/adacore/gnatmail/testsuites/ravenscar
ACATS_DIR=~/Repositories/adacore/gnatmail/testsuites/acats
LIBM_PATH=~/work/newlib-ppc/powerpc-elf/newlib/libm.a

build_opts=""
src_opts="--link"
flag_tests=n
flag_clean=y

build_rts()
{
    prefix=$1
    config=$2
    shift 2
    
    opts=$*

    if [ "$flag_clean" = "y" ]; then
        rm -rf install
        ./build-rts.sh $src_opts $opts $config $GNAT_SRC_DIR
    fi
    gprbuild --target=$prefix -Pinstall/runtime_build.gpr $build_opts
    chmod a-w install/lib/*.ali
}

build_raven_example()
{
    prefix=$1

    cd examples/tasks-sfp
    rm -f *.ali *.o
    ${prefix}-gnatmake -Phello_sfp test
    cd ../..
}

raven_testsuite()
{
    config=$1

    ./run-tests.sh $config $TESTSUITE_DIR
}

do_zfp()
{
    prefix=$1
    config=$2
    shift 2
    
    opts=$*

    build_rts $prefix $config $opts
}

do_ravenscar()
{
    prefix=$1
    config=$2
    shift 2
    
    opts=$*

    build_rts $prefix $config $opts

    build_raven_example $prefix

    if [ "$flag_tests" = "y" ]; then
        raven_testsuite $config
    fi
}

build_sfp_prep_nofpu()
{
    do_ravenscar powerpc-elf ravenscar-sfp/prep-nofpu
}

build_sfp_prep()
{
    do_ravenscar powerpc-elf ravenscar-sfp/prep
}

build_full_prep()
{
    do_ravenscar powerpc-elf ravenscar-full/prep --libm=$LIBM_PATH
}

build_zfp_prep()
{
    do_zfp powerpc-elf zfp/prep
}

build_leon_sfp()
{
    do_ravenscar sparc-elf ravenscar-sfp/leon --cross-dir=$CROSS_DIR
}

build_zfp_support_prep()
{
    do_zfp powerpc-elf zfp-support/prep
}

build_stub()
{
  prefix=$1

  rm -rf stub
  mkdir stub
  cd stub
  ln -s ../powerpc/gdbstub/*.ad? .
  ln -s ../powerpc/gdbstub/*.S .
  cat > stub.gpr <<EOF
project Stub extends "../install/runtime" is
  for Languages use ("Ada", "Asm_Cpp");
  for Source_Dirs use (".");
  package Compiler is
     for Switches ("Ada") use Runtime.Compiler'Default_Switches ("Ada")
         & ("-gnatyg", "-gnatwn", "-g");
  end Compiler;

end Stub;
EOF
  gprbuild --target=$prefix -Pstub stub
}

run_acats_full()
{
    rm -rf acats
    mkdir acats
    cd acats
    $ACATS_DIR/run_acats_test.py -d stack,ravenscar --rts=ravenscar --target=ppc-elf,,qemu --project=$PWD/../install/runtime.gpr -a $ACATS_DIR
}

if [ $# -eq 0 ]; then
  #build_leon_sfp
  #build_sfp_prep_nofpu
  #build_zfp_prep
  #build_stub powerpc-elf

  #build_sfp_prep
  #build_zfp_support_prep
  build_full_prep
else
  # Parse options.
  while [ $# -gt 0 ]; do
      case $1 in
          -g) build_opts="$build_opts -g";;
          -t) flag_tests=y;;
          -v) src_opts="$src_opts -v";;
          --no-clean) flag_clean=n;;
          -*) echo "unhandled option $1"; exit 2;;
          *) break;;
      esac
      shift
  done

  # Parse commands
  for opt; do
      case $opt in
          full) build_full_prep ;;
          sfp)  build_sfp_prep ;;
          zfp)  build_zfp_prep ;;
          stub) build_stub powerpc-elf ;;
          raven-testsuite) raven_testsuite ravenscar-full/prep ;;
          acats) run_acats_full ;;
             *) echo "Unknown command $opt"; exit 2;;
      esac
  done
fi
