--  Dummy version that contains minimal output procedure (which do nothing).
package body Ada.Text_IO is

   --  In memory output emulation.
   --  Export symbols so that gdb can easily find them.
   Output : String (1 .. 2048);
   pragma Import (C, Output, "textio_output");
   Output_Len : Natural;
   pragma Import (C, Output_Len, "textio_output_len");

   procedure Put (Item : Character) is
   begin
      Output_Len := Output_Len + 1;
      if Output_Len <= Output'Last then
         Output (Output_Len) := Item;
      end if;
   end Put;

   procedure New_Line is
   begin
      Put (Character'Val (10));
   end New_Line;

   procedure Put (Item : String) is
   begin
      for I in Item'Range loop
         Put (Item (I));
      end loop;
   end Put;

   procedure Put_Line (Item : String) is
   begin
      Put (Item);
      New_Line;
   end Put_Line;

end Ada.Text_IO;
