#include <stdio.h>
#include <string.h>
/*
 * _EPPCBug_pollWrite
 *
 *  Output buffer through EPPCBug. Returns only once every character has been
 *  sent (polled output).
 *
 *  Input parameters:
 *    buf - output buffer
 *    len - number of chars to output
 *
 *  Output parameters:  NONE
 *
 *  Return value: 0 if successfull, -1 else
 */
int bug_putstring(
  const char *buf,
  int len
)
{
  char bufcopy[len + 1];
  strncpy (bufcopy, buf, len);
  bufcopy[len] = '\0';

  printf ("%s", bufcopy);
  return 0;
}

int bug_putchar(
  const char c,
  int len
)
{
  printf ("%c", c);
  return 0;
}

int bug_putnl(void)
{
  printf ("\n");
  return 0;
}
