-----------------------------------------------------------------------
--                XML/Ada - An XML suite for Ada95                   --
--                                                                   --
--                       Copyright (C) 2001-2005                     --
--                            ACT-Europe                             --
--                                                                   --
-- This library is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public               --
-- License as published by the Free Software Foundation; either      --
-- version 2 of the License, or (at your option) any later version.  --
--                                                                   --
-- This library is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this library; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-----------------------------------------------------------------------

package body DOM.Core.Attrs is

   ---------------
   -- Specified --
   ---------------

   function Specified (Att : Attr) return Boolean is
   begin
      return Att.Specified;
   end Specified;

   -------------------
   -- Owner_Element --
   -------------------

   function Owner_Element (Att : Attr) return Element is
   begin
      if Att.Owner_Element.Node_Type = Element_Node then
         return Att.Owner_Element;
      else
         return null;
      end if;
   end Owner_Element;

   -----------
   -- Is_Id --
   -----------

   function Is_Id (Att : Attr) return Boolean is
   begin
      return Att.Is_Id;
   end Is_Id;

end DOM.Core.Attrs;
