------------------------------------------------------------------------------
--                                  wPOSIX                                  --
--                                                                          --
--                       Copyright (C) 2014, AdaCore                        --
--                                                                          --
--  This is free software;  you can redistribute it  and/or modify it       --
--  under terms of the  GNU General Public License as published  by the     --
--  Free Software  Foundation;  either version 3,  or (at your option) any  --
--  later version.  This software is distributed in the hope  that it will  --
--  be useful, but WITHOUT ANY WARRANTY;  without even the implied warranty --
--  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU     --
--  General Public License for  more details.                               --
--                                                                          --
--  You should have  received  a copy of the GNU General  Public  License   --
--  distributed  with  this  software;   see  file COPYING3.  If not, go    --
--  to http://www.gnu.org/licenses for a complete copy of the license.      --
------------------------------------------------------------------------------

with Ada.Command_Line;
with Ada.Strings.Fixed;
with Ada.Text_IO;

with POSIX;

procedure System_Name is

   use Ada;

   use POSIX;

   SN : constant POSIX_String := POSIX.System_Name;

begin
   if Command_Line.Argument_Count = 1 then
      Text_IO.Put_Line (To_String (SN));
   end if;

   if Strings.Fixed.Index (To_String (SN), "Windows") = 0 then
      Text_IO.Put_Line ("NOK");
   else
      Text_IO.Put_Line ("OK");
   end if;
end System_Name;
