------------------------------------------------------------------------------
--                                  wPOSIX                                  --
--                                                                          --
--                     Copyright (C) 2008-2012, AdaCore                     --
--                                                                          --
--  This library is free software;  you can redistribute it and/or modify   --
--  it under terms of the  GNU General Public License  as published by the  --
--  Free Software  Foundation;  either version 3,  or (at your  option) any --
--  later version. This library is distributed in the hope that it will be  --
--  useful, but WITHOUT ANY WARRANTY;  without even the implied warranty of --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                    --
--                                                                          --
--  As a special exception under Section 7 of GPL version 3, you are        --
--  granted additional permissions described in the GCC Runtime Library     --
--  Exception, version 3.1, as published by the Free Software Foundation.   --
--                                                                          --
--  You should have received a copy of the GNU General Public License and   --
--  a copy of the GCC Runtime Library Exception along with this program;    --
--  see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see   --
--  <http://www.gnu.org/licenses/>.                                         --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
------------------------------------------------------------------------------

package body POSIX.Permissions is

   Dummy_Process_Permission_Set : Permission_Set := Owner_Permission_Set;

   -------------------------------------
   -- Get_Allowed_Process_Permissions --
   -------------------------------------

   function Get_Allowed_Process_Permissions return Permission_Set is
   begin
      return Dummy_Process_Permission_Set;
   end Get_Allowed_Process_Permissions;

   -------------------------------------
   -- Set_Allowed_Process_Permissions --
   -------------------------------------

   procedure Set_Allowed_Process_Permissions
     (Permissions : Permission_Set) is
   begin
      Dummy_Process_Permission_Set := Permissions;
   end Set_Allowed_Process_Permissions;

   -------------------------------------
   -- Set_Allowed_Process_Permissions --
   -------------------------------------

   procedure Set_Allowed_Process_Permissions
     (Permissions :        Permission_Set;
      Old_Perms   :    out Permission_Set) is
   begin
      Old_Perms := Dummy_Process_Permission_Set;
      Dummy_Process_Permission_Set := Permissions;
   end Set_Allowed_Process_Permissions;

end POSIX.Permissions;
