-------------------------------------------------------------------------------
--
--  THIS FILE AND ANY ASSOCIATED DOCUMENTATION IS FURNISHED "AS IS"
--  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
--  BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY
--  AND/OR FITNESS FOR A PARTICULAR PURPOSE.  The user assumes the
--  entire risk as to the accuracy and the use of this file.
--
--  Copyright (C) Intermetrics, Inc. 1995
--  Royalty-free, unlimited, worldwide, non-exclusive use, modification,
--  reproduction and further distribution of this file is permitted.
--
--  This file is now maintained and made available by AdaCore under
--  the same terms.
--
--  Copyright (C) 2000-2010, AdaCore
--
-------------------------------------------------------------------------------

package Win32.Winerror is

   FACILITY_WINDOWS                        : constant := 8;
   FACILITY_STORAGE                        : constant := 3;
   FACILITY_RPC                            : constant := 1;
   FACILITY_WIN32                          : constant := 7;
   FACILITY_CONTROL                        : constant := 10;
   FACILITY_NULL                           : constant := 0;
   FACILITY_ITF                            : constant := 4;
   FACILITY_DISPATCH                       : constant := 2;
   ERROR_SUCCESS                           : constant := 0;
   NO_ERROR                                : constant := 0;
   ERROR_INVALID_FUNCTION                  : constant := 1;
   ERROR_FILE_NOT_FOUND                    : constant := 2;
   ERROR_PATH_NOT_FOUND                    : constant := 3;
   ERROR_TOO_MANY_OPEN_FILES               : constant := 4;
   ERROR_ACCESS_DENIED                     : constant := 5;
   ERROR_INVALID_HANDLE                    : constant := 6;
   ERROR_ARENA_TRASHED                     : constant := 7;
   ERROR_NOT_ENOUGH_MEMORY                 : constant := 8;
   ERROR_INVALID_BLOCK                     : constant := 9;
   ERROR_BAD_ENVIRONMENT                   : constant := 10;
   ERROR_BAD_FORMAT                        : constant := 11;
   ERROR_INVALID_ACCESS                    : constant := 12;
   ERROR_INVALID_DATA                      : constant := 13;
   ERROR_OUTOFMEMORY                       : constant := 14;
   ERROR_INVALID_DRIVE                     : constant := 15;
   ERROR_CURRENT_DIRECTORY                 : constant := 16;
   ERROR_NOT_SAME_DEVICE                   : constant := 17;
   ERROR_NO_MORE_FILES                     : constant := 18;
   ERROR_WRITE_PROTECT                     : constant := 19;
   ERROR_BAD_UNIT                          : constant := 20;
   ERROR_NOT_READY                         : constant := 21;
   ERROR_BAD_COMMAND                       : constant := 22;
   ERROR_CRC                               : constant := 23;
   ERROR_BAD_LENGTH                        : constant := 24;
   ERROR_SEEK                              : constant := 25;
   ERROR_NOT_DOS_DISK                      : constant := 26;
   ERROR_SECTOR_NOT_FOUND                  : constant := 27;
   ERROR_OUT_OF_PAPER                      : constant := 28;
   ERROR_WRITE_FAULT                       : constant := 29;
   ERROR_READ_FAULT                        : constant := 30;
   ERROR_GEN_FAILURE                       : constant := 31;
   ERROR_SHARING_VIOLATION                 : constant := 32;
   ERROR_LOCK_VIOLATION                    : constant := 33;
   ERROR_WRONG_DISK                        : constant := 34;
   ERROR_SHARING_BUFFER_EXCEEDED           : constant := 36;
   ERROR_HANDLE_EOF                        : constant := 38;
   ERROR_HANDLE_DISK_FULL                  : constant := 39;
   ERROR_NOT_SUPPORTED                     : constant := 50;
   ERROR_REM_NOT_LIST                      : constant := 51;
   ERROR_DUP_NAME                          : constant := 52;
   ERROR_BAD_NETPATH                       : constant := 53;
   ERROR_NETWORK_BUSY                      : constant := 54;
   ERROR_DEV_NOT_EXIST                     : constant := 55;
   ERROR_TOO_MANY_CMDS                     : constant := 56;
   ERROR_ADAP_HDW_ERR                      : constant := 57;
   ERROR_BAD_NET_RESP                      : constant := 58;
   ERROR_UNEXP_NET_ERR                     : constant := 59;
   ERROR_BAD_REM_ADAP                      : constant := 60;
   ERROR_PRINTQ_FULL                       : constant := 61;
   ERROR_NO_SPOOL_SPACE                    : constant := 62;
   ERROR_PRINT_CANCELLED                   : constant := 63;
   ERROR_NETNAME_DELETED                   : constant := 64;
   ERROR_NETWORK_ACCESS_DENIED             : constant := 65;
   ERROR_BAD_DEV_TYPE                      : constant := 66;
   ERROR_BAD_NET_NAME                      : constant := 67;
   ERROR_TOO_MANY_NAMES                    : constant := 68;
   ERROR_TOO_MANY_SESS                     : constant := 69;
   ERROR_SHARING_PAUSED                    : constant := 70;
   ERROR_REQ_NOT_ACCEP                     : constant := 71;
   ERROR_REDIR_PAUSED                      : constant := 72;
   ERROR_FILE_EXISTS                       : constant := 80;
   ERROR_CANNOT_MAKE                       : constant := 82;
   ERROR_FAIL_I24                          : constant := 83;
   ERROR_OUT_OF_STRUCTURES                 : constant := 84;
   ERROR_ALREADY_ASSIGNED                  : constant := 85;
   ERROR_INVALID_PASSWORD                  : constant := 86;
   ERROR_INVALID_PARAMETER                 : constant := 87;
   ERROR_NET_WRITE_FAULT                   : constant := 88;
   ERROR_NO_PROC_SLOTS                     : constant := 89;
   ERROR_TOO_MANY_SEMAPHORES               : constant := 100;
   ERROR_EXCL_SEM_ALREADY_OWNED            : constant := 101;
   ERROR_SEM_IS_SET                        : constant := 102;
   ERROR_TOO_MANY_SEM_REQUESTS             : constant := 103;
   ERROR_INVALID_AT_INTERRUPT_TIME         : constant := 104;
   ERROR_SEM_OWNER_DIED                    : constant := 105;
   ERROR_SEM_USER_LIMIT                    : constant := 106;
   ERROR_DISK_CHANGE                       : constant := 107;
   ERROR_DRIVE_LOCKED                      : constant := 108;
   ERROR_BROKEN_PIPE                       : constant := 109;
   ERROR_OPEN_FAILED                       : constant := 110;
   ERROR_BUFFER_OVERFLOW                   : constant := 111;
   ERROR_DISK_FULL                         : constant := 112;
   ERROR_NO_MORE_SEARCH_HANDLES            : constant := 113;
   ERROR_INVALID_TARGET_HANDLE             : constant := 114;
   ERROR_INVALID_CATEGORY                  : constant := 117;
   ERROR_INVALID_VERIFY_SWITCH             : constant := 118;
   ERROR_BAD_DRIVER_LEVEL                  : constant := 119;
   ERROR_CALL_NOT_IMPLEMENTED              : constant := 120;
   ERROR_SEM_TIMEOUT                       : constant := 121;
   ERROR_INSUFFICIENT_BUFFER               : constant := 122;
   ERROR_INVALID_NAME                      : constant := 123;
   ERROR_INVALID_LEVEL                     : constant := 124;
   ERROR_NO_VOLUME_LABEL                   : constant := 125;
   ERROR_MOD_NOT_FOUND                     : constant := 126;
   ERROR_PROC_NOT_FOUND                    : constant := 127;
   ERROR_WAIT_NO_CHILDREN                  : constant := 128;
   ERROR_CHILD_NOT_COMPLETE                : constant := 129;
   ERROR_DIRECT_ACCESS_HANDLE              : constant := 130;
   ERROR_NEGATIVE_SEEK                     : constant := 131;
   ERROR_SEEK_ON_DEVICE                    : constant := 132;
   ERROR_IS_JOIN_TARGET                    : constant := 133;
   ERROR_IS_JOINED                         : constant := 134;
   ERROR_IS_SUBSTED                        : constant := 135;
   ERROR_NOT_JOINED                        : constant := 136;
   ERROR_NOT_SUBSTED                       : constant := 137;
   ERROR_JOIN_TO_JOIN                      : constant := 138;
   ERROR_SUBST_TO_SUBST                    : constant := 139;
   ERROR_JOIN_TO_SUBST                     : constant := 140;
   ERROR_SUBST_TO_JOIN                     : constant := 141;
   ERROR_BUSY_DRIVE                        : constant := 142;
   ERROR_SAME_DRIVE                        : constant := 143;
   ERROR_DIR_NOT_ROOT                      : constant := 144;
   ERROR_DIR_NOT_EMPTY                     : constant := 145;
   ERROR_IS_SUBST_PATH                     : constant := 146;
   ERROR_IS_JOIN_PATH                      : constant := 147;
   ERROR_PATH_BUSY                         : constant := 148;
   ERROR_IS_SUBST_TARGET                   : constant := 149;
   ERROR_SYSTEM_TRACE                      : constant := 150;
   ERROR_INVALID_EVENT_COUNT               : constant := 151;
   ERROR_TOO_MANY_MUXWAITERS               : constant := 152;
   ERROR_INVALID_LIST_FORMAT               : constant := 153;
   ERROR_LABEL_TOO_LONG                    : constant := 154;
   ERROR_TOO_MANY_TCBS                     : constant := 155;
   ERROR_SIGNAL_REFUSED                    : constant := 156;
   ERROR_DISCARDED                         : constant := 157;
   ERROR_NOT_LOCKED                        : constant := 158;
   ERROR_BAD_THREADID_ADDR                 : constant := 159;
   ERROR_BAD_ARGUMENTS                     : constant := 160;
   ERROR_BAD_PATHNAME                      : constant := 161;
   ERROR_SIGNAL_PENDING                    : constant := 162;
   ERROR_MAX_THRDS_REACHED                 : constant := 164;
   ERROR_LOCK_FAILED                       : constant := 167;
   ERROR_BUSY                              : constant := 170;
   ERROR_CANCEL_VIOLATION                  : constant := 173;
   ERROR_ATOMIC_LOCKS_NOT_SUPPORTED        : constant := 174;
   ERROR_INVALID_SEGMENT_NUMBER            : constant := 180;
   ERROR_INVALID_ORDINAL                   : constant := 182;
   ERROR_ALREADY_EXISTS                    : constant := 183;
   ERROR_INVALID_FLAG_NUMBER               : constant := 186;
   ERROR_SEM_NOT_FOUND                     : constant := 187;
   ERROR_INVALID_STARTING_CODESEG          : constant := 188;
   ERROR_INVALID_STACKSEG                  : constant := 189;
   ERROR_INVALID_MODULETYPE                : constant := 190;
   ERROR_INVALID_EXE_SIGNATURE             : constant := 191;
   ERROR_EXE_MARKED_INVALID                : constant := 192;
   ERROR_BAD_EXE_FORMAT                    : constant := 193;
   ERROR_ITERATED_DATA_EXCEEDS_64K         : constant := 194;
   ERROR_INVALID_MINALLOCSIZE              : constant := 195;
   ERROR_DYNLINK_FROM_INVALID_RING         : constant := 196;
   ERROR_IOPL_NOT_ENABLED                  : constant := 197;
   ERROR_INVALID_SEGDPL                    : constant := 198;
   ERROR_AUTODATASEG_EXCEEDS_64K           : constant := 199;
   ERROR_RING2SEG_MUST_BE_MOVABLE          : constant := 200;
   ERROR_RELOC_CHAIN_XEEDS_SEGLIM          : constant := 201;
   ERROR_INFLOOP_IN_RELOC_CHAIN            : constant := 202;
   ERROR_ENVVAR_NOT_FOUND                  : constant := 203;
   ERROR_NO_SIGNAL_SENT                    : constant := 205;
   ERROR_FILENAME_EXCED_RANGE              : constant := 206;
   ERROR_RING2_STACK_IN_USE                : constant := 207;
   ERROR_META_EXPANSION_TOO_LONG           : constant := 208;
   ERROR_INVALID_SIGNAL_NUMBER             : constant := 209;
   ERROR_THREAD_1_INACTIVE                 : constant := 210;
   ERROR_LOCKED                            : constant := 212;
   ERROR_TOO_MANY_MODULES                  : constant := 214;
   ERROR_NESTING_NOT_ALLOWED               : constant := 215;
   ERROR_BAD_PIPE                          : constant := 230;
   ERROR_PIPE_BUSY                         : constant := 231;
   ERROR_NO_DATA                           : constant := 232;
   ERROR_PIPE_NOT_CONNECTED                : constant := 233;
   ERROR_MORE_DATA                         : constant := 234;
   ERROR_VC_DISCONNECTED                   : constant := 240;
   ERROR_INVALID_EA_NAME                   : constant := 254;
   ERROR_EA_LIST_INCONSISTENT              : constant := 255;
   ERROR_NO_MORE_ITEMS                     : constant := 259;
   ERROR_CANNOT_COPY                       : constant := 266;
   ERROR_DIRECTORY                         : constant := 267;
   ERROR_EAS_DIDNT_FIT                     : constant := 275;
   ERROR_EA_FILE_CORRUPT                   : constant := 276;
   ERROR_EA_TABLE_FULL                     : constant := 277;
   ERROR_INVALID_EA_HANDLE                 : constant := 278;
   ERROR_EAS_NOT_SUPPORTED                 : constant := 282;
   ERROR_NOT_OWNER                         : constant := 288;
   ERROR_TOO_MANY_POSTS                    : constant := 298;
   ERROR_PARTIAL_COPY                      : constant := 299;
   ERROR_MR_MID_NOT_FOUND                  : constant := 317;
   ERROR_INVALID_ADDRESS                   : constant := 487;
   ERROR_ARITHMETIC_OVERFLOW               : constant := 534;
   ERROR_PIPE_CONNECTED                    : constant := 535;
   ERROR_PIPE_LISTENING                    : constant := 536;
   ERROR_EA_ACCESS_DENIED                  : constant := 994;
   ERROR_OPERATION_ABORTED                 : constant := 995;
   ERROR_IO_INCOMPLETE                     : constant := 996;
   ERROR_IO_PENDING                        : constant := 997;
   ERROR_NOACCESS                          : constant := 998;
   ERROR_SWAPERROR                         : constant := 999;
   ERROR_STACK_OVERFLOW                    : constant := 1001;
   ERROR_INVALID_MESSAGE                   : constant := 1002;
   ERROR_CAN_NOT_COMPLETE                  : constant := 1003;
   ERROR_INVALID_FLAGS                     : constant := 1004;
   ERROR_UNRECOGNIZED_VOLUME               : constant := 1005;
   ERROR_FILE_INVALID                      : constant := 1006;
   ERROR_FULLSCREEN_MODE                   : constant := 1007;
   ERROR_NO_TOKEN                          : constant := 1008;
   ERROR_BADDB                             : constant := 1009;
   ERROR_BADKEY                            : constant := 1010;
   ERROR_CANTOPEN                          : constant := 1011;
   ERROR_CANTREAD                          : constant := 1012;
   ERROR_CANTWRITE                         : constant := 1013;
   ERROR_REGISTRY_RECOVERED                : constant := 1014;
   ERROR_REGISTRY_CORRUPT                  : constant := 1015;
   ERROR_REGISTRY_IO_FAILED                : constant := 1016;
   ERROR_NOT_REGISTRY_FILE                 : constant := 1017;
   ERROR_KEY_DELETED                       : constant := 1018;
   ERROR_NO_LOG_SPACE                      : constant := 1019;
   ERROR_KEY_HAS_CHILDREN                  : constant := 1020;
   ERROR_CHILD_MUST_BE_VOLATILE            : constant := 1021;
   ERROR_NOTIFY_ENUM_DIR                   : constant := 1022;
   ERROR_DEPENDENT_SERVICES_RUNNING        : constant := 1051;
   ERROR_INVALID_SERVICE_CONTROL           : constant := 1052;
   ERROR_SERVICE_REQUEST_TIMEOUT           : constant := 1053;
   ERROR_SERVICE_NO_THREAD                 : constant := 1054;
   ERROR_SERVICE_DATABASE_LOCKED           : constant := 1055;
   ERROR_SERVICE_ALREADY_RUNNING           : constant := 1056;
   ERROR_INVALID_SERVICE_ACCOUNT           : constant := 1057;
   ERROR_SERVICE_DISABLED                  : constant := 1058;
   ERROR_CIRCULAR_DEPENDENCY               : constant := 1059;
   ERROR_SERVICE_DOES_NOT_EXIST            : constant := 1060;
   ERROR_SERVICE_CANNOT_ACCEPT_CTRL        : constant := 1061;
   ERROR_SERVICE_NOT_ACTIVE                : constant := 1062;
   ERROR_FAILED_SERVICE_CONTROLLER_CONNECT : constant := 1063;
   ERROR_EXCEPTION_IN_SERVICE              : constant := 1064;
   ERROR_DATABASE_DOES_NOT_EXIST           : constant := 1065;
   ERROR_SERVICE_SPECIFIC_ERROR            : constant := 1066;
   ERROR_PROCESS_ABORTED                   : constant := 1067;
   ERROR_SERVICE_DEPENDENCY_FAIL           : constant := 1068;
   ERROR_SERVICE_LOGON_FAILED              : constant := 1069;
   ERROR_SERVICE_START_HANG                : constant := 1070;
   ERROR_INVALID_SERVICE_LOCK              : constant := 1071;
   ERROR_SERVICE_MARKED_FOR_DELETE         : constant := 1072;
   ERROR_SERVICE_EXISTS                    : constant := 1073;
   ERROR_ALREADY_RUNNING_LKG               : constant := 1074;
   ERROR_SERVICE_DEPENDENCY_DELETED        : constant := 1075;
   ERROR_BOOT_ALREADY_ACCEPTED             : constant := 1076;
   ERROR_SERVICE_NEVER_STARTED             : constant := 1077;
   ERROR_DUPLICATE_SERVICE_NAME            : constant := 1078;
   ERROR_END_OF_MEDIA                      : constant := 1100;
   ERROR_FILEMARK_DETECTED                 : constant := 1101;
   ERROR_BEGINNING_OF_MEDIA                : constant := 1102;
   ERROR_SETMARK_DETECTED                  : constant := 1103;
   ERROR_NO_DATA_DETECTED                  : constant := 1104;
   ERROR_PARTITION_FAILURE                 : constant := 1105;
   ERROR_INVALID_BLOCK_LENGTH              : constant := 1106;
   ERROR_DEVICE_NOT_PARTITIONED            : constant := 1107;
   ERROR_UNABLE_TO_LOCK_MEDIA              : constant := 1108;
   ERROR_UNABLE_TO_UNLOAD_MEDIA            : constant := 1109;
   ERROR_MEDIA_CHANGED                     : constant := 1110;
   ERROR_BUS_RESET                         : constant := 1111;
   ERROR_NO_MEDIA_IN_DRIVE                 : constant := 1112;
   ERROR_NO_UNICODE_TRANSLATION            : constant := 1113;
   ERROR_DLL_INIT_FAILED                   : constant := 1114;
   ERROR_SHUTDOWN_IN_PROGRESS              : constant := 1115;
   ERROR_NO_SHUTDOWN_IN_PROGRESS           : constant := 1116;
   ERROR_IO_DEVICE                         : constant := 1117;
   ERROR_SERIAL_NO_DEVICE                  : constant := 1118;
   ERROR_IRQ_BUSY                          : constant := 1119;
   ERROR_MORE_WRITES                       : constant := 1120;
   ERROR_COUNTER_TIMEOUT                   : constant := 1121;
   ERROR_FLOPPY_ID_MARK_NOT_FOUND          : constant := 1122;
   ERROR_FLOPPY_WRONG_CYLINDER             : constant := 1123;
   ERROR_FLOPPY_UNKNOWN_ERROR              : constant := 1124;
   ERROR_FLOPPY_BAD_REGISTERS              : constant := 1125;
   ERROR_DISK_RECALIBRATE_FAILED           : constant := 1126;
   ERROR_DISK_OPERATION_FAILED             : constant := 1127;
   ERROR_DISK_RESET_FAILED                 : constant := 1128;
   ERROR_EOM_OVERFLOW                      : constant := 1129;
   ERROR_NOT_ENOUGH_SERVER_MEMORY          : constant := 1130;
   ERROR_POSSIBLE_DEADLOCK                 : constant := 1131;
   ERROR_MAPPED_ALIGNMENT                  : constant := 1132;
   ERROR_BAD_USERNAME                      : constant := 2202;
   ERROR_NOT_CONNECTED                     : constant := 2250;
   ERROR_OPEN_FILES                        : constant := 2401;
   ERROR_ACTIVE_CONNECTIONS                : constant := 2402;
   ERROR_DEVICE_IN_USE                     : constant := 2404;
   ERROR_BAD_DEVICE                        : constant := 1200;
   ERROR_CONNECTION_UNAVAIL                : constant := 1201;
   ERROR_DEVICE_ALREADY_REMEMBERED         : constant := 1202;
   ERROR_NO_NET_OR_BAD_PATH                : constant := 1203;
   ERROR_BAD_PROVIDER                      : constant := 1204;
   ERROR_CANNOT_OPEN_PROFILE               : constant := 1205;
   ERROR_BAD_PROFILE                       : constant := 1206;
   ERROR_NOT_CONTAINER                     : constant := 1207;
   ERROR_EXTENDED_ERROR                    : constant := 1208;
   ERROR_INVALID_GROUPNAME                 : constant := 1209;
   ERROR_INVALID_COMPUTERNAME              : constant := 1210;
   ERROR_INVALID_EVENTNAME                 : constant := 1211;
   ERROR_INVALID_DOMAINNAME                : constant := 1212;
   ERROR_INVALID_SERVICENAME               : constant := 1213;
   ERROR_INVALID_NETNAME                   : constant := 1214;
   ERROR_INVALID_SHARENAME                 : constant := 1215;
   ERROR_INVALID_PASSWORDNAME              : constant := 1216;
   ERROR_INVALID_MESSAGENAME               : constant := 1217;
   ERROR_INVALID_MESSAGEDEST               : constant := 1218;
   ERROR_SESSION_CREDENTIAL_CONFLICT       : constant := 1219;
   ERROR_REMOTE_SESSION_LIMIT_EXCEEDED     : constant := 1220;
   ERROR_DUP_DOMAINNAME                    : constant := 1221;
   ERROR_NO_NETWORK                        : constant := 1222;
   ERROR_CANCELLED                         : constant := 1223;
   ERROR_USER_MAPPED_FILE                  : constant := 1224;
   ERROR_CONNECTION_REFUSED                : constant := 1225;
   ERROR_GRACEFUL_DISCONNECT               : constant := 1226;
   ERROR_ADDRESS_ALREADY_ASSOCIATED        : constant := 1227;
   ERROR_ADDRESS_NOT_ASSOCIATED            : constant := 1228;
   ERROR_CONNECTION_INVALID                : constant := 1229;
   ERROR_CONNECTION_ACTIVE                 : constant := 1230;
   ERROR_NETWORK_UNREACHABLE               : constant := 1231;
   ERROR_HOST_UNREACHABLE                  : constant := 1232;
   ERROR_PROTOCOL_UNREACHABLE              : constant := 1233;
   ERROR_PORT_UNREACHABLE                  : constant := 1234;
   ERROR_REQUEST_ABORTED                   : constant := 1235;
   ERROR_CONNECTION_ABORTED                : constant := 1236;
   ERROR_RETRY                             : constant := 1237;
   ERROR_CONNECTION_COUNT_LIMIT            : constant := 1238;
   ERROR_LOGIN_TIME_RESTRICTION            : constant := 1239;
   ERROR_LOGIN_WKSTA_RESTRICTION           : constant := 1240;
   ERROR_INCORRECT_ADDRESS                 : constant := 1241;
   ERROR_ALREADY_REGISTERED                : constant := 1242;
   ERROR_SERVICE_NOT_FOUND                 : constant := 1243;
   ERROR_NOT_ALL_ASSIGNED                  : constant := 1300;
   ERROR_SOME_NOT_MAPPED                   : constant := 1301;
   ERROR_NO_QUOTAS_FOR_ACCOUNT             : constant := 1302;
   ERROR_LOCAL_USER_SESSION_KEY            : constant := 1303;
   ERROR_NULL_LM_PASSWORD                  : constant := 1304;
   ERROR_UNKNOWN_REVISION                  : constant := 1305;
   ERROR_REVISION_MISMATCH                 : constant := 1306;
   ERROR_INVALID_OWNER                     : constant := 1307;
   ERROR_INVALID_PRIMARY_GROUP             : constant := 1308;
   ERROR_NO_IMPERSONATION_TOKEN            : constant := 1309;
   ERROR_CANT_DISABLE_MANDATORY            : constant := 1310;
   ERROR_NO_LOGON_SERVERS                  : constant := 1311;
   ERROR_NO_SUCH_LOGON_SESSION             : constant := 1312;
   ERROR_NO_SUCH_PRIVILEGE                 : constant := 1313;
   ERROR_PRIVILEGE_NOT_HELD                : constant := 1314;
   ERROR_INVALID_ACCOUNT_NAME              : constant := 1315;
   ERROR_USER_EXISTS                       : constant := 1316;
   ERROR_NO_SUCH_USER                      : constant := 1317;
   ERROR_GROUP_EXISTS                      : constant := 1318;
   ERROR_NO_SUCH_GROUP                     : constant := 1319;
   ERROR_MEMBER_IN_GROUP                   : constant := 1320;
   ERROR_MEMBER_NOT_IN_GROUP               : constant := 1321;
   ERROR_LAST_ADMIN                        : constant := 1322;
   ERROR_WRONG_PASSWORD                    : constant := 1323;
   ERROR_ILL_FORMED_PASSWORD               : constant := 1324;
   ERROR_PASSWORD_RESTRICTION              : constant := 1325;
   ERROR_LOGON_FAILURE                     : constant := 1326;
   ERROR_ACCOUNT_RESTRICTION               : constant := 1327;
   ERROR_INVALID_LOGON_HOURS               : constant := 1328;
   ERROR_INVALID_WORKSTATION               : constant := 1329;
   ERROR_PASSWORD_EXPIRED                  : constant := 1330;
   ERROR_ACCOUNT_DISABLED                  : constant := 1331;
   ERROR_NONE_MAPPED                       : constant := 1332;
   ERROR_TOO_MANY_LUIDS_REQUESTED          : constant := 1333;
   ERROR_LUIDS_EXHAUSTED                   : constant := 1334;
   ERROR_INVALID_SUB_AUTHORITY             : constant := 1335;
   ERROR_INVALID_ACL                       : constant := 1336;
   ERROR_INVALID_SID                       : constant := 1337;
   ERROR_INVALID_SECURITY_DESCR            : constant := 1338;
   ERROR_BAD_INHERITANCE_ACL               : constant := 1340;
   ERROR_SERVER_DISABLED                   : constant := 1341;
   ERROR_SERVER_NOT_DISABLED               : constant := 1342;
   ERROR_INVALID_ID_AUTHORITY              : constant := 1343;
   ERROR_ALLOTTED_SPACE_EXCEEDED           : constant := 1344;
   ERROR_INVALID_GROUP_ATTRIBUTES          : constant := 1345;
   ERROR_BAD_IMPERSONATION_LEVEL           : constant := 1346;
   ERROR_CANT_OPEN_ANONYMOUS               : constant := 1347;
   ERROR_BAD_VALIDATION_CLASS              : constant := 1348;
   ERROR_BAD_TOKEN_TYPE                    : constant := 1349;
   ERROR_NO_SECURITY_ON_OBJECT             : constant := 1350;
   ERROR_CANT_ACCESS_DOMAIN_INFO           : constant := 1351;
   ERROR_INVALID_SERVER_STATE              : constant := 1352;
   ERROR_INVALID_DOMAIN_STATE              : constant := 1353;
   ERROR_INVALID_DOMAIN_ROLE               : constant := 1354;
   ERROR_NO_SUCH_DOMAIN                    : constant := 1355;
   ERROR_DOMAIN_EXISTS                     : constant := 1356;
   ERROR_DOMAIN_LIMIT_EXCEEDED             : constant := 1357;
   ERROR_INTERNAL_DB_CORRUPTION            : constant := 1358;
   ERROR_INTERNAL_ERROR                    : constant := 1359;
   ERROR_GENERIC_NOT_MAPPED                : constant := 1360;
   ERROR_BAD_DESCRIPTOR_FORMAT             : constant := 1361;
   ERROR_NOT_LOGON_PROCESS                 : constant := 1362;
   ERROR_LOGON_SESSION_EXISTS              : constant := 1363;
   ERROR_NO_SUCH_PACKAGE                   : constant := 1364;
   ERROR_BAD_LOGON_SESSION_STATE           : constant := 1365;
   ERROR_LOGON_SESSION_COLLISION           : constant := 1366;
   ERROR_INVALID_LOGON_TYPE                : constant := 1367;
   ERROR_CANNOT_IMPERSONATE                : constant := 1368;
   ERROR_RXACT_INVALID_STATE               : constant := 1369;
   ERROR_RXACT_COMMIT_FAILURE              : constant := 1370;
   ERROR_SPECIAL_ACCOUNT                   : constant := 1371;
   ERROR_SPECIAL_GROUP                     : constant := 1372;
   ERROR_SPECIAL_USER                      : constant := 1373;
   ERROR_MEMBERS_PRIMARY_GROUP             : constant := 1374;
   ERROR_TOKEN_ALREADY_IN_USE              : constant := 1375;
   ERROR_NO_SUCH_ALIAS                     : constant := 1376;
   ERROR_MEMBER_NOT_IN_ALIAS               : constant := 1377;
   ERROR_MEMBER_IN_ALIAS                   : constant := 1378;
   ERROR_ALIAS_EXISTS                      : constant := 1379;
   ERROR_LOGON_NOT_GRANTED                 : constant := 1380;
   ERROR_TOO_MANY_SECRETS                  : constant := 1381;
   ERROR_SECRET_TOO_LONG                   : constant := 1382;
   ERROR_INTERNAL_DB_ERROR                 : constant := 1383;
   ERROR_TOO_MANY_CONTEXT_IDS              : constant := 1384;
   ERROR_LOGON_TYPE_NOT_GRANTED            : constant := 1385;
   ERROR_NT_CROSS_ENCRYPTION_REQUIRED      : constant := 1386;
   ERROR_NO_SUCH_MEMBER                    : constant := 1387;
   ERROR_INVALID_MEMBER                    : constant := 1388;
   ERROR_TOO_MANY_SIDS                     : constant := 1389;
   ERROR_LM_CROSS_ENCRYPTION_REQUIRED      : constant := 1390;
   ERROR_NO_INHERITANCE                    : constant := 1391;
   ERROR_FILE_CORRUPT                      : constant := 1392;
   ERROR_DISK_CORRUPT                      : constant := 1393;
   ERROR_NO_USER_SESSION_KEY               : constant := 1394;
   ERROR_INVALID_WINDOW_HANDLE             : constant := 1400;
   ERROR_INVALID_MENU_HANDLE               : constant := 1401;
   ERROR_INVALID_CURSOR_HANDLE             : constant := 1402;
   ERROR_INVALID_ACCEL_HANDLE              : constant := 1403;
   ERROR_INVALID_HOOK_HANDLE               : constant := 1404;
   ERROR_INVALID_DWP_HANDLE                : constant := 1405;
   ERROR_TLW_WITH_WSCHILD                  : constant := 1406;
   ERROR_CANNOT_FIND_WND_CLASS             : constant := 1407;
   ERROR_WINDOW_OF_OTHER_THREAD            : constant := 1408;
   ERROR_HOTKEY_ALREADY_REGISTERED         : constant := 1409;
   ERROR_CLASS_ALREADY_EXISTS              : constant := 1410;
   ERROR_CLASS_DOES_NOT_EXIST              : constant := 1411;
   ERROR_CLASS_HAS_WINDOWS                 : constant := 1412;
   ERROR_INVALID_INDEX                     : constant := 1413;
   ERROR_INVALID_ICON_HANDLE               : constant := 1414;
   ERROR_PRIVATE_DIALOG_INDEX              : constant := 1415;
   ERROR_LISTBOX_ID_NOT_FOUND              : constant := 1416;
   ERROR_NO_WILDCARD_CHARACTERS            : constant := 1417;
   ERROR_CLIPBOARD_NOT_OPEN                : constant := 1418;
   ERROR_HOTKEY_NOT_REGISTERED             : constant := 1419;
   ERROR_WINDOW_NOT_DIALOG                 : constant := 1420;
   ERROR_CONTROL_ID_NOT_FOUND              : constant := 1421;
   ERROR_INVALID_COMBOBOX_MESSAGE          : constant := 1422;
   ERROR_WINDOW_NOT_COMBOBOX               : constant := 1423;
   ERROR_INVALID_EDIT_HEIGHT               : constant := 1424;
   ERROR_DC_NOT_FOUND                      : constant := 1425;
   ERROR_INVALID_HOOK_FILTER               : constant := 1426;
   ERROR_INVALID_FILTER_PROC               : constant := 1427;
   ERROR_HOOK_NEEDS_HMOD                   : constant := 1428;
   ERROR_GLOBAL_ONLY_HOOK                  : constant := 1429;
   ERROR_JOURNAL_HOOK_SET                  : constant := 1430;
   ERROR_HOOK_NOT_INSTALLED                : constant := 1431;
   ERROR_INVALID_LB_MESSAGE                : constant := 1432;
   ERROR_SETCOUNT_ON_BAD_LB                : constant := 1433;
   ERROR_LB_WITHOUT_TABSTOPS               : constant := 1434;
   ERROR_DESTROY_OBJECT_OF_OTHER_THREAD    : constant := 1435;
   ERROR_CHILD_WINDOW_MENU                 : constant := 1436;
   ERROR_NO_SYSTEM_MENU                    : constant := 1437;
   ERROR_INVALID_MSGBOX_STYLE              : constant := 1438;
   ERROR_INVALID_SPI_VALUE                 : constant := 1439;
   ERROR_SCREEN_ALREADY_LOCKED             : constant := 1440;
   ERROR_HWNDS_HAVE_DIFF_PARENT            : constant := 1441;
   ERROR_NOT_CHILD_WINDOW                  : constant := 1442;
   ERROR_INVALID_GW_COMMAND                : constant := 1443;
   ERROR_INVALID_THREAD_ID                 : constant := 1444;
   ERROR_NON_MDICHILD_WINDOW               : constant := 1445;
   ERROR_POPUP_ALREADY_ACTIVE              : constant := 1446;
   ERROR_NO_SCROLLBARS                     : constant := 1447;
   ERROR_INVALID_SCROLLBAR_RANGE           : constant := 1448;
   ERROR_INVALID_SHOWWIN_COMMAND           : constant := 1449;
   ERROR_EVENTLOG_FILE_CORRUPT             : constant := 1500;
   ERROR_EVENTLOG_CANT_START               : constant := 1501;
   ERROR_LOG_FILE_FULL                     : constant := 1502;
   ERROR_EVENTLOG_FILE_CHANGED             : constant := 1503;
   RPC_S_INVALID_STRING_BINDING            : constant := 1700;
   RPC_S_WRONG_KIND_OF_BINDING             : constant := 1701;
   RPC_S_INVALID_BINDING                   : constant := 1702;
   RPC_S_PROTSEQ_NOT_SUPPORTED             : constant := 1703;
   RPC_S_INVALID_RPC_PROTSEQ               : constant := 1704;
   RPC_S_INVALID_STRING_UUID               : constant := 1705;
   RPC_S_INVALID_ENDPOINT_FORMAT           : constant := 1706;
   RPC_S_INVALID_NET_ADDR                  : constant := 1707;
   RPC_S_NO_ENDPOINT_FOUND                 : constant := 1708;
   RPC_S_INVALID_TIMEOUT                   : constant := 1709;
   RPC_S_OBJECT_NOT_FOUND                  : constant := 1710;
   RPC_S_ALREADY_REGISTERED                : constant := 1711;
   RPC_S_TYPE_ALREADY_REGISTERED           : constant := 1712;
   RPC_S_ALREADY_LISTENING                 : constant := 1713;
   RPC_S_NO_PROTSEQS_REGISTERED            : constant := 1714;
   RPC_S_NOT_LISTENING                     : constant := 1715;
   RPC_S_UNKNOWN_MGR_TYPE                  : constant := 1716;
   RPC_S_UNKNOWN_IF                        : constant := 1717;
   RPC_S_NO_BINDINGS                       : constant := 1718;
   RPC_S_NO_PROTSEQS                       : constant := 1719;
   RPC_S_CANT_CREATE_ENDPOINT              : constant := 1720;
   RPC_S_OUT_OF_RESOURCES                  : constant := 1721;
   RPC_S_SERVER_UNAVAILABLE                : constant := 1722;
   RPC_S_SERVER_TOO_BUSY                   : constant := 1723;
   RPC_S_INVALID_NETWORK_OPTIONS           : constant := 1724;
   RPC_S_NO_CALL_ACTIVE                    : constant := 1725;
   RPC_S_CALL_FAILED                       : constant := 1726;
   RPC_S_CALL_FAILED_DNE                   : constant := 1727;
   RPC_S_PROTOCOL_ERROR                    : constant := 1728;
   RPC_S_UNSUPPORTED_TRANS_SYN             : constant := 1730;
   RPC_S_UNSUPPORTED_TYPE                  : constant := 1732;
   RPC_S_INVALID_TAG                       : constant := 1733;
   RPC_S_INVALID_BOUND                     : constant := 1734;
   RPC_S_NO_ENTRY_NAME                     : constant := 1735;
   RPC_S_INVALID_NAME_SYNTAX               : constant := 1736;
   RPC_S_UNSUPPORTED_NAME_SYNTAX           : constant := 1737;
   RPC_S_UUID_NO_ADDRESS                   : constant := 1739;
   RPC_S_DUPLICATE_ENDPOINT                : constant := 1740;
   RPC_S_UNKNOWN_AUTHN_TYPE                : constant := 1741;
   RPC_S_MAX_CALLS_TOO_SMALL               : constant := 1742;
   RPC_S_STRING_TOO_LONG                   : constant := 1743;
   RPC_S_PROTSEQ_NOT_FOUND                 : constant := 1744;
   RPC_S_PROCNUM_OUT_OF_RANGE              : constant := 1745;
   RPC_S_BINDING_HAS_NO_AUTH               : constant := 1746;
   RPC_S_UNKNOWN_AUTHN_SERVICE             : constant := 1747;
   RPC_S_UNKNOWN_AUTHN_LEVEL               : constant := 1748;
   RPC_S_INVALID_AUTH_IDENTITY             : constant := 1749;
   RPC_S_UNKNOWN_AUTHZ_SERVICE             : constant := 1750;
   EPT_S_INVALID_ENTRY                     : constant := 1751;
   EPT_S_CANT_PERFORM_OP                   : constant := 1752;
   EPT_S_NOT_REGISTERED                    : constant := 1753;
   RPC_S_NOTHING_TO_EXPORT                 : constant := 1754;
   RPC_S_INCOMPLETE_NAME                   : constant := 1755;
   RPC_S_INVALID_VERS_OPTION               : constant := 1756;
   RPC_S_NO_MORE_MEMBERS                   : constant := 1757;
   RPC_S_NOT_ALL_OBJS_UNEXPORTED           : constant := 1758;
   RPC_S_INTERFACE_NOT_FOUND               : constant := 1759;
   RPC_S_ENTRY_ALREADY_EXISTS              : constant := 1760;
   RPC_S_ENTRY_NOT_FOUND                   : constant := 1761;
   RPC_S_NAME_SERVICE_UNAVAILABLE          : constant := 1762;
   RPC_S_INVALID_NAF_ID                    : constant := 1763;
   RPC_S_CANNOT_SUPPORT                    : constant := 1764;
   RPC_S_NO_CONTEXT_AVAILABLE              : constant := 1765;
   RPC_S_INTERNAL_ERROR                    : constant := 1766;
   RPC_S_ZERO_DIVIDE                       : constant := 1767;
   RPC_S_ADDRESS_ERROR                     : constant := 1768;
   RPC_S_FP_DIV_ZERO                       : constant := 1769;
   RPC_S_FP_UNDERFLOW                      : constant := 1770;
   RPC_S_FP_OVERFLOW                       : constant := 1771;
   RPC_X_NO_MORE_ENTRIES                   : constant := 1772;
   RPC_X_SS_CHAR_TRANS_OPEN_FAIL           : constant := 1773;
   RPC_X_SS_CHAR_TRANS_SHORT_FILE          : constant := 1774;
   RPC_X_SS_IN_NULL_CONTEXT                : constant := 1775;
   RPC_X_SS_CONTEXT_DAMAGED                : constant := 1777;
   RPC_X_SS_HANDLES_MISMATCH               : constant := 1778;
   RPC_X_SS_CANNOT_GET_CALL_HANDLE         : constant := 1779;
   RPC_X_NULL_REF_POINTER                  : constant := 1780;
   RPC_X_ENUM_VALUE_OUT_OF_RANGE           : constant := 1781;
   RPC_X_BYTE_COUNT_TOO_SMALL              : constant := 1782;
   RPC_X_BAD_STUB_DATA                     : constant := 1783;
   ERROR_INVALID_USER_BUFFER               : constant := 1784;
   ERROR_UNRECOGNIZED_MEDIA                : constant := 1785;
   ERROR_NO_TRUST_LSA_SECRET               : constant := 1786;
   ERROR_NO_TRUST_SAM_ACCOUNT              : constant := 1787;
   ERROR_TRUSTED_DOMAIN_FAILURE            : constant := 1788;
   ERROR_TRUSTED_RELATIONSHIP_FAILURE      : constant := 1789;
   ERROR_TRUST_FAILURE                     : constant := 1790;
   RPC_S_CALL_IN_PROGRESS                  : constant := 1791;
   ERROR_NETLOGON_NOT_STARTED              : constant := 1792;
   ERROR_ACCOUNT_EXPIRED                   : constant := 1793;
   ERROR_REDIRECTOR_HAS_OPEN_HANDLES       : constant := 1794;
   ERROR_PRINTER_DRIVER_ALREADY_INSTALLED  : constant := 1795;
   ERROR_UNKNOWN_PORT                      : constant := 1796;
   ERROR_UNKNOWN_PRINTER_DRIVER            : constant := 1797;
   ERROR_UNKNOWN_PRINTPROCESSOR            : constant := 1798;
   ERROR_INVALID_SEPARATOR_FILE            : constant := 1799;
   ERROR_INVALID_PRIORITY                  : constant := 1800;
   ERROR_INVALID_PRINTER_NAME              : constant := 1801;
   ERROR_PRINTER_ALREADY_EXISTS            : constant := 1802;
   ERROR_INVALID_PRINTER_COMMAND           : constant := 1803;
   ERROR_INVALID_DATATYPE                  : constant := 1804;
   ERROR_INVALID_ENVIRONMENT               : constant := 1805;
   RPC_S_NO_MORE_BINDINGS                  : constant := 1806;
   ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT : constant := 1807;
   ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT : constant := 1808;
   ERROR_NOLOGON_SERVER_TRUST_ACCOUNT      : constant := 1809;
   ERROR_DOMAIN_TRUST_INCONSISTENT         : constant := 1810;
   ERROR_SERVER_HAS_OPEN_HANDLES           : constant := 1811;
   ERROR_RESOURCE_DATA_NOT_FOUND           : constant := 1812;
   ERROR_RESOURCE_TYPE_NOT_FOUND           : constant := 1813;
   ERROR_RESOURCE_NAME_NOT_FOUND           : constant := 1814;
   ERROR_RESOURCE_LANG_NOT_FOUND           : constant := 1815;
   ERROR_NOT_ENOUGH_QUOTA                  : constant := 1816;
   RPC_S_NO_INTERFACES                     : constant := 1817;
   RPC_S_CALL_CANCELLED                    : constant := 1818;
   RPC_S_BINDING_INCOMPLETE                : constant := 1819;
   RPC_S_COMM_FAILURE                      : constant := 1820;
   RPC_S_UNSUPPORTED_AUTHN_LEVEL           : constant := 1821;
   RPC_S_NO_PRINC_NAME                     : constant := 1822;
   RPC_S_NOT_RPC_ERROR                     : constant := 1823;
   RPC_S_UUID_LOCAL_ONLY                   : constant := 1824;
   RPC_S_SEC_PKG_ERROR                     : constant := 1825;
   RPC_S_NOT_CANCELLED                     : constant := 1826;
   RPC_X_INVALID_ES_ACTION                 : constant := 1827;
   RPC_X_WRONG_ES_VERSION                  : constant := 1828;
   RPC_X_WRONG_STUB_VERSION                : constant := 1829;
   RPC_S_GROUP_MEMBER_NOT_FOUND            : constant := 1898;
   EPT_S_CANT_CREATE                       : constant := 1899;
   RPC_S_INVALID_OBJECT                    : constant := 1900;
   ERROR_INVALID_TIME                      : constant := 1901;
   ERROR_INVALID_FORM_NAME                 : constant := 1902;
   ERROR_INVALID_FORM_SIZE                 : constant := 1903;
   ERROR_ALREADY_WAITING                   : constant := 1904;
   ERROR_PRINTER_DELETED                   : constant := 1905;
   ERROR_INVALID_PRINTER_STATE             : constant := 1906;
   ERROR_PASSWORD_MUST_CHANGE              : constant := 1907;
   ERROR_DOMAIN_CONTROLLER_NOT_FOUND       : constant := 1908;
   ERROR_ACCOUNT_LOCKED_OUT                : constant := 1909;
   ERROR_NO_BROWSER_SERVERS_FOUND          : constant := 6118;
   ERROR_INVALID_PIXEL_FORMAT              : constant := 2000;
   ERROR_BAD_DRIVER                        : constant := 2001;
   ERROR_INVALID_WINDOW_STYLE              : constant := 2002;
   ERROR_METAFILE_NOT_SUPPORTED            : constant := 2003;
   ERROR_TRANSFORM_NOT_SUPPORTED           : constant := 2004;
   ERROR_CLIPPING_NOT_SUPPORTED            : constant := 2005;
   ERROR_UNKNOWN_PRINT_MONITOR             : constant := 3000;
   ERROR_PRINTER_DRIVER_IN_USE             : constant := 3001;
   ERROR_SPOOL_FILE_NOT_FOUND              : constant := 3002;
   ERROR_SPL_NO_STARTDOC                   : constant := 3003;
   ERROR_SPL_NO_ADDJOB                     : constant := 3004;
   ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED : constant := 3005;
   ERROR_PRINT_MONITOR_ALREADY_INSTALLED   : constant := 3006;
   ERROR_WINS_INTERNAL                     : constant := 4000;
   ERROR_CAN_NOT_DEL_LOCAL_WINS            : constant := 4001;
   ERROR_STATIC_INIT                       : constant := 4002;
   ERROR_INC_BACKUP                        : constant := 4003;
   ERROR_FULL_BACKUP                       : constant := 4004;
   ERROR_REC_NON_EXISTENT                  : constant := 4005;
   ERROR_RPL_NOT_ALLOWED                   : constant := 4006;
   SEVERITY_SUCCESS                        : constant := 0;
   SEVERITY_ERROR                          : constant := 1;
   FACILITY_NT_BIT                         : constant := 16#10000000#;
   NOERROR                                 : constant := 16#0#;
   E_UNEXPECTED                            : constant := 16#8000ffff#;
   E_NOTIMPL                               : constant := 16#80004001#;
   E_OUTOFMEMORY                           : constant := 16#8007000e#;
   E_INVALIDARG                            : constant := 16#80070057#;
   E_NOINTERFACE                           : constant := 16#80004002#;
   E_POINTER                               : constant := 16#80004003#;
   E_HANDLE                                : constant := 16#80070006#;
   E_ABORT                                 : constant := 16#80004004#;
   E_FAIL                                  : constant := 16#80004005#;
   E_ACCESSDENIED                          : constant := 16#80070005#;
   CO_E_INIT_TLS                           : constant := 16#80004006#;
   CO_E_INIT_SHARED_ALLOCATOR              : constant := 16#80004007#;
   CO_E_INIT_MEMORY_ALLOCATOR              : constant := 16#80004008#;
   CO_E_INIT_CLASS_CACHE                   : constant := 16#80004009#;
   CO_E_INIT_RPC_CHANNEL                   : constant := 16#8000400a#;
   CO_E_INIT_TLS_SET_CHANNEL_CONTROL       : constant := 16#8000400b#;
   CO_E_INIT_TLS_CHANNEL_CONTROL           : constant := 16#8000400c#;
   CO_E_INIT_UNACCEPTED_USER_ALLOCATOR     : constant := 16#8000400d#;
   CO_E_INIT_SCM_MUTEX_EXISTS              : constant := 16#8000400e#;
   CO_E_INIT_SCM_FILE_MAPPING_EXISTS       : constant := 16#8000400f#;
   CO_E_INIT_SCM_MAP_VIEW_OF_FILE          : constant := 16#80004010#;
   CO_E_INIT_SCM_EXEC_FAILURE              : constant := 16#80004011#;
   CO_E_INIT_ONLY_SINGLE_THREADED          : constant := 16#80004012#;
   S_OK                                    : constant := 16#0#;
   S_FALSE                                 : constant := 16#1#;
   OLE_E_FIRST                             : constant := 16#80040000#;
   OLE_E_LAST                              : constant := 16#800400ff#;
   OLE_S_FIRST                             : constant := 16#40000#;
   OLE_S_LAST                              : constant := 16#400ff#;
   OLE_E_OLEVERB                           : constant := 16#80040000#;
   OLE_E_ADVF                              : constant := 16#80040001#;
   OLE_E_ENUM_NOMORE                       : constant := 16#80040002#;
   OLE_E_ADVISENOTSUPPORTED                : constant := 16#80040003#;
   OLE_E_NOCONNECTION                      : constant := 16#80040004#;
   OLE_E_NOTRUNNING                        : constant := 16#80040005#;
   OLE_E_NOCACHE                           : constant := 16#80040006#;
   OLE_E_BLANK                             : constant := 16#80040007#;
   OLE_E_CLASSDIFF                         : constant := 16#80040008#;
   OLE_E_CANT_GETMONIKER                   : constant := 16#80040009#;
   OLE_E_CANT_BINDTOSOURCE                 : constant := 16#8004000a#;
   OLE_E_STATIC                            : constant := 16#8004000b#;
   OLE_E_PROMPTSAVECANCELLED               : constant := 16#8004000c#;
   OLE_E_INVALIDRECT                       : constant := 16#8004000d#;
   OLE_E_WRONGCOMPOBJ                      : constant := 16#8004000e#;
   OLE_E_INVALIDHWND                       : constant := 16#8004000f#;
   OLE_E_NOT_INPLACEACTIVE                 : constant := 16#80040010#;
   OLE_E_CANTCONVERT                       : constant := 16#80040011#;
   OLE_E_NOSTORAGE                         : constant := 16#80040012#;
   DV_E_FORMATETC                          : constant := 16#80040064#;
   DV_E_DVTARGETDEVICE                     : constant := 16#80040065#;
   DV_E_STGMEDIUM                          : constant := 16#80040066#;
   DV_E_STATDATA                           : constant := 16#80040067#;
   DV_E_LINDEX                             : constant := 16#80040068#;
   DV_E_TYMED                              : constant := 16#80040069#;
   DV_E_CLIPFORMAT                         : constant := 16#8004006a#;
   DV_E_DVASPECT                           : constant := 16#8004006b#;
   DV_E_DVTARGETDEVICE_SIZE                : constant := 16#8004006c#;
   DV_E_NOIVIEWOBJECT                      : constant := 16#8004006d#;
   DRAGDROP_E_FIRST                        : constant := 16#80040100#;
   DRAGDROP_E_LAST                         : constant := 16#8004010f#;
   DRAGDROP_S_FIRST                        : constant := 16#40100#;
   DRAGDROP_S_LAST                         : constant := 16#4010f#;
   DRAGDROP_E_NOTREGISTERED                : constant := 16#80040100#;
   DRAGDROP_E_ALREADYREGISTERED            : constant := 16#80040101#;
   DRAGDROP_E_INVALIDHWND                  : constant := 16#80040102#;
   CLASSFACTORY_E_FIRST                    : constant := 16#80040110#;
   CLASSFACTORY_E_LAST                     : constant := 16#8004011f#;
   CLASSFACTORY_S_FIRST                    : constant := 16#40110#;
   CLASSFACTORY_S_LAST                     : constant := 16#4011f#;
   CLASS_E_NOAGGREGATION                   : constant := 16#80040110#;
   CLASS_E_CLASSNOTAVAILABLE               : constant := 16#80040111#;
   MARSHAL_E_FIRST                         : constant := 16#80040120#;
   MARSHAL_E_LAST                          : constant := 16#8004012f#;
   MARSHAL_S_FIRST                         : constant := 16#40120#;
   MARSHAL_S_LAST                          : constant := 16#4012f#;
   DATA_E_FIRST                            : constant := 16#80040130#;
   DATA_E_LAST                             : constant := 16#8004013f#;
   DATA_S_FIRST                            : constant := 16#40130#;
   DATA_S_LAST                             : constant := 16#4013f#;
   VIEW_E_FIRST                            : constant := 16#80040140#;
   VIEW_E_LAST                             : constant := 16#8004014f#;
   VIEW_S_FIRST                            : constant := 16#40140#;
   VIEW_S_LAST                             : constant := 16#4014f#;
   VIEW_E_DRAW                             : constant := 16#80040140#;
   REGDB_E_FIRST                           : constant := 16#80040150#;
   REGDB_E_LAST                            : constant := 16#8004015f#;
   REGDB_S_FIRST                           : constant := 16#40150#;
   REGDB_S_LAST                            : constant := 16#4015f#;
   REGDB_E_READREGDB                       : constant := 16#80040150#;
   REGDB_E_WRITEREGDB                      : constant := 16#80040151#;
   REGDB_E_KEYMISSING                      : constant := 16#80040152#;
   REGDB_E_INVALIDVALUE                    : constant := 16#80040153#;
   REGDB_E_CLASSNOTREG                     : constant := 16#80040154#;
   REGDB_E_IIDNOTREG                       : constant := 16#80040155#;
   CACHE_E_FIRST                           : constant := 16#80040170#;
   CACHE_E_LAST                            : constant := 16#8004017f#;
   CACHE_S_FIRST                           : constant := 16#40170#;
   CACHE_S_LAST                            : constant := 16#4017f#;
   CACHE_E_NOCACHE_UPDATED                 : constant := 16#80040170#;
   OLEOBJ_E_FIRST                          : constant := 16#80040180#;
   OLEOBJ_E_LAST                           : constant := 16#8004018f#;
   OLEOBJ_S_FIRST                          : constant := 16#40180#;
   OLEOBJ_S_LAST                           : constant := 16#4018f#;
   OLEOBJ_E_NOVERBS                        : constant := 16#80040180#;
   OLEOBJ_E_INVALIDVERB                    : constant := 16#80040181#;
   CLIENTSITE_E_FIRST                      : constant := 16#80040190#;
   CLIENTSITE_E_LAST                       : constant := 16#8004019f#;
   CLIENTSITE_S_FIRST                      : constant := 16#40190#;
   CLIENTSITE_S_LAST                       : constant := 16#4019f#;
   INPLACE_E_NOTUNDOABLE                   : constant := 16#800401a0#;
   INPLACE_E_NOTOOLSPACE                   : constant := 16#800401a1#;
   INPLACE_E_FIRST                         : constant := 16#800401a0#;
   INPLACE_E_LAST                          : constant := 16#800401af#;
   INPLACE_S_FIRST                         : constant := 16#401a0#;
   INPLACE_S_LAST                          : constant := 16#401af#;
   ENUM_E_FIRST                            : constant := 16#800401b0#;
   ENUM_E_LAST                             : constant := 16#800401bf#;
   ENUM_S_FIRST                            : constant := 16#401b0#;
   ENUM_S_LAST                             : constant := 16#401bf#;
   CONVERT10_E_FIRST                       : constant := 16#800401c0#;
   CONVERT10_E_LAST                        : constant := 16#800401cf#;
   CONVERT10_S_FIRST                       : constant := 16#401c0#;
   CONVERT10_S_LAST                        : constant := 16#401cf#;
   CONVERT10_E_OLESTREAM_GET               : constant := 16#800401c0#;
   CONVERT10_E_OLESTREAM_PUT               : constant := 16#800401c1#;
   CONVERT10_E_OLESTREAM_FMT               : constant := 16#800401c2#;
   CONVERT10_E_OLESTREAM_BITMAP_TO_DIB     : constant := 16#800401c3#;
   CONVERT10_E_STG_FMT                     : constant := 16#800401c4#;
   CONVERT10_E_STG_NO_STD_STREAM           : constant := 16#800401c5#;
   CONVERT10_E_STG_DIB_TO_BITMAP           : constant := 16#800401c6#;
   CLIPBRD_E_FIRST                         : constant := 16#800401d0#;
   CLIPBRD_E_LAST                          : constant := 16#800401df#;
   CLIPBRD_S_FIRST                         : constant := 16#401d0#;
   CLIPBRD_S_LAST                          : constant := 16#401df#;
   CLIPBRD_E_CANT_OPEN                     : constant := 16#800401d0#;
   CLIPBRD_E_CANT_EMPTY                    : constant := 16#800401d1#;
   CLIPBRD_E_CANT_SET                      : constant := 16#800401d2#;
   CLIPBRD_E_BAD_DATA                      : constant := 16#800401d3#;
   CLIPBRD_E_CANT_CLOSE                    : constant := 16#800401d4#;
   MK_E_FIRST                              : constant := 16#800401e0#;
   MK_E_LAST                               : constant := 16#800401ef#;
   MK_S_FIRST                              : constant := 16#401e0#;
   MK_S_LAST                               : constant := 16#401ef#;
   MK_E_CONNECTMANUALLY                    : constant := 16#800401e0#;
   MK_E_EXCEEDEDDEADLINE                   : constant := 16#800401e1#;
   MK_E_NEEDGENERIC                        : constant := 16#800401e2#;
   MK_E_UNAVAILABLE                        : constant := 16#800401e3#;
   MK_E_SYNTAX                             : constant := 16#800401e4#;
   MK_E_NOOBJECT                           : constant := 16#800401e5#;
   MK_E_INVALIDEXTENSION                   : constant := 16#800401e6#;
   MK_E_INTERMEDIATEINTERFACENOTSUPPORTED  : constant := 16#800401e7#;
   MK_E_NOTBINDABLE                        : constant := 16#800401e8#;
   MK_E_NOTBOUND                           : constant := 16#800401e9#;
   MK_E_CANTOPENFILE                       : constant := 16#800401ea#;
   MK_E_MUSTBOTHERUSER                     : constant := 16#800401eb#;
   MK_E_NOINVERSE                          : constant := 16#800401ec#;
   MK_E_NOSTORAGE                          : constant := 16#800401ed#;
   MK_E_NOPREFIX                           : constant := 16#800401ee#;
   MK_E_ENUMERATION_FAILED                 : constant := 16#800401ef#;
   CO_E_FIRST                              : constant := 16#800401f0#;
   CO_E_LAST                               : constant := 16#800401ff#;
   CO_S_FIRST                              : constant := 16#401f0#;
   CO_S_LAST                               : constant := 16#401ff#;
   CO_E_NOTINITIALIZED                     : constant := 16#800401f0#;
   CO_E_ALREADYINITIALIZED                 : constant := 16#800401f1#;
   CO_E_CANTDETERMINECLASS                 : constant := 16#800401f2#;
   CO_E_CLASSSTRING                        : constant := 16#800401f3#;
   CO_E_IIDSTRING                          : constant := 16#800401f4#;
   CO_E_APPNOTFOUND                        : constant := 16#800401f5#;
   CO_E_APPSINGLEUSE                       : constant := 16#800401f6#;
   CO_E_ERRORINAPP                         : constant := 16#800401f7#;
   CO_E_DLLNOTFOUND                        : constant := 16#800401f8#;
   CO_E_ERRORINDLL                         : constant := 16#800401f9#;
   CO_E_WRONGOSFORAPP                      : constant := 16#800401fa#;
   CO_E_OBJNOTREG                          : constant := 16#800401fb#;
   CO_E_OBJISREG                           : constant := 16#800401fc#;
   CO_E_OBJNOTCONNECTED                    : constant := 16#800401fd#;
   CO_E_APPDIDNTREG                        : constant := 16#800401fe#;
   CO_E_RELEASED                           : constant := 16#800401ff#;
   OLE_S_USEREG                            : constant := 16#40000#;
   OLE_S_STATIC                            : constant := 16#40001#;
   OLE_S_MAC_CLIPFORMAT                    : constant := 16#40002#;
   DRAGDROP_S_DROP                         : constant := 16#40100#;
   DRAGDROP_S_CANCEL                       : constant := 16#40101#;
   DRAGDROP_S_USEDEFAULTCURSORS            : constant := 16#40102#;
   DATA_S_SAMEFORMATETC                    : constant := 16#40130#;
   VIEW_S_ALREADY_FROZEN                   : constant := 16#40140#;
   CACHE_S_FORMATETC_NOTSUPPORTED          : constant := 16#40170#;
   CACHE_S_SAMECACHE                       : constant := 16#40171#;
   CACHE_S_SOMECACHES_NOTUPDATED           : constant := 16#40172#;
   OLEOBJ_S_INVALIDVERB                    : constant := 16#40180#;
   OLEOBJ_S_CANNOT_DOVERB_NOW              : constant := 16#40181#;
   OLEOBJ_S_INVALIDHWND                    : constant := 16#40182#;
   INPLACE_S_TRUNCATED                     : constant := 16#401a0#;
   CONVERT10_S_NO_PRESENTATION             : constant := 16#401c0#;
   MK_S_REDUCED_TO_SELF                    : constant := 16#401e2#;
   MK_S_ME                                 : constant := 16#401e4#;
   MK_S_HIM                                : constant := 16#401e5#;
   MK_S_US                                 : constant := 16#401e6#;
   MK_S_MONIKERALREADYREGISTERED           : constant := 16#401e7#;
   CO_E_CLASS_CREATE_FAILED                : constant := 16#80080001#;
   CO_E_SCM_ERROR                          : constant := 16#80080002#;
   CO_E_SCM_RPC_FAILURE                    : constant := 16#80080003#;
   CO_E_BAD_PATH                           : constant := 16#80080004#;
   CO_E_SERVER_EXEC_FAILURE                : constant := 16#80080005#;
   CO_E_OBJSRV_RPC_FAILURE                 : constant := 16#80080006#;
   MK_E_NO_NORMALIZED                      : constant := 16#80080007#;
   CO_E_SERVER_STOPPING                    : constant := 16#80080008#;
   MEM_E_INVALID_ROOT                      : constant := 16#80080009#;
   MEM_E_INVALID_LINK                      : constant := 16#80080010#;
   MEM_E_INVALID_SIZE                      : constant := 16#80080011#;
   DISP_E_UNKNOWNINTERFACE                 : constant := 16#80020001#;
   DISP_E_MEMBERNOTFOUND                   : constant := 16#80020003#;
   DISP_E_PARAMNOTFOUND                    : constant := 16#80020004#;
   DISP_E_TYPEMISMATCH                     : constant := 16#80020005#;
   DISP_E_UNKNOWNNAME                      : constant := 16#80020006#;
   DISP_E_NONAMEDARGS                      : constant := 16#80020007#;
   DISP_E_BADVARTYPE                       : constant := 16#80020008#;
   DISP_E_EXCEPTION                        : constant := 16#80020009#;
   DISP_E_OVERFLOW                         : constant := 16#8002000a#;
   DISP_E_BADINDEX                         : constant := 16#8002000b#;
   DISP_E_UNKNOWNLCID                      : constant := 16#8002000c#;
   DISP_E_ARRAYISLOCKED                    : constant := 16#8002000d#;
   DISP_E_BADPARAMCOUNT                    : constant := 16#8002000e#;
   DISP_E_PARAMNOTOPTIONAL                 : constant := 16#8002000f#;
   DISP_E_BADCALLEE                        : constant := 16#80020010#;
   DISP_E_NOTACOLLECTION                   : constant := 16#80020011#;
   TYPE_E_BUFFERTOOSMALL                   : constant := 16#80028016#;
   TYPE_E_INVDATAREAD                      : constant := 16#80028018#;
   TYPE_E_UNSUPFORMAT                      : constant := 16#80028019#;
   TYPE_E_REGISTRYACCESS                   : constant := 16#8002801c#;
   TYPE_E_LIBNOTREGISTERED                 : constant := 16#8002801d#;
   TYPE_E_UNDEFINEDTYPE                    : constant := 16#80028027#;
   TYPE_E_QUALIFIEDNAMEDISALLOWED          : constant := 16#80028028#;
   TYPE_E_INVALIDSTATE                     : constant := 16#80028029#;
   TYPE_E_WRONGTYPEKIND                    : constant := 16#8002802a#;
   TYPE_E_ELEMENTNOTFOUND                  : constant := 16#8002802b#;
   TYPE_E_AMBIGUOUSNAME                    : constant := 16#8002802c#;
   TYPE_E_NAMECONFLICT                     : constant := 16#8002802d#;
   TYPE_E_UNKNOWNLCID                      : constant := 16#8002802e#;
   TYPE_E_DLLFUNCTIONNOTFOUND              : constant := 16#8002802f#;
   TYPE_E_BADMODULEKIND                    : constant := 16#800288bd#;
   TYPE_E_SIZETOOBIG                       : constant := 16#800288c5#;
   TYPE_E_DUPLICATEID                      : constant := 16#800288c6#;
   TYPE_E_INVALIDID                        : constant := 16#800288cf#;
   TYPE_E_TYPEMISMATCH                     : constant := 16#80028ca0#;
   TYPE_E_OUTOFBOUNDS                      : constant := 16#80028ca1#;
   TYPE_E_IOERROR                          : constant := 16#80028ca2#;
   TYPE_E_CANTCREATETMPFILE                : constant := 16#80028ca3#;
   TYPE_E_CANTLOADLIBRARY                  : constant := 16#80029c4a#;
   TYPE_E_INCONSISTENTPROPFUNCS            : constant := 16#80029c83#;
   TYPE_E_CIRCULARTYPE                     : constant := 16#80029c84#;
   STG_E_INVALIDFUNCTION                   : constant := 16#80030001#;
   STG_E_FILENOTFOUND                      : constant := 16#80030002#;
   STG_E_PATHNOTFOUND                      : constant := 16#80030003#;
   STG_E_TOOMANYOPENFILES                  : constant := 16#80030004#;
   STG_E_ACCESSDENIED                      : constant := 16#80030005#;
   STG_E_INVALIDHANDLE                     : constant := 16#80030006#;
   STG_E_INSUFFICIENTMEMORY                : constant := 16#80030008#;
   STG_E_INVALIDPOINTER                    : constant := 16#80030009#;
   STG_E_NOMOREFILES                       : constant := 16#80030012#;
   STG_E_DISKISWRITEPROTECTED              : constant := 16#80030013#;
   STG_E_SEEKERROR                         : constant := 16#80030019#;
   STG_E_WRITEFAULT                        : constant := 16#8003001d#;
   STG_E_READFAULT                         : constant := 16#8003001e#;
   STG_E_SHAREVIOLATION                    : constant := 16#80030020#;
   STG_E_LOCKVIOLATION                     : constant := 16#80030021#;
   STG_E_FILEALREADYEXISTS                 : constant := 16#80030050#;
   STG_E_INVALIDPARAMETER                  : constant := 16#80030057#;
   STG_E_MEDIUMFULL                        : constant := 16#80030070#;
   STG_E_ABNORMALAPIEXIT                   : constant := 16#800300fa#;
   STG_E_INVALIDHEADER                     : constant := 16#800300fb#;
   STG_E_INVALIDNAME                       : constant := 16#800300fc#;
   STG_E_UNKNOWN                           : constant := 16#800300fd#;
   STG_E_UNIMPLEMENTEDFUNCTION             : constant := 16#800300fe#;
   STG_E_INVALIDFLAG                       : constant := 16#800300ff#;
   STG_E_INUSE                             : constant := 16#80030100#;
   STG_E_NOTCURRENT                        : constant := 16#80030101#;
   STG_E_REVERTED                          : constant := 16#80030102#;
   STG_E_CANTSAVE                          : constant := 16#80030103#;
   STG_E_OLDFORMAT                         : constant := 16#80030104#;
   STG_E_OLDDLL                            : constant := 16#80030105#;
   STG_E_SHAREREQUIRED                     : constant := 16#80030106#;
   STG_E_NOTFILEBASEDSTORAGE               : constant := 16#80030107#;
   STG_E_EXTANTMARSHALLINGS                : constant := 16#80030108#;
   STG_S_CONVERTED                         : constant := 16#30200#;
   RPC_E_CALL_REJECTED                     : constant := 16#80010001#;
   RPC_E_CALL_CANCELED                     : constant := 16#80010002#;
   RPC_E_CANTPOST_INSENDCALL               : constant := 16#80010003#;
   RPC_E_CANTCALLOUT_INASYNCCALL           : constant := 16#80010004#;
   RPC_E_CANTCALLOUT_INEXTERNALCALL        : constant := 16#80010005#;
   RPC_E_CONNECTION_TERMINATED             : constant := 16#80010006#;
   RPC_E_SERVER_DIED                       : constant := 16#80010007#;
   RPC_E_CLIENT_DIED                       : constant := 16#80010008#;
   RPC_E_INVALID_DATAPACKET                : constant := 16#80010009#;
   RPC_E_CANTTRANSMIT_CALL                 : constant := 16#8001000a#;
   RPC_E_CLIENT_CANTMARSHAL_DATA           : constant := 16#8001000b#;
   RPC_E_CLIENT_CANTUNMARSHAL_DATA         : constant := 16#8001000c#;
   RPC_E_SERVER_CANTMARSHAL_DATA           : constant := 16#8001000d#;
   RPC_E_SERVER_CANTUNMARSHAL_DATA         : constant := 16#8001000e#;
   RPC_E_INVALID_DATA                      : constant := 16#8001000f#;
   RPC_E_INVALID_PARAMETER                 : constant := 16#80010010#;
   RPC_E_CANTCALLOUT_AGAIN                 : constant := 16#80010011#;
   RPC_E_SERVER_DIED_DNE                   : constant := 16#80010012#;
   RPC_E_SYS_CALL_FAILED                   : constant := 16#80010100#;
   RPC_E_OUT_OF_RESOURCES                  : constant := 16#80010101#;
   RPC_E_ATTEMPTED_MULTITHREAD             : constant := 16#80010102#;
   RPC_E_NOT_REGISTERED                    : constant := 16#80010103#;
   RPC_E_FAULT                             : constant := 16#80010104#;
   RPC_E_SERVERFAULT                       : constant := 16#80010105#;
   RPC_E_CHANGED_MODE                      : constant := 16#80010106#;
   RPC_E_INVALIDMETHOD                     : constant := 16#80010107#;
   RPC_E_DISCONNECTED                      : constant := 16#80010108#;
   RPC_E_RETRY                             : constant := 16#80010109#;
   RPC_E_SERVERCALL_RETRYLATER             : constant := 16#8001010a#;
   RPC_E_SERVERCALL_REJECTED               : constant := 16#8001010b#;
   RPC_E_INVALID_CALLDATA                  : constant := 16#8001010c#;
   RPC_E_CANTCALLOUT_ININPUTSYNCCALL       : constant := 16#8001010d#;
   RPC_E_WRONG_THREAD                      : constant := 16#8001010e#;
   RPC_E_THREAD_NOT_INIT                   : constant := 16#8001010f#;
   RPC_E_UNEXPECTED                        : constant := 16#8001ffff#;

   type HRESULT is new LONG;

   subtype SCODE is HRESULT;

   function SUCCEEDED (Status : HRESULT) return Standard.Boolean;

   function FAILED (Status : HRESULT) return Standard.Boolean;

   function IS_ERROR (Status : HRESULT) return Standard.Boolean renames FAILED;

   function HRESULT_CODE (H : HRESULT) return WORD;

   function SCODE_CODE (H : HRESULT) return WORD renames HRESULT_CODE;

   function HRESULT_FACILITY (H : HRESULT) return WORD;

   function SCODE_FACILITY (H : HRESULT) return WORD renames HRESULT_FACILITY;

   function HRESULT_SEVERITY (H : HRESULT) return WORD;

   function SCODE_SEVERITY (H : HRESULT) return WORD renames HRESULT_SEVERITY;

   function MAKE_HRESULT (sev, fac, code : WORD) return HRESULT;

   function MAKE_SCODE (sev, fac, code : WORD) return HRESULT renames
     MAKE_HRESULT;

   function HRESULT_FROM_WIN32 (X : DWORD) return HRESULT;

   function HRESULT_FROM_NT (X : DWORD) return HRESULT;

private

   pragma Inline (SUCCEEDED);
   pragma Inline (FAILED);
   pragma Inline (HRESULT_CODE);
   pragma Inline (HRESULT_FACILITY);
   pragma Inline (HRESULT_SEVERITY);
   pragma Inline (MAKE_HRESULT);
   pragma Inline (HRESULT_FROM_WIN32);
   pragma Inline (HRESULT_FROM_NT);

end Win32.Winerror;
