(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import ZArith.
Require Import Rbase.
Require int.Int.

(* Why3 assumption *)
Definition unit  := unit.

Parameter qtmark : Type.

Parameter at1: forall (a:Type), a -> qtmark -> a.
Implicit Arguments at1.

Parameter old: forall (a:Type), a -> a.
Implicit Arguments old.

(* Why3 assumption *)
Definition implb(x:bool) (y:bool): bool := match (x,
  y) with
  | (true, false) => false
  | (_, _) => true
  end.

(* Why3 assumption *)
Inductive list (a:Type) :=
  | Nil : list a
  | Cons : a -> (list a) -> list a.
Set Contextual Implicit.
Implicit Arguments Nil.
Unset Contextual Implicit.
Implicit Arguments Cons.

(* Why3 assumption *)
Set Implicit Arguments.
Fixpoint infix_plpl (a:Type)(l1:(list a)) (l2:(list a)) {struct l1}: (list
  a) :=
  match l1 with
  | Nil => l2
  | (Cons x1 r1) => (Cons x1 (infix_plpl r1 l2))
  end.
Unset Implicit Arguments.

Axiom Append_assoc : forall (a:Type), forall (l1:(list a)) (l2:(list a))
  (l3:(list a)), ((infix_plpl l1 (infix_plpl l2
  l3)) = (infix_plpl (infix_plpl l1 l2) l3)).

Axiom Append_l_nil : forall (a:Type), forall (l:(list a)), ((infix_plpl l
  (Nil :(list a))) = l).

(* Why3 assumption *)
Set Implicit Arguments.
Fixpoint length (a:Type)(l:(list a)) {struct l}: Z :=
  match l with
  | Nil => 0%Z
  | (Cons _ r) => (1%Z + (length r))%Z
  end.
Unset Implicit Arguments.

Axiom Length_nonnegative : forall (a:Type), forall (l:(list a)),
  (0%Z <= (length l))%Z.

Axiom Length_nil : forall (a:Type), forall (l:(list a)),
  ((length l) = 0%Z) <-> (l = (Nil :(list a))).

Axiom Append_length : forall (a:Type), forall (l1:(list a)) (l2:(list a)),
  ((length (infix_plpl l1 l2)) = ((length l1) + (length l2))%Z).

(* Why3 assumption *)
Set Implicit Arguments.
Fixpoint mem (a:Type)(x:a) (l:(list a)) {struct l}: Prop :=
  match l with
  | Nil => False
  | (Cons y r) => (x = y) \/ (mem x r)
  end.
Unset Implicit Arguments.

Axiom mem_append : forall (a:Type), forall (x:a) (l1:(list a)) (l2:(list a)),
  (mem x (infix_plpl l1 l2)) <-> ((mem x l1) \/ (mem x l2)).

Axiom mem_decomp : forall (a:Type), forall (x:a) (l:(list a)), (mem x l) ->
  exists l1:(list a), exists l2:(list a), (l = (infix_plpl l1 (Cons x l2))).

(* Why3 assumption *)
Inductive tree  :=
  | Leaf : tree 
  | Node : tree -> tree -> tree .

(* Why3 assumption *)
Set Implicit Arguments.
Fixpoint depths(d:Z) (t:tree) {struct t}: (list Z) :=
  match t with
  | Leaf => (Cons d (Nil :(list Z)))
  | (Node l r) => (infix_plpl (depths (d + 1%Z)%Z l) (depths (d + 1%Z)%Z r))
  end.
Unset Implicit Arguments.

Axiom depths_head : forall (t:tree) (d:Z), match (depths d
  t) with
  | (Cons x _) => (d <= x)%Z
  | Nil => False
  end.

Axiom depths_unique : forall (t1:tree) (t2:tree) (d:Z) (s1:(list Z))
  (s2:(list Z)), ((infix_plpl (depths d t1) s1) = (infix_plpl (depths d t2)
  s2)) -> ((t1 = t2) /\ (s1 = s2)).

Axiom depths_prefix : forall (t:tree) (d1:Z) (d2:Z) (s1:(list Z)) (s2:(list
  Z)), ((infix_plpl (depths d1 t) s1) = (infix_plpl (depths d2 t) s2)) ->
  (d1 = d2).

Axiom depths_prefix_simple : forall (t:tree) (d1:Z) (d2:Z), ((depths d1
  t) = (depths d2 t)) -> (d1 = d2).

Axiom depths_subtree : forall (t1:tree) (t2:tree) (d1:Z) (d2:Z) (s1:(list
  Z)), ((infix_plpl (depths d1 t1) s1) = (depths d2 t2)) -> (d2 <= d1)%Z.

Axiom depths_unique2 : forall (t1:tree) (t2:tree) (d1:Z) (d2:Z), ((depths d1
  t1) = (depths d2 t2)) -> ((d1 = d2) /\ (t1 = t2)).

(* Why3 assumption *)
Definition lt_nat(x:Z) (y:Z): Prop := (0%Z <= y)%Z /\ (x <  y)%Z.

(* Why3 assumption *)
Inductive lex : (Z* Z)%type -> (Z* Z)%type -> Prop :=
  | Lex_1 : forall (x1:Z) (x2:Z) (y1:Z) (y2:Z), (lt_nat x1 x2) -> (lex (x1,
      y1) (x2, y2))
  | Lex_2 : forall (x:Z) (y1:Z) (y2:Z), (lt_nat y1 y2) -> (lex (x, y1) (x,
      y2)).

(* Why3 assumption *)
Set Implicit Arguments.
Fixpoint reverse (a:Type)(l:(list a)) {struct l}: (list a) :=
  match l with
  | Nil => (Nil :(list a))
  | (Cons x r) => (infix_plpl (reverse r) (Cons x (Nil :(list a))))
  end.
Unset Implicit Arguments.

Axiom reverse_append : forall (a:Type), forall (l1:(list a)) (l2:(list a))
  (x:a), ((infix_plpl (reverse (Cons x l1)) l2) = (infix_plpl (reverse l1)
  (Cons x l2))).

Axiom reverse_reverse : forall (a:Type), forall (l:(list a)),
  ((reverse (reverse l)) = l).

Axiom Reverse_length : forall (a:Type), forall (l:(list a)),
  ((length (reverse l)) = (length l)).

(* Why3 assumption *)
Set Implicit Arguments.
Fixpoint forest_depths(f:(list (Z* tree)%type)) {struct f}: (list Z) :=
  match f with
  | Nil => (Nil :(list Z))
  | (Cons (d, t) r) => (infix_plpl (depths d t) (forest_depths r))
  end.
Unset Implicit Arguments.

Axiom forest_depths_append : forall (f1:(list (Z* tree)%type)) (f2:(list (Z*
  tree)%type)), ((forest_depths (infix_plpl f1
  f2)) = (infix_plpl (forest_depths f1) (forest_depths f2))).

(* Why3 assumption *)
Set Implicit Arguments.
Fixpoint only_leaf(l:(list (Z* tree)%type)) {struct l}: Prop :=
  match l with
  | Nil => True
  | (Cons (_, t) r) => (t = Leaf) /\ (only_leaf r)
  end.
Unset Implicit Arguments.

(* Why3 assumption *)
Set Implicit Arguments.
Fixpoint greedy(d:Z) (d1:Z) (t1:tree) {struct t1}: Prop := (~ (d = d1)) /\
  match t1 with
  | Leaf => True
  | (Node l1 _) => (greedy d (d1 + 1%Z)%Z l1)
  end.
Unset Implicit Arguments.

(* Why3 assumption *)
Inductive g : (list (Z* tree)%type) -> Prop :=
  | Gnil : (g (Nil :(list (Z* tree)%type)))
  | Gone : forall (d:Z) (t:tree), (g (Cons (d, t) (Nil :(list (Z*
      tree)%type))))
  | Gtwo : forall (d1:Z) (d2:Z) (t1:tree) (t2:tree) (l:(list (Z*
      tree)%type)), (greedy d1 d2 t2) -> ((g (Cons (d1, t1) l)) -> (g (Cons (
      d2, t2) (Cons (d1, t1) l)))).

Axiom g_append : forall (l1:(list (Z* tree)%type)) (l2:(list (Z*
  tree)%type)), (g (infix_plpl l1 l2)) -> (g l1).

Axiom right_nil : forall (l:(list (Z* tree)%type)), (2%Z <= (length l))%Z ->
  ((g l) -> forall (t:tree), ~ ((forest_depths (reverse l)) = (depths 0%Z
  t))).

Require Import Why3. Ltac z := why3 "z3" timelimit 5.

(*
Lemma key_lemma:
  forall t t1 t2 s d2 d d1, (d < d1)%Z -> 
  match t2 with Leaf => True | Node left2 _ => g (Cons (d1, t1) (Cons ((d2+1)%Z, left2) Nil)) end ->
  infix_plpl (depths d1 t1) (depths d2 t2) = infix_plpl (depths d t) s ->
  d = (d1-1)%Z /\ d2 = d1.
induction t; simpl.
(* t = Leaf *)
intros.
assert (d >= d1)%Z.
  clear H.
  generalize H1; clear H1.
  generalize (depths d2 t2).
  generalize d1.
  induction t1; simpl.
  z.
(*

  z.
omega.
(* t = Node t1 t2 *)
rename t1 into left, t2 into right.
intros t1 t2 s d2 d d1 ineq.
rewrite <- Append_assoc.
intro eq.
assert (case: (d+1 < d1 \/ d=d1-1)%Z) by omega. destruct case.
(* d+1 < d1, by iH *)
generalize (IHt1 t1 t2 (infix_plpl (depths (d + 1) right) s) d2 (d+1) d1 H eq)%Z.
intuition.


subst.
replace (infix_plpl (depths d2 t1) (depths d2 t2))
  with (depths (d2-1) (Node t1 t2))%Z in eq.
rewrite H0 in eq.
assert (Node t1 t2 = left) by z.
rewrite H0 in eq.
replace (depths (d2 - 1) left) with (infix_plpl (depths (d2 - 1) left) Nil) in eq by z.
z.
simpl.
replace  (d2 - 1 + 1)%Z with d2; z.
(* d+1 = d1 *)
intuition.
replace (d+1)%Z with d1 in eq by z.
assert (t1 = left) by z.
subst.
assert (depths d2 t2 = infix_plpl (depths d1 right) s) by z.
assert (d2 <= d1)%Z by z.
assert (case: (d2 < d1 \/ d2=d1)%Z) by omega. destruct case. 2: auto.

*)
Admitted.
*)

(*
Lemma key_lemma_greedy:
  forall l d t t1 t2 d1 d2, d1 <> d2 ->
  g d t (infix_plpl l (Cons (d1, t1) Nil)) ->
  match t2 with
  | (Node l2 _) => g (infix_plpl l (Cons (d1, t1) (Cons ((d2 + 1%Z)%Z, l2))))
  | Leaf => True end ->
  greedy d t (infix_plpl l (Cons (d1, t1) (Cons (d2, t2) Nil))).
induction l; simpl.
unfold greedy; simpl.
intros d t t1 t2 d1 d2 ineq.
do 2 rewrite Append_l_nil.
(* l = Nil *)
admit.
(* l = Cons _ _ *)
unfold greedy; simpl.
intros.
destruct a.
z.
(*
z.
unfold greedy; simpl.
intros. z.
Qed.
*)
Admitted.
*)

(* Why3 goal *)
Theorem main_lemma : forall (l:(list (Z* tree)%type)) (d1:Z) (d2:Z) (t1:tree)
  (t2:tree), (~ (d1 = d2)) -> ((g (Cons (d1, t1) l)) ->
  (match t2 with
  | (Node l2 _) => (greedy d1 (d2 + 1%Z)%Z l2)
  | Leaf => True
  end -> (g (Cons (d2, t2) (Cons (d1, t1) l))))).
intros; apply Gtwo.
destruct t2; z.
assumption.
(**
simpl.
intro l; generalize (reverse l). clear l.
induction l; simpl.
(* length = 2 *)
intros d1 d2 t1 t2 ineq _ ht2.
apply Gtwo.
red; intros.
simpl.
intros eq.
z.
z.
(* length > 2 *)
intros.
assert (g ((infix_plpl l (Cons (d1,t1) Nil)))).
  inversion H0; auto.
  z.
destruct a.
inversion H0.
z.
apply Gtwo.
(* greedy *)
replace 
      (infix_plpl (infix_plpl l (Cons (d1, t1) Nil)) (Cons (d2, t2) Nil))
 with (infix_plpl l (Cons (d1, t1) (Cons (d2, t2) Nil))) by z.
apply key_lemma_greedy; auto.
(* g *)
apply IHl; auto.
destruct t2; auto.
inversion H1; z.
**)
Qed.


