(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require int.Int.
Require list.List.
Require list.Length.
Require list.Mem.
Require list.Append.

(* Why3 assumption *)
Inductive tree :=
  | Leaf : tree
  | Node : tree -> tree -> tree.
Axiom tree_WhyType : WhyType tree.
Existing Instance tree_WhyType.

(* Why3 assumption *)
Fixpoint depths (d:Z) (t:tree) {struct t}: (list Z) :=
  match t with
  | Leaf => (cons d nil)
  | (Node l r) => (List.app (depths (d + 1%Z)%Z l) (depths (d + 1%Z)%Z r))
  end.

Axiom depths_head : forall (t:tree) (d:Z), match (depths d
  t) with
  | (cons x _) => (d <= x)%Z
  | nil => False
  end.

(* Why3 goal *)
Theorem depths_unique : forall (t1:tree) (t2:tree) (d:Z) (s1:(list Z))
  (s2:(list Z)), ((List.app (depths d t1) s1) = (List.app (depths d
  t2) s2)) -> ((t1 = t2) /\ (s1 = s2)).
(* Why3 intros t1 t2 d s1 s2 h1. *)
induction t1.
simpl; intros.
induction t2.
simpl in H.
injection H; intuition.
simpl in *.
generalize (depths_head t2_1 (d+1)%Z).
generalize H; clear H.
destruct ((depths (d + 1) t2_1)); simpl in *.
intuition.
intros h; injection h.
intros; apply False_ind; omega.
(* t1 = Node *)
induction t2; simpl.
(* t2 = Leaf *)
intros.
generalize (depths_head t1_1 (d+1)%Z).
generalize H; clear H.
destruct ((depths (d + 1) t1_1)); simpl in *.
intuition.
intros h; injection h.
intros; apply False_ind; omega.
(* t2 = Node *)
intros.
do 2 (rewrite <- Append.Append_assoc in H).
generalize (IHt1_1 t2_1 (d+1) _ _ H)%Z. clear IHt1_1.
intros (eq1, H1).
generalize (IHt1_2 t2_2 (d+1) _ _ H1)%Z. clear IHt1_2.
intuition.
apply f_equal2; auto.
Qed.


