(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require Import ZOdiv.
Require BuiltIn.
Require int.Int.
Require int.Abs.
Require int.ComputerDivision.

(* Why3 assumption *)
Definition unit  := unit.

Parameter map : forall (a:Type) {a_WT:WhyType a} (b:Type) {b_WT:WhyType b},
  Type.
Axiom map_WhyType : forall (a:Type) {a_WT:WhyType a}
  (b:Type) {b_WT:WhyType b}, WhyType (map a b).
Existing Instance map_WhyType.

Parameter get: forall {a:Type} {a_WT:WhyType a} {b:Type} {b_WT:WhyType b},
  (map a b) -> a -> b.

Parameter set: forall {a:Type} {a_WT:WhyType a} {b:Type} {b_WT:WhyType b},
  (map a b) -> a -> b -> (map a b).

Axiom Select_eq : forall {a:Type} {a_WT:WhyType a} {b:Type} {b_WT:WhyType b},
  forall (m:(map a b)), forall (a1:a) (a2:a), forall (b1:b), (a1 = a2) ->
  ((get (set m a1 b1) a2) = b1).

Axiom Select_neq : forall {a:Type} {a_WT:WhyType a}
  {b:Type} {b_WT:WhyType b}, forall (m:(map a b)), forall (a1:a) (a2:a),
  forall (b1:b), (~ (a1 = a2)) -> ((get (set m a1 b1) a2) = (get m a2)).

Parameter const: forall {a:Type} {a_WT:WhyType a} {b:Type} {b_WT:WhyType b},
  b -> (map a b).

Axiom Const : forall {a:Type} {a_WT:WhyType a} {b:Type} {b_WT:WhyType b},
  forall (b1:b) (a1:a), ((get (const b1:(map a b)) a1) = b1).

(* Why3 assumption *)
Inductive array (a:Type) {a_WT:WhyType a} :=
  | mk_array : BuiltIn.int -> (map BuiltIn.int a) -> array a.
Axiom array_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (array a).
Existing Instance array_WhyType.
Implicit Arguments mk_array [[a] [a_WT]].

(* Why3 assumption *)
Definition elts {a:Type} {a_WT:WhyType a}(v:(array a)): (map BuiltIn.int
  a) := match v with
  | (mk_array x x1) => x1
  end.

(* Why3 assumption *)
Definition length {a:Type} {a_WT:WhyType a}(v:(array a)): BuiltIn.int :=
  match v with
  | (mk_array x x1) => x
  end.

(* Why3 assumption *)
Definition get1 {a:Type} {a_WT:WhyType a}(a1:(array a)) (i:BuiltIn.int): a :=
  (get (elts a1) i).

(* Why3 assumption *)
Definition set1 {a:Type} {a_WT:WhyType a}(a1:(array a)) (i:BuiltIn.int)
  (v:a): (array a) := (mk_array (length a1) (set (elts a1) i v)).

(* Why3 assumption *)
Definition container  := (map BuiltIn.int BuiltIn.int).

Parameter sum: (map BuiltIn.int BuiltIn.int) -> BuiltIn.int -> BuiltIn.int ->
  BuiltIn.int.

Axiom Sum_def_empty : forall (c:(map BuiltIn.int BuiltIn.int))
  (i:BuiltIn.int) (j:BuiltIn.int), (j <= i)%Z -> ((sum c i j) = 0%Z).

Axiom Sum_def_non_empty : forall (c:(map BuiltIn.int BuiltIn.int))
  (i:BuiltIn.int) (j:BuiltIn.int), (i < j)%Z -> ((sum c i j) = ((get c
  i) + (sum c (i + 1%Z)%Z j))%Z).

Axiom Sum_right_extension : forall (c:(map BuiltIn.int BuiltIn.int))
  (i:BuiltIn.int) (j:BuiltIn.int), (i < j)%Z -> ((sum c i j) = ((sum c i
  (j - 1%Z)%Z) + (get c (j - 1%Z)%Z))%Z).

Axiom Sum_transitivity : forall (c:(map BuiltIn.int BuiltIn.int))
  (i:BuiltIn.int) (k:BuiltIn.int) (j:BuiltIn.int), ((i <= k)%Z /\
  (k <= j)%Z) -> ((sum c i j) = ((sum c i k) + (sum c k j))%Z).

Axiom Sum_eq : forall (c1:(map BuiltIn.int BuiltIn.int)) (c2:(map BuiltIn.int
  BuiltIn.int)) (i:BuiltIn.int) (j:BuiltIn.int), (forall (k:BuiltIn.int),
  ((i <= k)%Z /\ (k < j)%Z) -> ((get c1 k) = (get c2 k))) -> ((sum c1 i
  j) = (sum c2 i j)).

(* Why3 assumption *)
Definition sum1(a:(array BuiltIn.int)) (l:BuiltIn.int)
  (h:BuiltIn.int): BuiltIn.int := (sum (elts a) l h).

(* Why3 assumption *)
Definition go_left(left1:BuiltIn.int) (right1:BuiltIn.int): BuiltIn.int :=
  let space := (right1 - left1)%Z in (left1 - (ZOdiv space 2%Z))%Z.

Axiom go_left_bounds : forall (left1:BuiltIn.int) (right1:BuiltIn.int),
  ((0%Z <= left1)%Z /\ (((left1 + 1%Z)%Z < right1)%Z /\
  ((right1 - left1)%Z <= left1)%Z)) -> ((0%Z <= (go_left left1 right1))%Z /\
  ((go_left left1 right1) < left1)%Z).

(* Why3 assumption *)
Definition go_right(left1:BuiltIn.int) (right1:BuiltIn.int): BuiltIn.int :=
  let space := (right1 - left1)%Z in (right1 - (ZOdiv space 2%Z))%Z.

Axiom go_right_bounds : forall (left1:BuiltIn.int) (right1:BuiltIn.int),
  ((0%Z <= left1)%Z /\ (((left1 + 1%Z)%Z < right1)%Z /\
  ((right1 - left1)%Z <= left1)%Z)) -> ((left1 <= (go_right left1
  right1))%Z /\ ((go_right left1 right1) < right1)%Z).

(* Why3 assumption *)
Inductive phase1 : BuiltIn.int -> BuiltIn.int -> (array BuiltIn.int)
  -> (array BuiltIn.int) -> Prop :=
  | Leaf : forall (left1:BuiltIn.int) (right1:BuiltIn.int) (a0:(array
      BuiltIn.int)) (a:(array BuiltIn.int)), (right1 = (left1 + 1%Z)%Z) ->
      (((get1 a left1) = (get1 a0 left1)) -> (phase1 left1 right1 a0 a))
  | Node : forall (left1:BuiltIn.int) (right1:BuiltIn.int) (a0:(array
      BuiltIn.int)) (a:(array BuiltIn.int)), ((left1 + 1%Z)%Z < right1)%Z ->
      ((phase1 (go_left left1 right1) left1 a0 a) -> ((phase1 (go_right left1
      right1) right1 a0 a) -> (((get1 a left1) = (sum1 a0
      ((left1 - (right1 - left1)%Z)%Z + 1%Z)%Z (left1 + 1%Z)%Z)) ->
      (phase1 left1 right1 a0 a)))).

Axiom Div_mod_2 : forall (x:BuiltIn.int), (0%Z <= x)%Z ->
  (((2%Z * (ZOdiv x 2%Z))%Z <= x)%Z /\
  ((x - 1%Z)%Z <= (2%Z * (ZOdiv x 2%Z))%Z)%Z).

Axiom phase1_frame : forall (left1:BuiltIn.int) (right1:BuiltIn.int)
  (a0:(array BuiltIn.int)) (a:(array BuiltIn.int)) (a':(array BuiltIn.int)),
  (forall (i:BuiltIn.int), (((left1 - (right1 - left1)%Z)%Z < i)%Z /\
  (i < right1)%Z) -> ((get1 a i) = (get1 a' i))) -> ((phase1 left1 right1 a0
  a) -> (phase1 left1 right1 a0 a')).

Require Import Why3.

(* Why3 goal *)
Theorem phase1_frame2 : forall (left1:BuiltIn.int) (right1:BuiltIn.int)
  (a0:(array BuiltIn.int)) (a0':(array BuiltIn.int)) (a:(array BuiltIn.int)),
  (forall (i:BuiltIn.int), (((left1 - (right1 - left1)%Z)%Z < i)%Z /\
  (i < right1)%Z) -> ((get1 a0 i) = (get1 a0' i))) -> ((phase1 left1 right1
  a0 a) -> (phase1 left1 right1 a0' a)).
intros left1 right1 a0 a0' a h1 h2.
induction h2; why3 "z3".
Qed.


