(* This file is generated by Why3's Coq 8.4 driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require int.Int.
Require list.List.
Require list.Length.
Require list.Nth.
Require option.Option.
Require list.NthLength.

(* Why3 assumption *)
Definition unit := unit.

(* Why3 assumption *)
Fixpoint infix_plpl {a:Type} {a_WT:WhyType a} (l1:list a)
  (l2:list a) {struct l1}: list a :=
  match l1 with
  | nil => l2
  | (cons x1 r1) => (cons x1 (infix_plpl r1 l2))
  end.

Axiom Append_assoc : forall {a:Type} {a_WT:WhyType a}, forall (l1:list a)
  (l2:list a) (l3:list a), ((infix_plpl l1 (infix_plpl l2
  l3)) = (infix_plpl (infix_plpl l1 l2) l3)).

Axiom Append_l_nil : forall {a:Type} {a_WT:WhyType a}, forall (l:list a),
  ((infix_plpl l nil) = l).

Axiom Append_length : forall {a:Type} {a_WT:WhyType a}, forall (l1:list a)
  (l2:list a), ((list.Length.length (infix_plpl l1
  l2)) = ((list.Length.length l1) + (list.Length.length l2))%Z).

(* Why3 assumption *)
Fixpoint mem {a:Type} {a_WT:WhyType a} (x:a) (l:list a) {struct l}: Prop :=
  match l with
  | nil => False
  | (cons y r) => (x = y) \/ (mem x r)
  end.

Axiom mem_append : forall {a:Type} {a_WT:WhyType a}, forall (x:a) (l1:list a)
  (l2:list a), (mem x (infix_plpl l1 l2)) <-> ((mem x l1) \/ (mem x l2)).

Axiom mem_decomp : forall {a:Type} {a_WT:WhyType a}, forall (x:a) (l:list a),
  (mem x l) -> exists l1:list a, exists l2:list a, (l = (infix_plpl l1
  (cons x l2))).

Axiom nth_append_1 : forall {a:Type} {a_WT:WhyType a}, forall (l1:list a)
  (l2:list a) (i:Z), (i < (list.Length.length l1))%Z -> ((list.Nth.nth i
  (infix_plpl l1 l2)) = (list.Nth.nth i l1)).

Axiom nth_append_2 : forall {a:Type} {a_WT:WhyType a}, forall (l1:list a)
  (l2:list a) (i:Z), ((list.Length.length l1) <= i)%Z -> ((list.Nth.nth i
  (infix_plpl l1 l2)) = (list.Nth.nth (i - (list.Length.length l1))%Z l2)).

(* Why3 assumption *)
Definition pal {a:Type} {a_WT:WhyType a} (x:list a) (n:Z): Prop :=
  forall (i:Z), ((0%Z <= i)%Z /\ (i < n)%Z) -> ((list.Nth.nth i
  x) = (list.Nth.nth ((n - 1%Z)%Z - i)%Z x)).

(* Why3 goal *)
Theorem WP_parameter_palindrome_rec : forall {a:Type} {a_WT:WhyType a},
  forall (x:list a) (y:list a),
  ((list.Length.length y) <= (list.Length.length x))%Z ->
  match y with
  | (cons x1 x2) =>
      match x2 with
      | (cons x3 x4) =>
          match x with
          | (cons x5 x6) =>
              ((list.Length.length x4) <= (list.Length.length x6))%Z ->
              ((exists i:Z, ((0%Z <= i)%Z /\
              (i < (list.Length.length x4))%Z) /\ ~ ((list.Nth.nth i
              x6) = (list.Nth.nth (((list.Length.length x4) - 1%Z)%Z - i)%Z
              x6))) -> exists i:Z, ((0%Z <= i)%Z /\
              (i < (list.Length.length y))%Z) /\ ~ ((list.Nth.nth i
              x) = (list.Nth.nth (((list.Length.length y) - 1%Z)%Z - i)%Z
              x)))
          | _ => True
          end
      | nil => True
      end
  | nil => True
  end.
intros a a_WT x y h1.
destruct y; auto.
destruct y; auto.
destruct x; auto.
intros hl (i, (hi1, hi2)).
exists (i+1)%Z; intuition.
unfold Length.length. fold Length.length.
omega.
unfold Length.length in *. fold Length.length in *.
assert (Nth.nth (i+1) (a2 :: x) = Nth.nth i x).
  unfold Nth.nth; fold Nth.nth.
  generalize (Zeq_bool_eq (i+1) 0).
  destruct (Zeq_bool (i+1) 0).
  intuition.
  elimtype False.
  omega.
  intuition.
  replace (i+1-1)%Z with i by omega. auto.
replace (1 + (1 + Length.length y) - 1 - (i + 1))%Z
         with (1 + Length.length y - 1 - i)%Z
  in H1 by omega.
assert (Nth.nth (1 + Length.length y - 1 - i) (a2 :: x) =
        Nth.nth (Length.length y - 1 - i) x).
    unfold Nth.nth; fold Nth.nth.
  generalize (Zeq_bool_eq (1 + Length.length y - 1 - i) 0).
    destruct (Zeq_bool (1 + Length.length y - 1 - i) 0).
  intuition; elimtype False; omega.
  intuition.
  replace (1 + Length.length y - 1 - i - 1)%Z with (Length.length y - 1 - i)%Z
  by omega; auto.
congruence.
Qed.


