(* This file is generated by Why3's Coq 8.4 driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require list.List.
Require list.Length.
Require int.Int.
Require list.Mem.
Require list.Append.

(* Why3 assumption *)
Definition unit := unit.

(* Why3 assumption *)
Definition char := Z.

(* Why3 assumption *)
Inductive regexp :=
  | Empty : regexp
  | Epsilon : regexp
  | Char : Z -> regexp
  | Alt : regexp -> regexp -> regexp
  | Concat : regexp -> regexp -> regexp
  | Star : regexp -> regexp.
Axiom regexp_WhyType : WhyType regexp.
Existing Instance regexp_WhyType.

(* Why3 assumption *)
Definition word := (list Z).

(* Why3 assumption *)
Inductive mem : (list Z) -> regexp -> Prop :=
  | mem_eps : (mem nil Epsilon)
  | mem_char : forall (c:Z), (mem (cons c nil) (Char c))
  | mem_altl : forall (w:(list Z)) (r1:regexp) (r2:regexp), (mem w r1) ->
      (mem w (Alt r1 r2))
  | mem_altr : forall (w:(list Z)) (r1:regexp) (r2:regexp), (mem w r2) ->
      (mem w (Alt r1 r2))
  | mem_concat : forall (w1:(list Z)) (w2:(list Z)) (r1:regexp) (r2:regexp),
      (mem w1 r1) -> ((mem w2 r2) -> (mem (List.app w1 w2) (Concat r1 r2)))
  | mems1 : forall (r:regexp), (mem nil (Star r))
  | mems2 : forall (w1:(list Z)) (w2:(list Z)) (r:regexp), (mem w1 r) ->
      ((mem w2 (Star r)) -> (mem (List.app w1 w2) (Star r))).

Axiom inversion_mem_star : forall (c:Z) (w:(list Z)) (r:regexp),
  forall (w':(list Z)) (r':regexp), ((w' = (cons c w)) /\ (r' = (Star r))) ->
  ((mem w' r') -> exists w1:(list Z), exists w2:(list Z),
  (w = (List.app w1 w2)) /\ ((mem (cons c w1) r) /\ (mem w2 r'))).

Axiom inversion_mem_star2 : forall (c:Z) (w:(list Z)) (r:regexp), (mem
  (cons c w) (Star r)) -> exists w1:(list Z), exists w2:(list Z),
  (w = (List.app w1 w2)) /\ ((mem (cons c w1) r) /\ (mem w2 (Star r))).

(* Why3 goal *)
Theorem WP_parameter_residual : forall (r:regexp) (c:Z),
  match r with
  | Empty => True
  | Epsilon => True
  | (Char c') => True
  | (Alt r1 r2) => True
  | (Concat r1 r2) => forall (result:bool), ((result = true) <-> (mem nil
      r1)) -> ((~ (result = true)) -> forall (o:regexp),
      (forall (w:(list Z)), (mem w o) <-> (mem (cons c w) r1)) ->
      forall (w:(list Z)), (mem w (Concat o r2)) <-> (mem (cons c w) r))
  | (Star r1) => True
  end.
intros r c.
destruct r; auto.
intros.
split; intros.

inversion H2; subst; clear H2.
rewrite List.app_comm_cons.
constructor; auto.
now rewrite <- H1.

inversion H2; subst; clear H2.
destruct w1.
tauto.
simpl in H3.
injection H3; intros; subst; clear H3.
constructor; auto.
now rewrite H1.
Qed.

