(* This file is generated by Why3's Coq 8.4 driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require int.Int.
Require map.Map.
Require map.MapPermut.

(* Why3 assumption *)
Definition unit := unit.

(* Why3 assumption *)
Inductive ref (a:Type) {a_WT:WhyType a} :=
  | mk_ref : a -> ref a.
Axiom ref_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (ref a).
Existing Instance ref_WhyType.
Implicit Arguments mk_ref [[a] [a_WT]].

(* Why3 assumption *)
Definition contents {a:Type} {a_WT:WhyType a} (v:(@ref a a_WT)): a :=
  match v with
  | (mk_ref x) => x
  end.

(* Why3 assumption *)
Inductive array
  (a:Type) {a_WT:WhyType a} :=
  | mk_array : Z -> (@map.Map.map Z _ a a_WT) -> array a.
Axiom array_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (array a).
Existing Instance array_WhyType.
Implicit Arguments mk_array [[a] [a_WT]].

(* Why3 assumption *)
Definition elts {a:Type} {a_WT:WhyType a} (v:(@array a a_WT)): (@map.Map.map
  Z _ a a_WT) := match v with
  | (mk_array x x1) => x1
  end.

(* Why3 assumption *)
Definition length {a:Type} {a_WT:WhyType a} (v:(@array a a_WT)): Z :=
  match v with
  | (mk_array x x1) => x
  end.

(* Why3 assumption *)
Definition get {a:Type} {a_WT:WhyType a} (a1:(@array a a_WT)) (i:Z): a :=
  (map.Map.get (elts a1) i).

(* Why3 assumption *)
Definition set {a:Type} {a_WT:WhyType a} (a1:(@array a a_WT)) (i:Z)
  (v:a): (@array a a_WT) := (mk_array (length a1) (map.Map.set (elts a1) i
  v)).

(* Why3 assumption *)
Definition make {a:Type} {a_WT:WhyType a} (n:Z) (v:a): (@array a a_WT) :=
  (mk_array n (map.Map.const v:(@map.Map.map Z _ a a_WT))).

(* Why3 assumption *)
Definition sorted_sub (a:(@map.Map.map Z _ Z _)) (l:Z) (u:Z): Prop :=
  forall (i1:Z) (i2:Z), ((l <= i1)%Z /\ ((i1 <= i2)%Z /\ (i2 < u)%Z)) ->
  ((map.Map.get a i1) <= (map.Map.get a i2))%Z.

(* Why3 assumption *)
Definition sorted_sub1 (a:(@array Z _)) (l:Z) (u:Z): Prop := (sorted_sub
  (elts a) l u).

(* Why3 assumption *)
Definition sorted (a:(@array Z _)): Prop := (sorted_sub (elts a) 0%Z
  (length a)).

(* Why3 assumption *)
Definition map_eq_sub {a:Type} {a_WT:WhyType a} (a1:(@map.Map.map Z _
  a a_WT)) (a2:(@map.Map.map Z _ a a_WT)) (l:Z) (u:Z): Prop := forall (i:Z),
  ((l <= i)%Z /\ (i < u)%Z) -> ((map.Map.get a1 i) = (map.Map.get a2 i)).

(* Why3 assumption *)
Definition array_eq_sub {a:Type} {a_WT:WhyType a} (a1:(@array a a_WT))
  (a2:(@array a a_WT)) (l:Z) (u:Z): Prop := ((length a1) = (length a2)) /\
  (((0%Z <= l)%Z /\ (l <= (length a1))%Z) /\ (((0%Z <= u)%Z /\
  (u <= (length a1))%Z) /\ (map_eq_sub (elts a1) (elts a2) l u))).

(* Why3 assumption *)
Definition array_eq {a:Type} {a_WT:WhyType a} (a1:(@array a a_WT))
  (a2:(@array a a_WT)): Prop := ((length a1) = (length a2)) /\ (map_eq_sub
  (elts a1) (elts a2) 0%Z (length a1)).

(* Why3 assumption *)
Definition exchange {a:Type} {a_WT:WhyType a} (a1:(@array a a_WT))
  (a2:(@array a a_WT)) (i:Z) (j:Z): Prop := ((length a1) = (length a2)) /\
  (((0%Z <= i)%Z /\ (i < (length a1))%Z) /\ (((0%Z <= j)%Z /\
  (j < (length a1))%Z) /\ (((get a1 i) = (get a2 j)) /\ (((get a1
  j) = (get a2 i)) /\ forall (k:Z), ((0%Z <= k)%Z /\ (k < (length a1))%Z) ->
  ((~ (k = i)) -> ((~ (k = j)) -> ((get a1 k) = (get a2 k)))))))).

(* Why3 assumption *)
Definition permut {a:Type} {a_WT:WhyType a} (a1:(@array a a_WT)) (a2:(@array
  a a_WT)) (l:Z) (u:Z): Prop := ((length a1) = (length a2)) /\
  (((0%Z <= l)%Z /\ (l <= (length a1))%Z) /\ (((0%Z <= u)%Z /\
  (u <= (length a1))%Z) /\ (map.MapPermut.permut (elts a1) (elts a2) l u))).

(* Why3 assumption *)
Definition permut_sub {a:Type} {a_WT:WhyType a} (a1:(@array a a_WT))
  (a2:(@array a a_WT)) (l:Z) (u:Z): Prop := (map_eq_sub (elts a1) (elts a2)
  0%Z l) /\ ((permut a1 a2 l u) /\ (map_eq_sub (elts a1) (elts a2) u
  (length a1))).

(* Why3 assumption *)
Definition permut_all {a:Type} {a_WT:WhyType a} (a1:(@array a a_WT))
  (a2:(@array a a_WT)): Prop := ((length a1) = (length a2)) /\
  (map.MapPermut.permut (elts a1) (elts a2) 0%Z (length a1)).

Axiom permut_all_refl : forall {a:Type} {a_WT:WhyType a}, forall (a1:(@array
  a a_WT)), (permut_all a1 a1).

Axiom exchange_permut_all : forall {a:Type} {a_WT:WhyType a},
  forall (a1:(@array a a_WT)) (a2:(@array a a_WT)) (i:Z) (j:Z), (exchange a1
  a2 i j) -> (permut_all a1 a2).

Axiom permut_all_sym : forall {a:Type} {a_WT:WhyType a}, forall (a1:(@array
  a a_WT)) (a2:(@array a a_WT)), (permut_all a1 a2) -> (permut_all a2 a1).

Axiom permut_all_trans : forall {a:Type} {a_WT:WhyType a}, forall (a1:(@array
  a a_WT)) (a2:(@array a a_WT)) (a3:(@array a a_WT)), (permut_all a1 a2) ->
  ((permut_all a2 a3) -> (permut_all a1 a3)).

Axiom array_eq_permut_all : forall {a:Type} {a_WT:WhyType a},
  forall (a1:(@array a a_WT)) (a2:(@array a a_WT)), (array_eq a1 a2) ->
  (permut_all a1 a2).

Axiom permut_sub_weakening : forall {a:Type} {a_WT:WhyType a},
  forall (a1:(@array a a_WT)) (a2:(@array a a_WT)) (l1:Z) (u1:Z) (l2:Z)
  (u2:Z), (permut_sub a1 a2 l1 u1) -> (((0%Z <= l2)%Z /\ (l2 <= l1)%Z) ->
  (((u1 <= u2)%Z /\ (u2 <= (length a1))%Z) -> (permut_sub a1 a2 l2 u2))).

Axiom permut_sub_permut_all : forall {a:Type} {a_WT:WhyType a},
  forall (a1:(@array a a_WT)) (a2:(@array a a_WT)) (l:Z) (u:Z), (permut_sub
  a1 a2 l u) -> (permut_all a1 a2).

Import MapPermut.

(* Why3 goal *)
Theorem WP_parameter_quick_rec : forall (t:Z) (t1:(@map.Map.map Z _ Z _))
  (l:Z) (r:Z), let t2 := (mk_array t t1) in (((0%Z <= t)%Z /\
  ((0%Z <= l)%Z /\ ((l <= (r + 1%Z)%Z)%Z /\ ((r + 1%Z)%Z <= t)%Z))) ->
  ((l < r)%Z -> (((0%Z <= l)%Z /\ (l < t)%Z) -> let v := (map.Map.get t1
  l) in let o := (l + 1%Z)%Z in ((o <= r)%Z -> forall (m:Z) (t3:(@map.Map.map
  Z _ Z _)), let t4 := (mk_array t t3) in forall (i:Z), ((o <= i)%Z /\
  (i <= r)%Z) -> (((forall (j:Z), ((l < j)%Z /\ (j <= m)%Z) ->
  ((map.Map.get t3 j) < v)%Z) /\ ((forall (j:Z), ((m < j)%Z /\ (j < i)%Z) ->
  (v <= (map.Map.get t3 j))%Z) /\ ((permut_sub t2 t4 l (r + 1%Z)%Z) /\
  (((map.Map.get t3 l) = v) /\ ((l <= m)%Z /\ (m < i)%Z))))) ->
  (((0%Z <= t)%Z /\ ((0%Z <= i)%Z /\ (i < t)%Z)) -> (((map.Map.get t3
  i) < v)%Z -> forall (m1:Z), (m1 = (m + 1%Z)%Z) -> ((((0%Z <= i)%Z /\
  (i < t)%Z) /\ ((0%Z <= m1)%Z /\ (m1 < t)%Z)) -> forall (t5:(@map.Map.map
  Z _ Z _)), let t6 := (mk_array t t5) in (((0%Z <= t)%Z /\ (exchange t4 t6 i
  m1)) -> ((forall (j:Z), ((l < j)%Z /\ (j <= m1)%Z) -> ((map.Map.get t5
  j) < v)%Z) /\ ((forall (j:Z), ((m1 < j)%Z /\ (j < (i + 1%Z)%Z)%Z) ->
  (v <= (map.Map.get t5 j))%Z) /\ ((permut_sub t2 t6 l (r + 1%Z)%Z) /\
  (((map.Map.get t5 l) = v) /\ ((l <= m1)%Z /\
  (m1 < (i + 1%Z)%Z)%Z)))))))))))))).
(* Why3 intros t t1 l r t2 (h1,(h2,(h3,h4))) h5 (h6,h7) v o h8 m t3 t4 i
        (h9,h10) (h11,(h12,(h13,(h14,(h15,h16))))) (h17,(h18,h19)) h20 m1 h21
        ((h22,h23),(h24,h25)) t5 t6 (h26,h27). *)
(* intros t l r t1 (h1,(h2,h3)) h4 (h5,h6) v h7 m t2 i (h8,h9)
   (h10,(h11,(h12,(h13,(h14,h15))))) (h16,(h17,h18)) h19 m1 h20
   ((h21,h22),(h23,h24)) t3 (h25,h26). *)
(* YOU MAY EDIT THE PROOF BELOW *)
intuition.
intuition.
Qed.

