(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require int.Int.
Require list.List.
Require list.Length.
Require list.Mem.
Require list.Append.

(* Why3 assumption *)
Definition unit := unit.

(* Why3 assumption *)
Inductive sorted : (list Z) -> Prop :=
  | Sorted_Nil : (sorted nil)
  | Sorted_One : forall (x:Z), (sorted (cons x nil))
  | Sorted_Two : forall (x:Z) (y:Z) (l:(list Z)), (x <= y)%Z -> ((sorted
      (cons y l)) -> (sorted (cons x (cons y l)))).

Axiom sorted_mem : forall (x:Z) (l:(list Z)), ((forall (y:Z), (list.Mem.mem y
  l) -> (x <= y)%Z) /\ (sorted l)) <-> (sorted (cons x l)).

Parameter num_occ: forall {a:Type} {a_WT:WhyType a}, a -> (list a) -> Z.

Axiom num_occ_def : forall {a:Type} {a_WT:WhyType a}, forall (x:a)
  (l:(list a)),
  match l with
  | nil => ((num_occ x l) = 0%Z)
  | (cons y r) => ((x = y) -> ((num_occ x l) = (1%Z + (num_occ x r))%Z)) /\
      ((~ (x = y)) -> ((num_occ x l) = (0%Z + (num_occ x r))%Z))
  end.

Axiom Mem_Num_Occ : forall {a:Type} {a_WT:WhyType a}, forall (x:a)
  (l:(list a)), (list.Mem.mem x l) <-> (0%Z < (num_occ x l))%Z.

Axiom Append_Num_Occ : forall {a:Type} {a_WT:WhyType a}, forall (x:a)
  (l1:(list a)) (l2:(list a)), ((num_occ x (List.app l1 l2)) = ((num_occ x
  l1) + (num_occ x l2))%Z).

(* Why3 assumption *)
Definition permut {a:Type} {a_WT:WhyType a} (l1:(list a))
  (l2:(list a)): Prop := forall (x:a), ((num_occ x l1) = (num_occ x l2)).

Axiom Permut_refl : forall {a:Type} {a_WT:WhyType a}, forall (l:(list a)),
  (permut l l).

Axiom Permut_sym : forall {a:Type} {a_WT:WhyType a}, forall (l1:(list a))
  (l2:(list a)), (permut l1 l2) -> (permut l2 l1).

Axiom Permut_trans : forall {a:Type} {a_WT:WhyType a}, forall (l1:(list a))
  (l2:(list a)) (l3:(list a)), (permut l1 l2) -> ((permut l2 l3) -> (permut
  l1 l3)).

Axiom Permut_cons : forall {a:Type} {a_WT:WhyType a}, forall (x:a)
  (l1:(list a)) (l2:(list a)), (permut l1 l2) -> (permut (cons x l1)
  (cons x l2)).

Axiom Permut_swap : forall {a:Type} {a_WT:WhyType a}, forall (x:a) (y:a)
  (l:(list a)), (permut (cons x (cons y l)) (cons y (cons x l))).

Axiom Permut_cons_append : forall {a:Type} {a_WT:WhyType a}, forall (x:a)
  (l1:(list a)) (l2:(list a)), (permut (List.app (cons x l1) l2)
  (List.app l1 (cons x l2))).

Axiom Permut_assoc : forall {a:Type} {a_WT:WhyType a}, forall (l1:(list a))
  (l2:(list a)) (l3:(list a)), (permut (List.app (List.app l1 l2) l3)
  (List.app l1 (List.app l2 l3))).

Axiom Permut_append : forall {a:Type} {a_WT:WhyType a}, forall (l1:(list a))
  (l2:(list a)) (k1:(list a)) (k2:(list a)), (permut l1 k1) -> ((permut l2
  k2) -> (permut (List.app l1 l2) (List.app k1 k2))).

Axiom Permut_append_swap : forall {a:Type} {a_WT:WhyType a},
  forall (l1:(list a)) (l2:(list a)), (permut (List.app l1 l2)
  (List.app l2 l1)).

Axiom Permut_mem : forall {a:Type} {a_WT:WhyType a}, forall (x:a)
  (l1:(list a)) (l2:(list a)), (permut l1 l2) -> ((list.Mem.mem x l1) ->
  (list.Mem.mem x l2)).

Axiom Permut_length : forall {a:Type} {a_WT:WhyType a}, forall (l1:(list a))
  (l2:(list a)), (permut l1 l2) ->
  ((list.Length.length l1) = (list.Length.length l2)).


(* Why3 goal *)
Theorem WP_parameter_mergesort : forall (l:(list Z)),
  match l with
  | (nil|(cons _ nil)) => True
  | _ => (2%Z <= (list.Length.length l))%Z -> forall (result:(list Z))
      (result1:(list Z)), ((1%Z <= (list.Length.length result))%Z /\
      ((1%Z <= (list.Length.length result1))%Z /\ (permut l
      (List.app result result1)))) -> forall (o:(list Z)), ((sorted o) /\
      (permut o result1)) -> forall (o1:(list Z)), ((sorted o1) /\ (permut o1
      result)) -> (((sorted o1) /\ (sorted o)) -> forall (result2:(list Z)),
      ((sorted result2) /\ (permut result2 (List.app o1 o))) -> (permut
      result2 l))
  end.
(* Why3 intros l. *)
destruct l; try trivial.
destruct l; try trivial.
intuition.
apply Permut_trans with (app o1 o); auto.
apply Permut_trans with (app result result1); auto.
apply Permut_append; auto.
apply Permut_sym; auto.
Qed.


