(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import ZArith.
Require Import Rbase.
Definition unit  := unit.

Parameter mark : Type.

Parameter at1: forall (a:Type), a -> mark  -> a.

Implicit Arguments at1.

Parameter old: forall (a:Type), a  -> a.

Implicit Arguments old.

Inductive list (a:Type) :=
  | Nil : list a
  | Cons : a -> (list a) -> list a.
Set Contextual Implicit.
Implicit Arguments Nil.
Unset Contextual Implicit.
Implicit Arguments Cons.

Set Implicit Arguments.
Fixpoint length (a:Type)(l:(list a)) {struct l}: Z :=
  match l with
  | Nil  => 0%Z
  | Cons _ r => (1%Z + (length r))%Z
  end.
Unset Implicit Arguments.

Axiom Length_nonnegative : forall (a:Type), forall (l:(list a)),
  (0%Z <= (length l))%Z.

Axiom Length_nil : forall (a:Type), forall (l:(list a)),
  ((length l) = 0%Z) <-> (l = (Nil:(list a))).

Inductive sorted : (list Z) -> Prop :=
  | Sorted_Nil : (sorted (Nil:(list Z)))
  | Sorted_One : forall (x:Z), (sorted (Cons x (Nil:(list Z))))
  | Sorted_Two : forall (x:Z) (y:Z) (l:(list Z)), (x <= y)%Z ->
      ((sorted (Cons y l)) -> (sorted (Cons x (Cons y l)))).

Set Implicit Arguments.
Fixpoint mem (a:Type)(x:a) (l:(list a)) {struct l}: Prop :=
  match l with
  | Nil  => False
  | Cons y r => (x = y) \/ (mem x r)
  end.
Unset Implicit Arguments.

Axiom Sorted_mem : forall (x:Z) (l:(list Z)), ((forall (y:Z), (mem y l) ->
  (x <= y)%Z) /\ (sorted l)) <-> (sorted (Cons x l)).

Set Implicit Arguments.
Fixpoint infix_plpl (a:Type)(l1:(list a)) (l2:(list a)) {struct l1}: (list
  a) :=
  match l1 with
  | Nil  => l2
  | Cons x1 r1 => (Cons x1 (infix_plpl r1 l2))
  end.
Unset Implicit Arguments.

Axiom Append_assoc : forall (a:Type), forall (l1:(list a)) (l2:(list a))
  (l3:(list a)), ((infix_plpl l1 (infix_plpl l2
  l3)) = (infix_plpl (infix_plpl l1 l2) l3)).

Axiom Append_l_nil : forall (a:Type), forall (l:(list a)), ((infix_plpl l
  (Nil:(list a))) = l).

Axiom Append_length : forall (a:Type), forall (l1:(list a)) (l2:(list a)),
  ((length (infix_plpl l1 l2)) = ((length l1) + (length l2))%Z).

Axiom mem_append : forall (a:Type), forall (x:a) (l1:(list a)) (l2:(list a)),
  (mem x (infix_plpl l1 l2)) <-> ((mem x l1) \/ (mem x l2)).

Axiom mem_decomp : forall (a:Type), forall (x:a) (l:(list a)), (mem x l) ->
  exists l1:(list a), exists l2:(list a), (l = (infix_plpl l1 (Cons x l2))).

Parameter num_occ: forall (a:Type), a -> (list a)  -> Z.

Implicit Arguments num_occ.

Axiom num_occ_def : forall (a:Type), forall (x:a) (l:(list a)),
  match l with
  | Nil  => ((num_occ x l) = 0%Z)
  | Cons y r => ((x = y) -> ((num_occ x l) = (1%Z + (num_occ x r))%Z)) /\
      ((~ (x = y)) -> ((num_occ x l) = (0%Z + (num_occ x r))%Z))
  end.

Axiom Mem_Num_Occ : forall (a:Type), forall (x:a) (l:(list a)), (mem x l) <->
  (0%Z <  (num_occ x l))%Z.

Definition permut (a:Type)(l1:(list a)) (l2:(list a)): Prop := forall (x:a),
  ((num_occ x l1) = (num_occ x l2)).
Implicit Arguments permut.

Axiom Permut_refl : forall (a:Type), forall (l:(list a)), (permut l l).

Axiom Permut_sym : forall (a:Type), forall (l1:(list a)) (l2:(list a)),
  (permut l1 l2) -> (permut l2 l1).

Axiom Permut_trans : forall (a:Type), forall (l1:(list a)) (l2:(list a))
  (l3:(list a)), (permut l1 l2) -> ((permut l2 l3) -> (permut l1 l3)).

Axiom Permut_cons : forall (a:Type), forall (x:a) (l1:(list a)) (l2:(list
  a)), (permut l1 l2) -> (permut (Cons x l1) (Cons x l2)).

Axiom Permut_swap : forall (a:Type), forall (x:a) (y:a) (l:(list a)),
  (permut (Cons x (Cons y l)) (Cons y (Cons x l))).

Axiom Permut_mem : forall (a:Type), forall (x:a) (l1:(list a)) (l2:(list a)),
  (permut l1 l2) -> ((mem x l1) -> (mem x l2)).

Axiom Permut_length : forall (a:Type), forall (l1:(list a)) (l2:(list a)),
  (permut l1 l2) -> ((length l1) = (length l2)).

Axiom Permut_cons_append : forall (a:Type), forall (x:a) (l1:(list a))
  (l2:(list a)), (permut (infix_plpl (Cons x l1) l2) (infix_plpl l1 (Cons x
  l2))).

Theorem Permut_append : forall (a:Type), forall (l1:(list a)) (l2:(list a))
  (k1:(list a)) (k2:(list a)), (permut l1 k1) -> ((permut l2 k2) ->
  (permut (infix_plpl l1 l2) (infix_plpl k1 k2))).
(* YOU MAY EDIT THE PROOF BELOW *)
intro a.
(*** moved to list.why
assert (mem_decomp: forall (x:a) (l:list a), mem x l -> 
   exists l1: list a, exists l2 : list a, l = infix_plpl l1 (Cons x l2)).
induction l; simpl; intros.
elim H.
destruct H.
subst a0. exists Nil. exists l; auto.
destruct (IHl H) as (e1, (e2, h12)).
exists (Cons a0 e1); exists e2.
simpl; apply f_equal; auto.
***)
induction l1; simpl.
intros l2 k1 k2 hk1.
assert (k1 = Nil).
assert (length (@Nil a) = length k1)%Z.
apply Permut_length; auto.
simpl in H.
destruct k1; auto.
absurd (0%Z = length (Cons a0 k1)); auto.
unfold length; fold length.
generalize (Length_nonnegative _ k1).
omega.
subst k1; simpl; auto.

intros.
assert (mem a0 k1).
apply Permut_mem with (Cons a0 l1); auto.
red; auto.
destruct (mem_decomp _ a0 k1 H1) as (e1, (e2, heq)).
subst k1.

apply Permut_trans with (Cons a0 (infix_plpl (infix_plpl e1 e2) k2)); auto.
apply Permut_cons.
apply IHl1; auto.

assert (permut (Cons a0 l1) (Cons a0 (infix_plpl e1 e2))).
apply Permut_trans with (infix_plpl e1 (Cons a0 e2)); auto.
apply Permut_sym.
apply Permut_cons_append.

red in H2; simpl in H2. 
red; intros.
generalize (H2 x); clear H2; intro.
generalize (num_occ_def _ x (Cons a0 l1)).
generalize (num_occ_def _ x (Cons a0 (infix_plpl e1 e2))).
assert (h: (x = a0 \/ x <> a0)%Z) by admit (* excluded middle *).
destruct h; intuition.
do 2 rewrite <- Append_assoc.
simpl.
apply Permut_cons_append.
Qed.
(* DO NOT EDIT BELOW *)


