(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require int.Int.
Require list.List.
Require list.Length.
Require list.Mem.
Require map.Map.
Require list.Append.
Require list.Reverse.

(* Why3 assumption *)
Definition unit := unit.

Parameter head: forall {a:Type} {a_WT:WhyType a}, (list a) -> a.

Axiom head_cons : forall {a:Type} {a_WT:WhyType a}, forall (x:a)
  (l:(list a)), ((head (cons x l)) = x).

Parameter tail: forall {a:Type} {a_WT:WhyType a}, (list a) -> (list a).

Axiom tail_cons : forall {a:Type} {a_WT:WhyType a}, forall (x:a)
  (l:(list a)), ((tail (cons x l)) = l).

(* Why3 assumption *)
Definition disjoint {a:Type} {a_WT:WhyType a} (l1:(list a))
  (l2:(list a)): Prop := forall (x:a), ~ ((list.Mem.mem x l1) /\
  (list.Mem.mem x l2)).

(* Why3 assumption *)
Fixpoint no_repet {a:Type} {a_WT:WhyType a} (l:(list a)) {struct l}: Prop :=
  match l with
  | nil => True
  | (cons x r) => (~ (list.Mem.mem x r)) /\ (no_repet r)
  end.

Axiom loc : Type.
Parameter loc_WhyType : WhyType loc.
Existing Instance loc_WhyType.

Parameter null: loc.

(* Why3 assumption *)
Inductive list_seg : loc -> (@map.Map.map loc loc_WhyType loc loc_WhyType)
  -> (list loc) -> loc -> Prop :=
  | list_seg_nil : forall (p:loc) (next:(@map.Map.map loc loc_WhyType
      loc loc_WhyType)), (list_seg p next nil p)
  | list_seg_cons : forall (p:loc) (q:loc) (next:(@map.Map.map
      loc loc_WhyType loc loc_WhyType)) (l:(list loc)), ((~ (p = null)) /\
      (list_seg (map.Map.get next p) next l q)) -> (list_seg p next
      (cons p l) q).

Axiom list_seg_frame : forall (next1:(@map.Map.map loc loc_WhyType
  loc loc_WhyType)) (next2:(@map.Map.map loc loc_WhyType loc loc_WhyType))
  (p:loc) (q:loc) (v:loc) (pM:(list loc)), ((list_seg p next1 pM null) /\
  ((next2 = (map.Map.set next1 q v)) /\ ~ (list.Mem.mem q pM))) -> (list_seg
  p next2 pM null).

Axiom list_seg_functional : forall (next:(@map.Map.map loc loc_WhyType
  loc loc_WhyType)) (l1:(list loc)) (l2:(list loc)) (p:loc), ((list_seg p
  next l1 null) /\ (list_seg p next l2 null)) -> (l1 = l2).

Axiom list_seg_sublistl : forall (next:(@map.Map.map loc loc_WhyType
  loc loc_WhyType)) (l1:(list loc)) (l2:(list loc)) (p:loc) (q:loc),
  (list_seg p next (List.app l1 (cons q l2)) null) -> (list_seg q next
  (cons q l2) null).

(* Why3 goal *)
Theorem list_seg_no_repet : forall (next:(@map.Map.map loc loc_WhyType
  loc loc_WhyType)) (pM:(list loc)) (p:loc), (list_seg p next pM null) ->
  (no_repet pM).
(* Why3 intros next pM p h1. *)
Proof.
induction pM.
now simpl.
intros p h.
assert (a=p) by (inversion h; auto).
subst a.
split.
intro h1.
destruct (Append.mem_decomp p pM h1) as (l1 & l2 & h2).
subst pM.
change (cons p (app l1 (cons p l2))) with (app (cons p l1) (cons p l2)) in h.
assert (h2 := list_seg_sublistl _ _ _ _ _ h).
assert (h3 := list_seg_functional _ _ _ _ (conj h h2)).
assert (h4 := (f_equal Length.length h3)).
rewrite Append.Append_length in h4.
generalize (Length.Length_nonnegative l1).
change (Length.length (cons p l1)) with (1+Length.length l1)%Z in h4.
omega.
inversion h; subst; clear h.
apply IHpM with (p := Map.get next p).
tauto.
Qed.


