(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require int.Int.
Require map.Map.

(* Why3 assumption *)
Inductive datatype  :=
  | Tint : datatype 
  | Tbool : datatype .
Axiom datatype_WhyType : WhyType datatype.
Existing Instance datatype_WhyType.

(* Why3 assumption *)
Inductive operator  :=
  | Oplus : operator 
  | Ominus : operator 
  | Omult : operator 
  | Ole : operator .
Axiom operator_WhyType : WhyType operator.
Existing Instance operator_WhyType.

(* Why3 assumption *)
Definition ident  := Z.

(* Why3 assumption *)
Inductive term  :=
  | Tconst : Z -> term 
  | Tvar : Z -> term 
  | Tderef : Z -> term 
  | Tbin : term -> operator -> term -> term .
Axiom term_WhyType : WhyType term.
Existing Instance term_WhyType.

(* Why3 assumption *)
Inductive fmla  :=
  | Fterm : term -> fmla 
  | Fand : fmla -> fmla -> fmla 
  | Fnot : fmla -> fmla 
  | Fimplies : fmla -> fmla -> fmla 
  | Flet : Z -> term -> fmla -> fmla 
  | Fforall : Z -> datatype -> fmla -> fmla .
Axiom fmla_WhyType : WhyType fmla.
Existing Instance fmla_WhyType.

(* Why3 assumption *)
Inductive value  :=
  | Vint : Z -> value 
  | Vbool : bool -> value .
Axiom value_WhyType : WhyType value.
Existing Instance value_WhyType.

(* Why3 assumption *)
Definition env  := (map.Map.map Z value).

(* Why3 assumption *)
Definition var_env  := (map.Map.map Z value).

(* Why3 assumption *)
Definition ref_env  := (map.Map.map Z value).

(* Why3 assumption *)
Inductive state  :=
  | mk_state : (map.Map.map Z value) -> (map.Map.map Z value) -> state .
Axiom state_WhyType : WhyType state.
Existing Instance state_WhyType.

(* Why3 assumption *)
Definition ref_env1(v:state): (map.Map.map Z value) :=
  match v with
  | (mk_state x x1) => x1
  end.

(* Why3 assumption *)
Definition var_env1(v:state): (map.Map.map Z value) :=
  match v with
  | (mk_state x x1) => x
  end.

Parameter eval_bin: value -> operator -> value -> value.

Axiom eval_bin_def : forall (x:value) (op:operator) (y:value), match (x,
  y) with
  | ((Vint x1), (Vint y1)) =>
      match op with
      | Oplus => ((eval_bin x op y) = (Vint (x1 + y1)%Z))
      | Ominus => ((eval_bin x op y) = (Vint (x1 - y1)%Z))
      | Omult => ((eval_bin x op y) = (Vint (x1 * y1)%Z))
      | Ole => ((x1 <= y1)%Z -> ((eval_bin x op y) = (Vbool true))) /\
          ((~ (x1 <= y1)%Z) -> ((eval_bin x op y) = (Vbool false)))
      end
  | (_, _) => ((eval_bin x op y) = (Vbool false))
  end.

(* Why3 assumption *)
Fixpoint eval_term(s:state) (t:term) {struct t}: value :=
  match t with
  | (Tconst n) => (Vint n)
  | (Tvar id) => (map.Map.get (var_env1 s) id)
  | (Tderef id) => (map.Map.get (ref_env1 s) id)
  | (Tbin t1 op t2) => (eval_bin (eval_term s t1) op (eval_term s t2))
  end.

(* Why3 assumption *)
Fixpoint eval_fmla(s:state) (f:fmla) {struct f}: Prop :=
  match f with
  | (Fterm t) => ((eval_term s t) = (Vbool true))
  | (Fand f1 f2) => (eval_fmla s f1) /\ (eval_fmla s f2)
  | (Fnot f1) => ~ (eval_fmla s f1)
  | (Fimplies f1 f2) => (eval_fmla s f1) -> (eval_fmla s f2)
  | (Flet x t f1) => (eval_fmla (mk_state (map.Map.set (var_env1 s) x
      (eval_term s t)) (ref_env1 s)) f1)
  | (Fforall x Tint f1) => forall (n:Z),
      (eval_fmla (mk_state (map.Map.set (var_env1 s) x (Vint n))
      (ref_env1 s)) f1)
  | (Fforall x Tbool f1) => forall (b:bool),
      (eval_fmla (mk_state (map.Map.set (var_env1 s) x (Vbool b))
      (ref_env1 s)) f1)
  end.

Parameter subst_term: term -> Z -> term -> term.

Axiom subst_term_def : forall (e:term) (x:Z) (t:term),
  match e with
  | (Tconst _) => ((subst_term e x t) = e)
  | (Tvar _) => ((subst_term e x t) = e)
  | (Tderef y) => ((x = y) -> ((subst_term e x t) = t)) /\ ((~ (x = y)) ->
      ((subst_term e x t) = e))
  | (Tbin e1 op e2) => ((subst_term e x t) = (Tbin (subst_term e1 x t) op
      (subst_term e2 x t)))
  end.

Axiom eval_subst_term : forall (s:state) (e:term) (x:Z) (t:term),
  ((eval_term s (subst_term e x t)) = (eval_term (mk_state (var_env1 s)
  (map.Map.set (ref_env1 s) x (eval_term s t))) e)).

(* Why3 assumption *)
Fixpoint subst(f:fmla) (x:Z) (t:term) {struct f}: fmla :=
  match f with
  | (Fterm e) => (Fterm (subst_term e x t))
  | (Fand f1 f2) => (Fand (subst f1 x t) (subst f2 x t))
  | (Fnot f1) => (Fnot (subst f1 x t))
  | (Fimplies f1 f2) => (Fimplies (subst f1 x t) (subst f2 x t))
  | (Flet y t' f1) => (Flet y t' (subst f1 x t))
  | (Fforall y ty f1) => (Fforall y ty (subst f1 x t))
  end.

Axiom eval_subst : forall (f:fmla) (s:state) (x:Z) (t:term), (eval_fmla s
  (subst f x t)) <-> (eval_fmla (mk_state (var_env1 s)
  (map.Map.set (ref_env1 s) x (eval_term s t))) f).

(* Why3 assumption *)
Inductive stmt  :=
  | Sskip : stmt 
  | Sassign : Z -> term -> stmt 
  | Sseq : stmt -> stmt -> stmt 
  | Sif : term -> stmt -> stmt -> stmt 
  | Sassert : fmla -> stmt 
  | Swhile : term -> fmla -> stmt -> stmt .
Axiom stmt_WhyType : WhyType stmt.
Existing Instance stmt_WhyType.

Axiom check_skip : forall (s:stmt), (s = Sskip) \/ ~ (s = Sskip).

(* Why3 assumption *)
Inductive one_step : state -> stmt -> state -> stmt -> Prop :=
  | one_step_assign : forall (s:state) (x:Z) (e:term), (one_step s (Sassign x
      e) (mk_state (var_env1 s) (map.Map.set (ref_env1 s) x (eval_term s e)))
      Sskip)
  | one_step_seq : forall (s:state) (s':state) (i1:stmt) (i1':stmt)
      (i2:stmt), (one_step s i1 s' i1') -> (one_step s (Sseq i1 i2) s'
      (Sseq i1' i2))
  | one_step_seq_skip : forall (s:state) (i:stmt), (one_step s (Sseq Sskip i)
      s i)
  | one_step_if_true : forall (s:state) (e:term) (i1:stmt) (i2:stmt),
      ((eval_term s e) = (Vbool true)) -> (one_step s (Sif e i1 i2) s i1)
  | one_step_if_false : forall (s:state) (e:term) (i1:stmt) (i2:stmt),
      ((eval_term s e) = (Vbool false)) -> (one_step s (Sif e i1 i2) s i2)
  | one_step_assert : forall (s:state) (f:fmla), (eval_fmla s f) ->
      (one_step s (Sassert f) s Sskip)
  | one_step_while_true : forall (s:state) (e:term) (inv:fmla) (i:stmt),
      (eval_fmla s inv) -> (((eval_term s e) = (Vbool true)) -> (one_step s
      (Swhile e inv i) s (Sseq i (Swhile e inv i))))
  | one_step_while_false : forall (s:state) (e:term) (inv:fmla) (i:stmt),
      (eval_fmla s inv) -> (((eval_term s e) = (Vbool false)) -> (one_step s
      (Swhile e inv i) s Sskip)).


(* Why3 goal *)
Theorem If42 : forall (s1:state) (s2:state) (i:stmt),
  (one_step (mk_state (map.Map.const (Vint 42%Z):(map.Map.map Z value))
  (map.Map.const (Vint 0%Z):(map.Map.map Z value))) (Sif (Tbin (Tderef 0%Z)
  Ole (Tconst 10%Z)) (Sassign 0%Z (Tconst 13%Z)) (Sassign 0%Z (Tconst 42%Z)))
  s1 i) -> ((one_step s1 i s2 Sskip) -> ((map.Map.get (ref_env1 s2)
  0%Z) = (Vint 13%Z))).
Proof.
intros s1 s2 i H1 H2.
inversion H1; subst; clear H1.
inversion H7; subst; clear H7.
inversion H2; subst; clear H2.
Opaque Map.const.
simpl.
rewrite Map.Select_eq; auto.

inversion H7; subst; clear H7.
clear H2.
rewrite Map.Const in H0.
generalize (eval_bin_def (Vint 0) Ole (Vint 10)).
rewrite H0; clear H0.
assert (h:((0 <= 10)%Z)) by omega.
intros (H1,_).
generalize (H1 h).
intro; discriminate.
Qed.


