(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import ZArith.
Require Import Rbase.
Inductive t  :=
  | mk_t : Z -> Z -> Z -> Z -> t .

Definition a11(u:t): Z := match u with
  | (mk_t a111 _ _ _) => a111
  end.

Definition a12(u:t): Z := match u with
  | (mk_t _ a121 _ _) => a121
  end.

Definition a21(u:t): Z := match u with
  | (mk_t _ _ a211 _) => a211
  end.

Definition a22(u:t): Z := match u with
  | (mk_t _ _ _ a221) => a221
  end.

Definition mult(x:t) (y:t): t :=
  (mk_t (((a11 x) * (a11 y))%Z + ((a12 x) * (a21 y))%Z)%Z
  (((a11 x) * (a12 y))%Z + ((a12 x) * (a22 y))%Z)%Z
  (((a21 x) * (a11 y))%Z + ((a22 x) * (a21 y))%Z)%Z
  (((a21 x) * (a12 y))%Z + ((a22 x) * (a22 y))%Z)%Z).

Parameter power: t -> Z -> t.


Axiom Power_0 : forall (x:t), ((power x 0%Z) = (mk_t 1%Z 0%Z 0%Z 1%Z)).

Axiom Power_s : forall (x:t) (n:Z), (0%Z <= n)%Z -> ((power x
  (n + 1%Z)%Z) = (mult x (power x n))).

(* YOU MAY EDIT THE CONTEXT BELOW *)
Open Scope Z_scope.
(* DO NOT EDIT BELOW *)

Theorem power_sum : forall (x:t) (n:Z) (m:Z), (0%Z <= n)%Z ->
  ((0%Z <= m)%Z -> ((power x (n + m)%Z) = (mult (power x n) (power x m)))).
(* YOU MAY EDIT THE PROOF BELOW *)
intros x n m Hn.
apply Zlt_0_ind with 
  (P := fun m => power x (n + m) = mult (power x n) (power x m)).
intros m0 Hind Hm0.
assert (h:(0 = m0)\/(0 < m0)) by omega.
destruct h.
subst m0.
rewrite Power_0.
replace (n+0) with n by omega.
destruct (power x n).
unfold mult; simpl.
f_equal; omega.
replace m0 with ((m0-1)+1) by omega.
replace (n + (m0 - 1 + 1)) with (n + m0 - 1 + 1) by omega.
rewrite Power_s; auto with zarith.
rewrite Power_s; auto with zarith.

Qed.
(* DO NOT EDIT BELOW *)


