(* This file is generated by Why3's Coq 8.4 driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require int.Int.
Require int.MinMax.
Require list.List.
Require list.Length.
Require list.Mem.
Require map.Map.
Require list.Append.

(* Why3 assumption *)
Definition unit := unit.

Axiom char : Type.
Parameter char_WhyType : WhyType char.
Existing Instance char_WhyType.

(* Why3 assumption *)
Definition word := (list char).

(* Why3 assumption *)
Inductive dist : (list char) -> (list char) -> Z -> Prop :=
  | dist_eps : (dist nil nil 0%Z)
  | dist_add_left : forall (w1:(list char)) (w2:(list char)) (n:Z), (dist w1
      w2 n) -> forall (a:char), (dist (cons a w1) w2 (n + 1%Z)%Z)
  | dist_add_right : forall (w1:(list char)) (w2:(list char)) (n:Z), (dist w1
      w2 n) -> forall (a:char), (dist w1 (cons a w2) (n + 1%Z)%Z)
  | dist_context : forall (w1:(list char)) (w2:(list char)) (n:Z), (dist w1
      w2 n) -> forall (a:char), (dist (cons a w1) (cons a w2) n).

(* Why3 assumption *)
Definition min_dist (w1:(list char)) (w2:(list char)) (n:Z): Prop := (dist w1
  w2 n) /\ forall (m:Z), (dist w1 w2 m) -> (n <= m)%Z.

(* Why3 assumption *)
Fixpoint last_char (a:char) (u:(list char)) {struct u}: char :=
  match u with
  | nil => a
  | (cons c u') => (last_char c u')
  end.

(* Why3 assumption *)
Fixpoint but_last (a:char) (u:(list char)) {struct u}: (list char) :=
  match u with
  | nil => nil
  | (cons c u') => (cons a (but_last c u'))
  end.

Axiom first_last_explicit : forall (u:(list char)) (a:char),
  ((List.app (but_last a u) (cons (last_char a u) nil)) = (cons a u)).

Axiom first_last : forall (a:char) (u:(list char)), exists v:(list char),
  exists b:char, ((List.app v (cons b nil)) = (cons a u)) /\
  ((list.Length.length v) = (list.Length.length u)).

Axiom key_lemma_right : forall (w1:(list char)) (w'2:(list char)) (m:Z)
  (a:char), (dist w1 w'2 m) -> forall (w2:(list char)),
  (w'2 = (cons a w2)) -> exists u1:(list char), exists v1:(list char),
  exists k:Z, (w1 = (List.app u1 v1)) /\ ((dist v1 w2 k) /\
  ((k + (list.Length.length u1))%Z <= (m + 1%Z)%Z)%Z).

Axiom dist_symetry : forall (w1:(list char)) (w2:(list char)) (n:Z), (dist w1
  w2 n) -> (dist w2 w1 n).

Axiom key_lemma_left : forall (w1:(list char)) (w2:(list char)) (m:Z)
  (a:char), (dist (cons a w1) w2 m) -> exists u2:(list char),
  exists v2:(list char), exists k:Z, (w2 = (List.app u2 v2)) /\ ((dist w1 v2
  k) /\ ((k + (list.Length.length u2))%Z <= (m + 1%Z)%Z)%Z).

Axiom dist_concat_left : forall (u:(list char)) (v:(list char))
  (w:(list char)) (n:Z), (dist v w n) -> (dist (List.app u v) w
  ((list.Length.length u) + n)%Z).

Axiom dist_concat_right : forall (u:(list char)) (v:(list char))
  (w:(list char)) (n:Z), (dist v w n) -> (dist v (List.app u w)
  ((list.Length.length u) + n)%Z).

Axiom min_dist_equal : forall (w1:(list char)) (w2:(list char)) (a:char)
  (n:Z), (min_dist w1 w2 n) -> (min_dist (cons a w1) (cons a w2) n).

Axiom min_dist_diff : forall (w1:(list char)) (w2:(list char)) (a:char)
  (b:char) (m:Z) (p:Z), (~ (a = b)) -> ((min_dist (cons a w1) w2 p) ->
  ((min_dist w1 (cons b w2) m) -> (min_dist (cons a w1) (cons b w2)
  ((Zmin m p) + 1%Z)%Z))).

Axiom min_dist_eps : forall (w:(list char)) (a:char) (n:Z), (min_dist w nil
  n) -> (min_dist (cons a w) nil (n + 1%Z)%Z).

Axiom min_dist_eps_length : forall (w:(list char)), (min_dist nil w
  (list.Length.length w)).

(* Why3 assumption *)
Inductive ref (a:Type) {a_WT:WhyType a} :=
  | mk_ref : a -> ref a.
Axiom ref_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (ref a).
Existing Instance ref_WhyType.
Implicit Arguments mk_ref [[a] [a_WT]].

(* Why3 assumption *)
Definition contents {a:Type} {a_WT:WhyType a} (v:(@ref a a_WT)): a :=
  match v with
  | (mk_ref x) => x
  end.

(* Why3 assumption *)
Inductive array
  (a:Type) {a_WT:WhyType a} :=
  | mk_array : Z -> (@map.Map.map Z _ a a_WT) -> array a.
Axiom array_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (array a).
Existing Instance array_WhyType.
Implicit Arguments mk_array [[a] [a_WT]].

(* Why3 assumption *)
Definition elts {a:Type} {a_WT:WhyType a} (v:(@array a a_WT)): (@map.Map.map
  Z _ a a_WT) := match v with
  | (mk_array x x1) => x1
  end.

(* Why3 assumption *)
Definition length {a:Type} {a_WT:WhyType a} (v:(@array a a_WT)): Z :=
  match v with
  | (mk_array x x1) => x
  end.

(* Why3 assumption *)
Definition get {a:Type} {a_WT:WhyType a} (a1:(@array a a_WT)) (i:Z): a :=
  (map.Map.get (elts a1) i).

(* Why3 assumption *)
Definition set {a:Type} {a_WT:WhyType a} (a1:(@array a a_WT)) (i:Z)
  (v:a): (@array a a_WT) := (mk_array (length a1) (map.Map.set (elts a1) i
  v)).

(* Why3 assumption *)
Definition make {a:Type} {a_WT:WhyType a} (n:Z) (v:a): (@array a a_WT) :=
  (mk_array n (map.Map.const v:(@map.Map.map Z _ a a_WT))).

Parameter suffix: (@array char char_WhyType) -> Z -> (list char).

Axiom suffix_nil : forall (a:(@array char char_WhyType)), ((suffix a
  (length a)) = nil).

Axiom suffix_cons : forall (a:(@array char char_WhyType)) (i:Z),
  ((0%Z <= i)%Z /\ (i < (length a))%Z) -> ((suffix a i) = (cons (get a
  i) (suffix a (i + 1%Z)%Z))).

Axiom suffix_length : forall (a:(@array char char_WhyType)) (i:Z),
  ((0%Z <= i)%Z /\ (i <= (length a))%Z) -> ((list.Length.length (suffix a
  i)) = ((length a) - i)%Z).

(* Why3 assumption *)
Definition min_suffix (a1:(@array char char_WhyType)) (a2:(@array
  char char_WhyType)) (i:Z) (j:Z) (n:Z): Prop := (min_dist (suffix a1 i)
  (suffix a2 j) n).

(* Why3 goal *)
Theorem WP_parameter_distance : forall (w1:Z) (w11:(@map.Map.map Z _
  char char_WhyType)) (w2:Z) (w21:(@map.Map.map Z _ char char_WhyType)),
  let w22 := (mk_array w2 w21) in let w12 := (mk_array w1 w11) in
  (((0%Z <= w1)%Z /\ (0%Z <= w2)%Z) -> let o := (w2 + 1%Z)%Z in
  ((0%Z <= o)%Z -> ((0%Z <= o)%Z -> ((0%Z <= w2)%Z -> forall (t:(@map.Map.map
  Z _ Z _)), (forall (j:Z), ((0%Z <= j)%Z /\ (j < (w2 + 1%Z)%Z)%Z) ->
  ((map.Map.get t j) = (w2 - j)%Z)) -> let o1 := (w1 - 1%Z)%Z in
  ((0%Z <= o1)%Z -> forall (t1:(@map.Map.map Z _ Z _)), forall (i:Z),
  ((i <= o1)%Z /\ (0%Z <= i)%Z) -> ((forall (j:Z), ((0%Z <= j)%Z /\
  (j <= w2)%Z) -> (min_dist (suffix w12 (i + 1%Z)%Z) (suffix w22 j)
  (map.Map.get t1 j))) -> (((0%Z <= o)%Z /\ ((0%Z <= w2)%Z /\ (w2 < o)%Z)) ->
  (((0%Z <= w2)%Z /\ (w2 < o)%Z) -> (((0%Z <= w2)%Z /\ (w2 < o)%Z) ->
  forall (t2:(@map.Map.map Z _ Z _)), ((0%Z <= o)%Z /\ (t2 = (map.Map.set t1
  w2 ((map.Map.get t1 w2) + 1%Z)%Z))) -> let o2 := (w2 - 1%Z)%Z in
  ((0%Z <= o2)%Z -> forall (oldt:Z) (t3:(@map.Map.map Z _ Z _)),
  forall (j:Z), ((j <= o2)%Z /\ (0%Z <= j)%Z) -> (((forall (k:Z),
  ((j < k)%Z /\ (k <= w2)%Z) -> (min_dist (suffix w12 i) (suffix w22 k)
  (map.Map.get t3 k))) /\ ((forall (k:Z), ((0%Z <= k)%Z /\ (k <= j)%Z) ->
  (min_dist (suffix w12 (i + 1%Z)%Z) (suffix w22 k) (map.Map.get t3 k))) /\
  (min_dist (suffix w12 (i + 1%Z)%Z) (suffix w22 (j + 1%Z)%Z) oldt))) ->
  (((0%Z <= o)%Z /\ ((0%Z <= j)%Z /\ (j < o)%Z)) -> forall (oldt1:Z),
  (oldt1 = (map.Map.get t3 j)) -> (((0%Z <= j)%Z /\ (j < w2)%Z) ->
  (((0%Z <= i)%Z /\ (i < w1)%Z) -> ((~ ((map.Map.get w11
  i) = (map.Map.get w21 j))) -> let o3 := (j + 1%Z)%Z in (((0%Z <= o3)%Z /\
  (o3 < o)%Z) -> (((0%Z <= j)%Z /\ (j < o)%Z) -> (((0%Z <= j)%Z /\
  (j < o)%Z) -> forall (t4:(@map.Map.map Z _ Z _)), ((0%Z <= o)%Z /\
  (t4 = (map.Map.set t3 j ((Zmin (map.Map.get t3 j) (map.Map.get t3
  o3)) + 1%Z)%Z))) -> forall (k:Z), (((j - 1%Z)%Z < k)%Z /\ (k <= w2)%Z) ->
  (min_dist (suffix w12 i) (suffix w22 k) (map.Map.get t4
  k)))))))))))))))))))).
intros w1 w11 w2 w21 w22 w12 (h1,h2) o h3 h4 h5 t h6 o1 h7 t1 i
        (h8,h9) h10 (h11,(h12,h13)) (h14,h15) (h16,h17) t2 (h18,h19) o2 h20
        oldt t3 j (h21,h22) (h23,(h24,h25)) (h26,(h27,h28)) oldt1 h29
        (h30,h31) (h32,h33) h34 o3 (h35,h36) (h37,h38) (h39,h40) t4 (h41,h42)
        k (h43,h44).
subst t4 w12 w22 o o1 o2 o3.
unfold min_suffix.
assert (k=j \/ j<k)%Z by omega. intuition.
  (* j=k *)
  subst j.
  rewrite (suffix_cons _ i).
  2: unfold length; simpl; omega.
  rewrite (suffix_cons _ k).
  2: unfold length; simpl; omega.
  rewrite Map.Select_eq; try omega.
  apply min_dist_diff.
  subst; auto.
  rewrite <- (suffix_cons _ i).
  2: unfold length; simpl; omega.
  subst.
  apply h23; omega.
  rewrite <- (suffix_cons _ k).
  subst.
  apply h24. omega.
  unfold length; simpl; omega.
  (* j<k *)
  subst.
  rewrite Map.Select_neq; try omega.
  apply h23. omega.
Qed.

