(* This file is generated by Why3's Coq 8.4 driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require int.Int.
Require map.Map.
Require map.MapPermut.

(* Why3 assumption *)
Definition unit := unit.

(* Why3 assumption *)
Inductive ref (a:Type) {a_WT:WhyType a} :=
  | mk_ref : a -> ref a.
Axiom ref_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (ref a).
Existing Instance ref_WhyType.
Implicit Arguments mk_ref [[a] [a_WT]].

(* Why3 assumption *)
Definition contents {a:Type} {a_WT:WhyType a} (v:(@ref a a_WT)): a :=
  match v with
  | (mk_ref x) => x
  end.

(* Why3 assumption *)
Inductive array
  (a:Type) {a_WT:WhyType a} :=
  | mk_array : Z -> (@map.Map.map Z _ a a_WT) -> array a.
Axiom array_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (array a).
Existing Instance array_WhyType.
Implicit Arguments mk_array [[a] [a_WT]].

(* Why3 assumption *)
Definition elts {a:Type} {a_WT:WhyType a} (v:(@array a a_WT)): (@map.Map.map
  Z _ a a_WT) := match v with
  | (mk_array x x1) => x1
  end.

(* Why3 assumption *)
Definition length {a:Type} {a_WT:WhyType a} (v:(@array a a_WT)): Z :=
  match v with
  | (mk_array x x1) => x
  end.

(* Why3 assumption *)
Definition get {a:Type} {a_WT:WhyType a} (a1:(@array a a_WT)) (i:Z): a :=
  (map.Map.get (elts a1) i).

(* Why3 assumption *)
Definition set {a:Type} {a_WT:WhyType a} (a1:(@array a a_WT)) (i:Z)
  (v:a): (@array a a_WT) := (mk_array (length a1) (map.Map.set (elts a1) i
  v)).

(* Why3 assumption *)
Definition make {a:Type} {a_WT:WhyType a} (n:Z) (v:a): (@array a a_WT) :=
  (mk_array n (map.Map.const v:(@map.Map.map Z _ a a_WT))).

(* Why3 assumption *)
Definition map_eq_sub {a:Type} {a_WT:WhyType a} (a1:(@map.Map.map Z _
  a a_WT)) (a2:(@map.Map.map Z _ a a_WT)) (l:Z) (u:Z): Prop := forall (i:Z),
  ((l <= i)%Z /\ (i < u)%Z) -> ((map.Map.get a1 i) = (map.Map.get a2 i)).

(* Why3 assumption *)
Definition array_eq_sub {a:Type} {a_WT:WhyType a} (a1:(@array a a_WT))
  (a2:(@array a a_WT)) (l:Z) (u:Z): Prop := ((length a1) = (length a2)) /\
  (((0%Z <= l)%Z /\ (l <= (length a1))%Z) /\ (((0%Z <= u)%Z /\
  (u <= (length a1))%Z) /\ (map_eq_sub (elts a1) (elts a2) l u))).

(* Why3 assumption *)
Definition array_eq {a:Type} {a_WT:WhyType a} (a1:(@array a a_WT))
  (a2:(@array a a_WT)): Prop := ((length a1) = (length a2)) /\ (map_eq_sub
  (elts a1) (elts a2) 0%Z (length a1)).

(* Why3 assumption *)
Definition exchange {a:Type} {a_WT:WhyType a} (a1:(@array a a_WT))
  (a2:(@array a a_WT)) (i:Z) (j:Z): Prop := ((length a1) = (length a2)) /\
  (((0%Z <= i)%Z /\ (i < (length a1))%Z) /\ (((0%Z <= j)%Z /\
  (j < (length a1))%Z) /\ (((get a1 i) = (get a2 j)) /\ (((get a1
  j) = (get a2 i)) /\ forall (k:Z), ((0%Z <= k)%Z /\ (k < (length a1))%Z) ->
  ((~ (k = i)) -> ((~ (k = j)) -> ((get a1 k) = (get a2 k)))))))).

(* Why3 assumption *)
Definition map_permut_sub {a:Type} {a_WT:WhyType a} (a1:(@array a a_WT))
  (a2:(@array a a_WT)) (l:Z) (u:Z): Prop := ((length a1) = (length a2)) /\
  (((0%Z <= l)%Z /\ (l <= (length a1))%Z) /\ (((0%Z <= u)%Z /\
  (u <= (length a1))%Z) /\ (map.MapPermut.permut_sub (elts a1) (elts a2) l
  u))).

(* Why3 assumption *)
Definition permut_sub {a:Type} {a_WT:WhyType a} (a1:(@array a a_WT))
  (a2:(@array a a_WT)) (l:Z) (u:Z): Prop := (array_eq_sub a1 a2 0%Z l) /\
  ((map_permut_sub a1 a2 l u) /\ (array_eq_sub a2 a2 u (length a1))).

(* Why3 assumption *)
Definition permut {a:Type} {a_WT:WhyType a} (a1:(@array a a_WT)) (a2:(@array
  a a_WT)): Prop := ((length a1) = (length a2)) /\ (map.MapPermut.permut_sub
  (elts a1) (elts a2) 0%Z (length a1)).

Axiom permut_refl : forall {a:Type} {a_WT:WhyType a}, forall (a1:(@array
  a a_WT)), (permut a1 a1).

Axiom exchange_permut : forall {a:Type} {a_WT:WhyType a}, forall (a1:(@array
  a a_WT)) (a2:(@array a a_WT)) (i:Z) (j:Z), (exchange a1 a2 i j) -> (permut
  a1 a2).

Axiom permut_sym : forall {a:Type} {a_WT:WhyType a}, forall (a1:(@array
  a a_WT)) (a2:(@array a a_WT)), (permut a1 a2) -> (permut a2 a1).

Axiom permut_trans : forall {a:Type} {a_WT:WhyType a}, forall (a1:(@array
  a a_WT)) (a2:(@array a a_WT)) (a3:(@array a a_WT)), (permut a1 a2) ->
  ((permut a2 a3) -> (permut a1 a3)).

Axiom array_eq_permut : forall {a:Type} {a_WT:WhyType a}, forall (a1:(@array
  a a_WT)) (a2:(@array a a_WT)), (array_eq a1 a2) -> (permut a1 a2).

Axiom permut_sub_weakening : forall {a:Type} {a_WT:WhyType a},
  forall (a1:(@array a a_WT)) (a2:(@array a a_WT)) (l1:Z) (u1:Z) (l2:Z)
  (u2:Z), (permut_sub a1 a2 l1 u1) -> (((0%Z <= l2)%Z /\ (l2 <= l1)%Z) ->
  (((u1 <= u2)%Z /\ (u2 <= (length a1))%Z) -> (permut_sub a1 a2 l2 u2))).

Axiom permut_sub_permut : forall {a:Type} {a_WT:WhyType a},
  forall (a1:(@array a a_WT)) (a2:(@array a a_WT)) (l:Z) (u:Z), (permut_sub
  a1 a2 l u) -> (permut a1 a2).

(* Why3 goal *)
Theorem WP_parameter_partition : forall (a:Z) (a1:(@map.Map.map Z _ Z _))
  (m:Z) (n:Z), ((0%Z <= a)%Z /\ ((0%Z <= m)%Z /\ ((m < n)%Z /\
  (n < a)%Z))) -> (((0%Z <= m)%Z /\ ((m < n)%Z /\ (n < a)%Z)) -> forall (o:Z)
  (j:Z) (i:Z) (a2:(@map.Map.map Z _ Z _)), ((0%Z <= a)%Z /\ (((m <= j)%Z /\
  ((j < i)%Z /\ (i <= n)%Z)) /\ ((permut_sub (mk_array a a1) (mk_array a a2)
  m (n + 1%Z)%Z) /\ ((forall (r:Z), ((m <= r)%Z /\ (r <= j)%Z) ->
  ((map.Map.get a2 r) <= o)%Z) /\ ((forall (r:Z), ((j < r)%Z /\ (r < i)%Z) ->
  ((map.Map.get a2 r) = o)) /\ forall (r:Z), ((i <= r)%Z /\ (r <= n)%Z) ->
  (o <= (map.Map.get a2 r))%Z))))) -> exists x:Z, (forall (r:Z),
  ((m <= r)%Z /\ (r <= j)%Z) -> ((map.Map.get a2 r) <= x)%Z) /\
  ((forall (r:Z), ((j < r)%Z /\ (r < i)%Z) -> ((map.Map.get a2 r) = x)) /\
  forall (r:Z), ((i <= r)%Z /\ (r <= n)%Z) -> (x <= (map.Map.get a2 r))%Z)).
intros a a1 m n (h1,(h2,(h3,h4))) (h5,(h6,h7)) o j i a2
(h8,((h9,(h10,h11)),(h12,(h13,(h14,h15))))).
exists o; auto.
Qed.

