(* This file is generated by Why3's Coq-realize driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require Import ZOdiv.
Require BuiltIn.
Require int.Int.
Require int.Abs.

(* Why3 comment *)
(* div is replaced with (ZOdiv x x1) by the coq driver *)

(* Why3 comment *)
(* mod1 is replaced with (ZOmod x x1) by the coq driver *)

(* Why3 goal *)
Lemma Div_mod : forall (x:Z) (y:Z), (~ (y = 0%Z)) ->
  (x = ((y * (ZOdiv x y))%Z + (ZOmod x y))%Z).
intros x y _.
apply ZO_div_mod_eq.
Qed.

(* Why3 goal *)
Lemma Div_bound : forall (x:Z) (y:Z), ((0%Z <= x)%Z /\ (0%Z < y)%Z) ->
  ((0%Z <= (ZOdiv x y))%Z /\ ((ZOdiv x y) <= x)%Z).
intros x y (Hx,Hy).
split.
apply ZO_div_pos with (1 := Hx).
now apply Zlt_le_weak.
destruct (Z_eq_dec y 1) as [H|H].
rewrite H, ZOdiv_1_r.
apply Zle_refl.
destruct (Zle_lt_or_eq 0 x Hx) as [H'|H'].
apply Zlt_le_weak.
apply ZO_div_lt with (1 := H').
omega.
now rewrite <- H', ZOdiv_0_l.
Qed.

(* Why3 goal *)
Lemma Mod_bound : forall (x:Z) (y:Z), (~ (y = 0%Z)) ->
  (((-(Zabs y))%Z < (ZOmod x y))%Z /\ ((ZOmod x y) < (Zabs y))%Z).
intros x y Zy.
destruct (Zle_or_lt 0 x) as [Hx|Hx].
refine ((fun H => conj (Zlt_le_trans _ 0 _ _ (proj1 H)) (proj2 H)) _).
clear -Zy ; zify ; omega.
now apply ZOmod_lt_pos.
refine ((fun H => conj (proj1 H) (Zle_lt_trans _ 0 _ (proj2 H) _)) _).
clear -Zy ; zify ; omega.
apply ZOmod_lt_neg with (2 := Zy).
now apply Zlt_le_weak.
Qed.

(* Why3 goal *)
Lemma Div_sign_pos : forall (x:Z) (y:Z), ((0%Z <= x)%Z /\ (0%Z < y)%Z) ->
  (0%Z <= (ZOdiv x y))%Z.
intros x y (Hx, Hy).
apply ZO_div_pos with (1 := Hx).
now apply Zlt_le_weak.
Qed.

(* Why3 goal *)
Lemma Div_sign_neg : forall (x:Z) (y:Z), ((x <= 0%Z)%Z /\ (0%Z < y)%Z) ->
  ((ZOdiv x y) <= 0%Z)%Z.
intros x y (Hx, Hy).
generalize (ZO_div_pos (-x) y).
rewrite ZOdiv_opp_l.
omega.
Qed.

(* Why3 goal *)
Lemma Mod_sign_pos : forall (x:Z) (y:Z), ((0%Z <= x)%Z /\ ~ (y = 0%Z)) ->
  (0%Z <= (ZOmod x y))%Z.
intros x y (Hx, Zy).
now apply ZOmod_lt_pos.
Qed.

(* Why3 goal *)
Lemma Mod_sign_neg : forall (x:Z) (y:Z), ((x <= 0%Z)%Z /\ ~ (y = 0%Z)) ->
  ((ZOmod x y) <= 0%Z)%Z.
intros x y (Hx, Zy).
now apply ZOmod_lt_neg.
Qed.

(* Why3 goal *)
Lemma Rounds_toward_zero : forall (x:Z) (y:Z), (~ (y = 0%Z)) ->
  ((Zabs ((ZOdiv x y) * y)%Z) <= (Zabs x))%Z.
intros x y Zy.
rewrite Zmult_comm.
zify.
generalize (ZO_mult_div_le x y).
generalize (ZO_mult_div_ge x y).
omega.
Qed.

(* Why3 goal *)
Lemma Div_1 : forall (x:Z), ((ZOdiv x 1%Z) = x).
exact ZOdiv_1_r.
Qed.

(* Why3 goal *)
Lemma Mod_1 : forall (x:Z), ((ZOmod x 1%Z) = 0%Z).
exact ZOmod_1_r.
Qed.

(* Why3 goal *)
Lemma Div_inf : forall (x:Z) (y:Z), ((0%Z <= x)%Z /\ (x < y)%Z) ->
  ((ZOdiv x y) = 0%Z).
exact ZOdiv_small.
Qed.

(* Why3 goal *)
Lemma Mod_inf : forall (x:Z) (y:Z), ((0%Z <= x)%Z /\ (x < y)%Z) ->
  ((ZOmod x y) = x).
exact ZOmod_small.
Qed.

(* Why3 goal *)
Lemma Div_mult : forall (x:Z) (y:Z) (z:Z), ((0%Z < x)%Z /\ ((0%Z <= y)%Z /\
  (0%Z <= z)%Z)) -> ((ZOdiv ((x * y)%Z + z)%Z x) = (y + (ZOdiv z x))%Z).
intros x y z (Hx&Hy&Hz).
rewrite (Zplus_comm y).
rewrite <- ZO_div_plus.
now rewrite Zplus_comm, Zmult_comm.
apply Zmult_le_0_compat with (2 := Hz).
apply Zplus_le_0_compat with (1 := Hz).
apply Zmult_le_0_compat with (1 := Hy).
now apply Zlt_le_weak.
intros H.
now rewrite H in Hx.
Qed.

(* Why3 goal *)
Lemma Mod_mult : forall (x:Z) (y:Z) (z:Z), ((0%Z < x)%Z /\ ((0%Z <= y)%Z /\
  (0%Z <= z)%Z)) -> ((ZOmod ((x * y)%Z + z)%Z x) = (ZOmod z x)).
intros x y z (Hx&Hy&Hz).
rewrite Zplus_comm, Zmult_comm.
apply ZO_mod_plus.
apply Zmult_le_0_compat with (2 := Hz).
apply Zplus_le_0_compat with (1 := Hz).
apply Zmult_le_0_compat with (1 := Hy).
now apply Zlt_le_weak.
Qed.


