(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import ZArith.
Require Import Rbase.
Definition unit  := unit.

Parameter qtmark : Type.

Parameter at1: forall (a:Type), a -> qtmark -> a.

Implicit Arguments at1.

Parameter old: forall (a:Type), a -> a.

Implicit Arguments old.

Definition implb(x:bool) (y:bool): bool := match (x,
  y) with
  | (true, false) => false
  | (_, _) => true
  end.

Inductive list (a:Type) :=
  | Nil : list a
  | Cons : a -> (list a) -> list a.
Set Contextual Implicit.
Implicit Arguments Nil.
Unset Contextual Implicit.
Implicit Arguments Cons.

Set Implicit Arguments.
Fixpoint length (a:Type)(l:(list a)) {struct l}: Z :=
  match l with
  | Nil => 0%Z
  | (Cons _ r) => (1%Z + (length r))%Z
  end.
Unset Implicit Arguments.

Axiom Length_nonnegative : forall (a:Type), forall (l:(list a)),
  (0%Z <= (length l))%Z.

Axiom Length_nil : forall (a:Type), forall (l:(list a)),
  ((length l) = 0%Z) <-> (l = (Nil:(list a))).

Set Implicit Arguments.
Fixpoint infix_plpl (a:Type)(l1:(list a)) (l2:(list a)) {struct l1}: (list
  a) :=
  match l1 with
  | Nil => l2
  | (Cons x1 r1) => (Cons x1 (infix_plpl r1 l2))
  end.
Unset Implicit Arguments.

Axiom Append_assoc : forall (a:Type), forall (l1:(list a)) (l2:(list a))
  (l3:(list a)), ((infix_plpl l1 (infix_plpl l2
  l3)) = (infix_plpl (infix_plpl l1 l2) l3)).

Axiom Append_l_nil : forall (a:Type), forall (l:(list a)), ((infix_plpl l
  (Nil:(list a))) = l).

Axiom Append_length : forall (a:Type), forall (l1:(list a)) (l2:(list a)),
  ((length (infix_plpl l1 l2)) = ((length l1) + (length l2))%Z).

Set Implicit Arguments.
Fixpoint mem (a:Type)(x:a) (l:(list a)) {struct l}: Prop :=
  match l with
  | Nil => False
  | (Cons y r) => (x = y) \/ (mem x r)
  end.
Unset Implicit Arguments.

Axiom mem_append : forall (a:Type), forall (x:a) (l1:(list a)) (l2:(list a)),
  (mem x (infix_plpl l1 l2)) <-> ((mem x l1) \/ (mem x l2)).

Axiom mem_decomp : forall (a:Type), forall (x:a) (l:(list a)), (mem x l) ->
  exists l1:(list a), exists l2:(list a), (l = (infix_plpl l1 (Cons x l2))).

Inductive tree  :=
  | Leaf : tree 
  | Node : tree -> tree -> tree .

Set Implicit Arguments.
Fixpoint depths(d:Z) (t:tree) {struct t}: (list Z) :=
  match t with
  | Leaf => (Cons d (Nil:(list Z)))
  | (Node l r) => (infix_plpl (depths (d + 1%Z)%Z l) (depths (d + 1%Z)%Z r))
  end.
Unset Implicit Arguments.

Axiom depths_head : forall (t:tree) (d:Z), match (depths d
  t) with
  | (Cons x _) => (d <= x)%Z
  | Nil => False
  end.

Axiom depths_unique : forall (t1:tree) (t2:tree) (d:Z) (s1:(list Z))
  (s2:(list Z)), ((infix_plpl (depths d t1) s1) = (infix_plpl (depths d t2)
  s2)) -> ((t1 = t2) /\ (s1 = s2)).

Definition lex(x1:((list Z)* Z)%type) (x2:((list Z)* Z)%type): Prop :=
  match x1 with
  | (s1, d1) =>
      match x2 with
      | (s2, d2) => ((length s1) <  (length s2))%Z \/
          (((length s1) = (length s2)) /\ match (s1,
          s2) with
          | ((Cons h1 _), (Cons h2 _)) => ((d2 <  d1)%Z /\ (d1 <= h1)%Z) /\
              (h1 = h2)
          | _ => False
          end)
      end
  end.

(* YOU MAY EDIT THE CONTEXT BELOW *)
Lemma depths_length: 
  forall t d, (length (depths d t) >= 1)%Z.
Proof.
  induction t; simpl; intuition.
  rewrite Append_length.
  generalize (IHt1 (d+1))%Z.
  generalize (IHt2 (d+1))%Z.
  omega.
Qed.

(* DO NOT EDIT BELOW *)

Theorem WP_parameter_harness2 : forall (result:tree), ~ ((depths 0%Z
  result) = (Cons 1%Z (Cons 3%Z (Cons 2%Z (Cons 2%Z (Nil:(list Z))))))).
(* YOU MAY EDIT THE PROOF BELOW *)
intuition.
destruct result; simpl in H.
discriminate H.
destruct result1; simpl in H.
injection H. intro H1.
destruct result2; simpl in H1.
discriminate H1.
destruct result2_1; simpl in H1.
discriminate H1.
destruct result2_1_1; simpl in H1.
injection H1. intro H2.
destruct result2_1_2; simpl in H2.
discriminate H2.
clear H H1.
generalize (depths_length result2_1_2_1 4).
generalize (depths_length result2_1_2_2 4).
generalize (depths_length result2_2 2).
generalize (@f_equal _ _ (@length Z) _ _ H2).
simpl.
do 2 (rewrite Append_length).
omega.
(* 4 trees, 3 ints *)
clear H.
generalize (depths_length result2_1_1_1 4).
generalize (depths_length result2_1_1_2 4).
generalize (depths_length result2_1_2 3).
generalize (depths_length result2_2 2).
generalize (@f_equal _ _ (@length Z) _ _ H1).
simpl.
do 3 (rewrite Append_length).
omega.

destruct result1_1; simpl in H.
discriminate H.
destruct result1_1_1; simpl in H.
discriminate H.
(* 5 trees, 4 ints *)
generalize (depths_length result1_1_1_1 4).
generalize (depths_length result1_1_1_2 4).
generalize (depths_length result1_1_2 3).
generalize (depths_length result1_2 2).
generalize (depths_length result2 1).
generalize (@f_equal _ _ (@length Z) _ _ H).
simpl.
do 4 (rewrite Append_length).
omega.

Qed.
(* DO NOT EDIT BELOW *)


