(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require int.Int.
Require map.Map.

(* Why3 assumption *)
Definition unit  := unit.

(* Why3 assumption *)
Inductive list (a:Type) {a_WT:WhyType a} :=
  | Nil : list a
  | Cons : a -> (list a) -> list a.
Axiom list_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (list a).
Existing Instance list_WhyType.
Implicit Arguments Nil [[a] [a_WT]].
Implicit Arguments Cons [[a] [a_WT]].

(* Why3 assumption *)
Inductive option (a:Type) {a_WT:WhyType a} :=
  | None : option a
  | Some : a -> option a.
Axiom option_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (option a).
Existing Instance option_WhyType.
Implicit Arguments None [[a] [a_WT]].
Implicit Arguments Some [[a] [a_WT]].

Parameter nth: forall {a:Type} {a_WT:WhyType a}, Z -> (list a) -> (option a).

Axiom nth_def : forall {a:Type} {a_WT:WhyType a}, forall (n:Z) (l:(list a)),
  match l with
  | Nil => ((nth n l) = (None :(option a)))
  | (Cons x r) => ((n = 0%Z) -> ((nth n l) = (Some x))) /\ ((~ (n = 0%Z)) ->
      ((nth n l) = (nth (n - 1%Z)%Z r)))
  end.

(* Why3 assumption *)
Fixpoint length {a:Type} {a_WT:WhyType a}(l:(list a)) {struct l}: Z :=
  match l with
  | Nil => 0%Z
  | (Cons _ r) => (1%Z + (length r))%Z
  end.

Axiom Length_nonnegative : forall {a:Type} {a_WT:WhyType a}, forall (l:(list
  a)), (0%Z <= (length l))%Z.

Axiom Length_nil : forall {a:Type} {a_WT:WhyType a}, forall (l:(list a)),
  ((length l) = 0%Z) <-> (l = (Nil :(list a))).

Axiom nth_none_1 : forall {a:Type} {a_WT:WhyType a}, forall (l:(list a))
  (i:Z), (i < 0%Z)%Z -> ((nth i l) = (None :(option a))).

Axiom nth_none_2 : forall {a:Type} {a_WT:WhyType a}, forall (l:(list a))
  (i:Z), ((length l) <= i)%Z -> ((nth i l) = (None :(option a))).

Axiom nth_none_3 : forall {a:Type} {a_WT:WhyType a}, forall (l:(list a))
  (i:Z), ((nth i l) = (None :(option a))) -> ((i < 0%Z)%Z \/
  ((length l) <= i)%Z).

(* Why3 assumption *)
Fixpoint infix_plpl {a:Type} {a_WT:WhyType a}(l1:(list a)) (l2:(list
  a)) {struct l1}: (list a) :=
  match l1 with
  | Nil => l2
  | (Cons x1 r1) => (Cons x1 (infix_plpl r1 l2))
  end.

Axiom Append_assoc : forall {a:Type} {a_WT:WhyType a}, forall (l1:(list a))
  (l2:(list a)) (l3:(list a)), ((infix_plpl l1 (infix_plpl l2
  l3)) = (infix_plpl (infix_plpl l1 l2) l3)).

Axiom Append_l_nil : forall {a:Type} {a_WT:WhyType a}, forall (l:(list a)),
  ((infix_plpl l (Nil :(list a))) = l).

Axiom Append_length : forall {a:Type} {a_WT:WhyType a}, forall (l1:(list a))
  (l2:(list a)), ((length (infix_plpl l1
  l2)) = ((length l1) + (length l2))%Z).

(* Why3 assumption *)
Fixpoint mem {a:Type} {a_WT:WhyType a}(x:a) (l:(list a)) {struct l}: Prop :=
  match l with
  | Nil => False
  | (Cons y r) => (x = y) \/ (mem x r)
  end.

Axiom mem_append : forall {a:Type} {a_WT:WhyType a}, forall (x:a) (l1:(list
  a)) (l2:(list a)), (mem x (infix_plpl l1 l2)) <-> ((mem x l1) \/ (mem x
  l2)).

Axiom mem_decomp : forall {a:Type} {a_WT:WhyType a}, forall (x:a) (l:(list
  a)), (mem x l) -> exists l1:(list a), exists l2:(list a),
  (l = (infix_plpl l1 (Cons x l2))).

Axiom nth_append_1 : forall {a:Type} {a_WT:WhyType a}, forall (l1:(list a))
  (l2:(list a)) (i:Z), (i < (length l1))%Z -> ((nth i (infix_plpl l1
  l2)) = (nth i l1)).

Axiom nth_append_2 : forall {a:Type} {a_WT:WhyType a}, forall (l1:(list a))
  (l2:(list a)) (i:Z), ((length l1) <= i)%Z -> ((nth i (infix_plpl l1
  l2)) = (nth (i - (length l1))%Z l2)).

(* Why3 assumption *)
Inductive array (a:Type) {a_WT:WhyType a} :=
  | mk_array : Z -> (map.Map.map Z a) -> array a.
Axiom array_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (array a).
Existing Instance array_WhyType.
Implicit Arguments mk_array [[a] [a_WT]].

(* Why3 assumption *)
Definition elts {a:Type} {a_WT:WhyType a}(v:(array a)): (map.Map.map Z a) :=
  match v with
  | (mk_array x x1) => x1
  end.

(* Why3 assumption *)
Definition length1 {a:Type} {a_WT:WhyType a}(v:(array a)): Z :=
  match v with
  | (mk_array x x1) => x
  end.

(* Why3 assumption *)
Definition get {a:Type} {a_WT:WhyType a}(a1:(array a)) (i:Z): a :=
  (map.Map.get (elts a1) i).

(* Why3 assumption *)
Definition set {a:Type} {a_WT:WhyType a}(a1:(array a)) (i:Z) (v:a): (array
  a) := (mk_array (length1 a1) (map.Map.set (elts a1) i v)).

(* Why3 assumption *)
Definition make {a:Type} {a_WT:WhyType a}(n:Z) (v:a): (array a) :=
  (mk_array n (map.Map.const v:(map.Map.map Z a))).

(* Why3 assumption *)
Inductive buffer (a:Type) {a_WT:WhyType a} :=
  | mk_buffer : Z -> Z -> (array a) -> (list a) -> buffer a.
Axiom buffer_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (buffer a).
Existing Instance buffer_WhyType.
Implicit Arguments mk_buffer [[a] [a_WT]].

(* Why3 assumption *)
Definition sequence {a:Type} {a_WT:WhyType a}(v:(buffer a)): (list a) :=
  match v with
  | (mk_buffer x x1 x2 x3) => x3
  end.

(* Why3 assumption *)
Definition data {a:Type} {a_WT:WhyType a}(v:(buffer a)): (array a) :=
  match v with
  | (mk_buffer x x1 x2 x3) => x2
  end.

(* Why3 assumption *)
Definition len {a:Type} {a_WT:WhyType a}(v:(buffer a)): Z :=
  match v with
  | (mk_buffer x x1 x2 x3) => x1
  end.

(* Why3 assumption *)
Definition first {a:Type} {a_WT:WhyType a}(v:(buffer a)): Z :=
  match v with
  | (mk_buffer x x1 x2 x3) => x
  end.

(* Why3 assumption *)
Definition size {a:Type} {a_WT:WhyType a}(b:(buffer a)): Z :=
  (length1 (data b)).

Require Import Why3.
Ltac ae := why3 "alt-ergo" timelimit 3.

(* Why3 goal *)
Theorem WP_parameter_head : forall {a:Type} {a_WT:WhyType a}, forall (b:Z),
  forall (rho:(list a)) (rho1:(map.Map.map Z a)) (rho2:Z) (rho3:Z),
  (((((0%Z <= rho3)%Z /\ (rho3 < b)%Z) /\ (((0%Z <= rho2)%Z /\
  (rho2 <= b)%Z) /\ ((rho2 = (length rho)) /\ forall (i:Z), ((0%Z <= i)%Z /\
  (i < rho2)%Z) -> ((((rho3 + i)%Z < b)%Z -> ((nth i
  rho) = (Some (map.Map.get rho1 (rho3 + i)%Z)))) /\
  ((0%Z <= ((rho3 + i)%Z - b)%Z)%Z -> ((nth i rho) = (Some (map.Map.get rho1
  ((rho3 + i)%Z - b)%Z)))))))) /\ (0%Z <= b)%Z) /\ (0%Z < rho2)%Z) ->
  (((0%Z <= rho3)%Z /\ (rho3 < b)%Z) ->
  match rho with
  | Nil => False
  | (Cons x _) => ((map.Map.get rho1 rho3) = x)
  end).
intros a _a b rho rho1 rho2 rho3.
intros (((h2a,(h2b,(h2c,h2d))),h2e),h1) _.
destruct rho.
simpl in *.
omega.
intuition.
generalize (h2d 0%Z). clear h2d.
ae.
Qed.


