(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require map.Map.
Require int.Int.

(* Why3 assumption *)
Definition unit := unit.

(* Why3 assumption *)
Inductive ref (a:Type) {a_WT:WhyType a} :=
  | mk_ref : a -> ref a.
Axiom ref_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (ref a).
Existing Instance ref_WhyType.
Implicit Arguments mk_ref [[a] [a_WT]].

(* Why3 assumption *)
Definition contents {a:Type} {a_WT:WhyType a} (v:(ref a)): a :=
  match v with
  | (mk_ref x) => x
  end.

Axiom loc : Type.
Parameter loc_WhyType : WhyType loc.
Existing Instance loc_WhyType.

Parameter null: loc.

(* Why3 assumption *)
Inductive node :=
  | mk_node : loc -> loc -> Z -> node.
Axiom node_WhyType : WhyType node.
Existing Instance node_WhyType.

(* Why3 assumption *)
Definition data (v:node): Z := match v with
  | (mk_node x x1 x2) => x2
  end.

(* Why3 assumption *)
Definition right1 (v:node): loc := match v with
  | (mk_node x x1 x2) => x1
  end.

(* Why3 assumption *)
Definition left1 (v:node): loc := match v with
  | (mk_node x x1 x2) => x
  end.

(* Why3 assumption *)
Definition memory := (map.Map.map loc node).

(* Why3 assumption *)
Inductive tree
  (a:Type) {a_WT:WhyType a} :=
  | Empty : tree a
  | Node : (tree a) -> a -> (tree a) -> tree a.
Axiom tree_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (tree a).
Existing Instance tree_WhyType.
Implicit Arguments Empty [[a] [a_WT]].
Implicit Arguments Node [[a] [a_WT]].

(* Why3 assumption *)
Inductive list
  (a:Type) {a_WT:WhyType a} :=
  | Nil : list a
  | Cons : a -> (list a) -> list a.
Axiom list_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (list a).
Existing Instance list_WhyType.
Implicit Arguments Nil [[a] [a_WT]].
Implicit Arguments Cons [[a] [a_WT]].

(* Why3 assumption *)
Fixpoint infix_plpl {a:Type} {a_WT:WhyType a} (l1:(list a)) (l2:(list
  a)) {struct l1}: (list a) :=
  match l1 with
  | Nil => l2
  | (Cons x1 r1) => (Cons x1 (infix_plpl r1 l2))
  end.

Axiom Append_assoc : forall {a:Type} {a_WT:WhyType a}, forall (l1:(list a))
  (l2:(list a)) (l3:(list a)), ((infix_plpl l1 (infix_plpl l2
  l3)) = (infix_plpl (infix_plpl l1 l2) l3)).

Axiom Append_l_nil : forall {a:Type} {a_WT:WhyType a}, forall (l:(list a)),
  ((infix_plpl l (Nil :(list a))) = l).

(* Why3 assumption *)
Fixpoint length {a:Type} {a_WT:WhyType a} (l:(list a)) {struct l}: Z :=
  match l with
  | Nil => 0%Z
  | (Cons _ r) => (1%Z + (length r))%Z
  end.

Axiom Length_nonnegative : forall {a:Type} {a_WT:WhyType a}, forall (l:(list
  a)), (0%Z <= (length l))%Z.

Axiom Length_nil : forall {a:Type} {a_WT:WhyType a}, forall (l:(list a)),
  ((length l) = 0%Z) <-> (l = (Nil :(list a))).

Axiom Append_length : forall {a:Type} {a_WT:WhyType a}, forall (l1:(list a))
  (l2:(list a)), ((length (infix_plpl l1
  l2)) = ((length l1) + (length l2))%Z).

(* Why3 assumption *)
Fixpoint mem {a:Type} {a_WT:WhyType a} (x:a) (l:(list a)) {struct l}: Prop :=
  match l with
  | Nil => False
  | (Cons y r) => (x = y) \/ (mem x r)
  end.

Axiom mem_append : forall {a:Type} {a_WT:WhyType a}, forall (x:a) (l1:(list
  a)) (l2:(list a)), (mem x (infix_plpl l1 l2)) <-> ((mem x l1) \/ (mem x
  l2)).

Axiom mem_decomp : forall {a:Type} {a_WT:WhyType a}, forall (x:a) (l:(list
  a)), (mem x l) -> exists l1:(list a), exists l2:(list a),
  (l = (infix_plpl l1 (Cons x l2))).

(* Why3 assumption *)
Fixpoint inorder {a:Type} {a_WT:WhyType a} (t:(tree a)) {struct t}: (list
  a) :=
  match t with
  | Empty => (Nil :(list a))
  | (Node l x r) => (infix_plpl (inorder l) (Cons x (inorder r)))
  end.

(* Why3 assumption *)
Inductive distinct{a:Type} {a_WT:WhyType a}  : (list a) -> Prop :=
  | distinct_zero : (distinct (Nil :(list a)))
  | distinct_one : forall (x:a), (distinct (Cons x (Nil :(list a))))
  | distinct_many : forall (x:a) (l:(list a)), (~ (mem x l)) -> ((distinct
      l) -> (distinct (Cons x l))).

Axiom distinct_append : forall {a:Type} {a_WT:WhyType a}, forall (l1:(list
  a)) (l2:(list a)), (distinct l1) -> ((distinct l2) -> ((forall (x:a), (mem
  x l1) -> ~ (mem x l2)) -> (distinct (infix_plpl l1 l2)))).

(* Why3 assumption *)
Inductive istree : (map.Map.map loc node) -> loc -> (tree loc) -> Prop :=
  | leaf : forall (m:(map.Map.map loc node)), (istree m null (Empty :(tree
      loc)))
  | node1 : forall (m:(map.Map.map loc node)) (p:loc) (l:(tree loc)) (r:(tree
      loc)), (~ (p = null)) -> ((istree m (left1 (map.Map.get m p)) l) ->
      ((istree m (right1 (map.Map.get m p)) r) -> (istree m p (Node l p r)))).

(* Why3 assumption *)
Inductive zipper
  (a:Type) {a_WT:WhyType a} :=
  | Top : zipper a
  | Left : (zipper a) -> a -> (tree a) -> zipper a.
Axiom zipper_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (zipper a).
Existing Instance zipper_WhyType.
Implicit Arguments Top [[a] [a_WT]].
Implicit Arguments Left [[a] [a_WT]].

(* Why3 assumption *)
Fixpoint zip {a:Type} {a_WT:WhyType a} (t:(tree a)) (z:(zipper
  a)) {struct z}: (tree a) :=
  match z with
  | Top => t
  | (Left z1 x r) => (zip (Node t x r) z1)
  end.

Axiom inorder_zip : forall {a:Type} {a_WT:WhyType a}, forall (z:(zipper a))
  (x:a) (l:(tree a)) (r:(tree a)), ((inorder (zip (Node l x r)
  z)) = (infix_plpl (inorder l) (Cons x (inorder (zip r z))))).

Axiom main_lemma : forall (m:(map.Map.map loc node)) (t:loc) (pp:loc) (p:loc)
  (ppr:(tree loc)) (pr:(tree loc)) (z:(zipper loc)), let it :=
  (zip (Node (Node (Empty :(tree loc)) p pr) pp ppr) z) in ((istree m t
  it) -> ((distinct (inorder it)) -> (istree (map.Map.set m pp
  (mk_node (right1 (map.Map.get m p)) (right1 (map.Map.get m pp))
  (data (map.Map.get m pp)))) t (zip (Node pr pp ppr) z)))).

Require Import Why3. Ltac ae := why3 "alt-ergo" timelimit 3.

(* Why3 goal *)
Theorem WP_parameter_search_tree_delete_min : forall (t:loc) (it:(tree loc)),
  forall (mem1:(map.Map.map loc node)), (((~ (t = null)) /\ (istree mem1 t
  it)) /\ (distinct (inorder it))) -> ((~ (t = null)) ->
  ((~ ((left1 (map.Map.get mem1 t)) = null)) -> ((~ ((left1 (map.Map.get mem1
  t)) = null)) -> ((~ (it = (Empty :(tree loc)))) -> forall (o:(tree loc)),
  match it with
  | Empty => False
  | (Node _ _ r) => (o = r)
  end -> ((~ (it = (Empty :(tree loc)))) -> forall (o1:(tree loc)),
  match it with
  | Empty => False
  | (Node l _ _) => (o1 = l)
  end -> forall (subtree:(tree loc)) (ppr:(tree loc)) (zipper1:(zipper loc))
  (tt:loc) (pp:loc) (p:loc), ((((~ (pp = null)) /\ ((left1 (map.Map.get mem1
  pp)) = p)) /\ ((~ (p = null)) /\ ((left1 (map.Map.get mem1 p)) = tt))) /\
  let pt := (Node subtree pp ppr) in ((istree mem1 pp pt) /\ ((zip pt
  zipper1) = it))) -> ((tt = null) -> ((istree mem1 p subtree) ->
  ((~ (pp = p)) -> ((~ (p = null)) -> ((~ (p = null)) -> forall (tt1:loc),
  (tt1 = (right1 (map.Map.get mem1 p))) -> let q_ := (map.Map.get mem1 pp) in
  forall (mem2:(map.Map.map loc node)), (mem2 = (map.Map.set mem1 pp
  (mk_node tt1 (right1 q_) (data q_)))) -> ((~ (subtree = (Empty :(tree
  loc)))) -> forall (pl:(tree loc)),
  match subtree with
  | Empty => False
  | (Node l _ _) => (pl = l)
  end -> ((pl = (Empty :(tree loc))) -> ((~ (subtree = (Empty :(tree
  loc)))) -> forall (o2:(tree loc)),
  match subtree with
  | Empty => False
  | (Node _ _ r) => (o2 = r)
  end -> forall (ot:(tree loc)), (ot = (zip o2 (Left zipper1 pp ppr))) ->
  match (inorder it) with
  | Nil => True
  | (Cons p1 l) => ((inorder ot) = l)
  end))))))))))))).
intros t it mem1 ((h1,h2),h3) h4 h5 h6 h7 o h8 h9 o1 h10 subtree ppr
        zipper1 tt pp p (((h11,h12),(h13,h14)),h15) h16 h17 h18 h19 h20 tt1
        h21 q_ mem2 h22.
destruct subtree; auto.
intuition.
intros.
subst subtree1; simpl in h15.
intuition.
rewrite <- H5.
subst pl; simpl.
rewrite inorder_zip.
simpl.
ae.
Qed.


