(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require Import ZOdiv.
Require BuiltIn.
Require int.Int.
Require int.Abs.
Require int.ComputerDivision.
Require int.Power.

(* Why3 assumption *)
Definition unit  := unit.

Parameter map : forall (a:Type) {a_WT:WhyType a} (b:Type) {b_WT:WhyType b},
  Type.
Axiom map_WhyType : forall (a:Type) {a_WT:WhyType a}
  (b:Type) {b_WT:WhyType b}, WhyType (map a b).
Existing Instance map_WhyType.

Parameter get: forall {a:Type} {a_WT:WhyType a} {b:Type} {b_WT:WhyType b},
  (map a b) -> a -> b.

Parameter set: forall {a:Type} {a_WT:WhyType a} {b:Type} {b_WT:WhyType b},
  (map a b) -> a -> b -> (map a b).

Axiom Select_eq : forall {a:Type} {a_WT:WhyType a} {b:Type} {b_WT:WhyType b},
  forall (m:(map a b)), forall (a1:a) (a2:a), forall (b1:b), (a1 = a2) ->
  ((get (set m a1 b1) a2) = b1).

Axiom Select_neq : forall {a:Type} {a_WT:WhyType a}
  {b:Type} {b_WT:WhyType b}, forall (m:(map a b)), forall (a1:a) (a2:a),
  forall (b1:b), (~ (a1 = a2)) -> ((get (set m a1 b1) a2) = (get m a2)).

Parameter const: forall {a:Type} {a_WT:WhyType a} {b:Type} {b_WT:WhyType b},
  b -> (map a b).

Axiom Const : forall {a:Type} {a_WT:WhyType a} {b:Type} {b_WT:WhyType b},
  forall (b1:b) (a1:a), ((get (const b1:(map a b)) a1) = b1).

(* Why3 assumption *)
Inductive array (a:Type) {a_WT:WhyType a} :=
  | mk_array : BuiltIn.int -> (map BuiltIn.int a) -> array a.
Axiom array_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (array a).
Existing Instance array_WhyType.
Implicit Arguments mk_array [[a] [a_WT]].

(* Why3 assumption *)
Definition elts {a:Type} {a_WT:WhyType a}(v:(array a)): (map BuiltIn.int
  a) := match v with
  | (mk_array x x1) => x1
  end.

(* Why3 assumption *)
Definition length {a:Type} {a_WT:WhyType a}(v:(array a)): BuiltIn.int :=
  match v with
  | (mk_array x x1) => x
  end.

(* Why3 assumption *)
Definition get1 {a:Type} {a_WT:WhyType a}(a1:(array a)) (i:BuiltIn.int): a :=
  (get (elts a1) i).

(* Why3 assumption *)
Definition set1 {a:Type} {a_WT:WhyType a}(a1:(array a)) (i:BuiltIn.int)
  (v:a): (array a) := (mk_array (length a1) (set (elts a1) i v)).

(* Why3 assumption *)
Definition container  := (map BuiltIn.int BuiltIn.int).

Parameter sum: (map BuiltIn.int BuiltIn.int) -> BuiltIn.int -> BuiltIn.int ->
  BuiltIn.int.

Axiom Sum_def_empty : forall (c:(map BuiltIn.int BuiltIn.int))
  (i:BuiltIn.int) (j:BuiltIn.int), (j <= i)%Z -> ((sum c i j) = 0%Z).

Axiom Sum_def_non_empty : forall (c:(map BuiltIn.int BuiltIn.int))
  (i:BuiltIn.int) (j:BuiltIn.int), (i < j)%Z -> ((sum c i j) = ((get c
  i) + (sum c (i + 1%Z)%Z j))%Z).

Axiom Sum_right_extension : forall (c:(map BuiltIn.int BuiltIn.int))
  (i:BuiltIn.int) (j:BuiltIn.int), (i < j)%Z -> ((sum c i j) = ((sum c i
  (j - 1%Z)%Z) + (get c (j - 1%Z)%Z))%Z).

Axiom Sum_transitivity : forall (c:(map BuiltIn.int BuiltIn.int))
  (i:BuiltIn.int) (k:BuiltIn.int) (j:BuiltIn.int), ((i <= k)%Z /\
  (k <= j)%Z) -> ((sum c i j) = ((sum c i k) + (sum c k j))%Z).

Axiom Sum_eq : forall (c1:(map BuiltIn.int BuiltIn.int)) (c2:(map BuiltIn.int
  BuiltIn.int)) (i:BuiltIn.int) (j:BuiltIn.int), (forall (k:BuiltIn.int),
  ((i <= k)%Z /\ (k < j)%Z) -> ((get c1 k) = (get c2 k))) -> ((sum c1 i
  j) = (sum c2 i j)).

(* Why3 assumption *)
Definition sum1(a:(array BuiltIn.int)) (l:BuiltIn.int)
  (h:BuiltIn.int): BuiltIn.int := (sum (elts a) l h).

(* Why3 assumption *)
Definition go_left(left1:BuiltIn.int) (right1:BuiltIn.int): BuiltIn.int :=
  let space := (right1 - left1)%Z in (left1 - (ZOdiv space 2%Z))%Z.

Axiom go_left_bounds : forall (left1:BuiltIn.int) (right1:BuiltIn.int),
  ((0%Z <= left1)%Z /\ (((left1 + 1%Z)%Z < right1)%Z /\
  ((right1 - left1)%Z <= left1)%Z)) -> ((0%Z <= (go_left left1 right1))%Z /\
  ((go_left left1 right1) < left1)%Z).

(* Why3 assumption *)
Definition go_right(left1:BuiltIn.int) (right1:BuiltIn.int): BuiltIn.int :=
  let space := (right1 - left1)%Z in (right1 - (ZOdiv space 2%Z))%Z.

Axiom go_right_bounds : forall (left1:BuiltIn.int) (right1:BuiltIn.int),
  ((0%Z <= left1)%Z /\ (((left1 + 1%Z)%Z < right1)%Z /\
  ((right1 - left1)%Z <= left1)%Z)) -> ((left1 <= (go_right left1
  right1))%Z /\ ((go_right left1 right1) < right1)%Z).

Axiom Div_mod_2 : forall (x:BuiltIn.int), (0%Z <= x)%Z ->
  (((2%Z * (ZOdiv x 2%Z))%Z <= x)%Z /\
  ((x - 1%Z)%Z <= (2%Z * (ZOdiv x 2%Z))%Z)%Z).

(* Why3 assumption *)
Definition is_power_of_2(x:BuiltIn.int): Prop := exists k:BuiltIn.int,
  (0%Z <= k)%Z /\ (x = (int.Power.power 2%Z k)).

Axiom is_power_of_2_1 : forall (x:BuiltIn.int), (is_power_of_2 x) ->
  ((1%Z < x)%Z -> ((2%Z * (ZOdiv x 2%Z))%Z = x)).

Axiom is_power_of_2_2 : forall (x:BuiltIn.int), (is_power_of_2 x) ->
  ((1%Z < x)%Z -> (is_power_of_2 (ZOdiv x 2%Z))).

Axiom is_power_of_2_3 : forall (x:BuiltIn.int), (is_power_of_2 x) ->
  (0%Z < x)%Z.

(* Why3 assumption *)
Inductive phase1 : BuiltIn.int -> BuiltIn.int -> (array BuiltIn.int)
  -> (array BuiltIn.int) -> Prop :=
  | Leaf : forall (left1:BuiltIn.int) (right1:BuiltIn.int) (a0:(array
      BuiltIn.int)) (a:(array BuiltIn.int)), (right1 = (left1 + 1%Z)%Z) ->
      (((get1 a left1) = (get1 a0 left1)) -> (phase1 left1 right1 a0 a))
  | Node : forall (left1:BuiltIn.int) (right1:BuiltIn.int) (a0:(array
      BuiltIn.int)) (a:(array BuiltIn.int)), ((left1 + 1%Z)%Z < right1)%Z ->
      ((phase1 (go_left left1 right1) left1 a0 a) -> ((phase1 (go_right left1
      right1) right1 a0 a) -> (((get1 a left1) = (sum1 a0
      ((left1 - (right1 - left1)%Z)%Z + 1%Z)%Z (left1 + 1%Z)%Z)) ->
      (phase1 left1 right1 a0 a)))).

Axiom phase1_frame : forall (left1:BuiltIn.int) (right1:BuiltIn.int)
  (a0:(array BuiltIn.int)) (a:(array BuiltIn.int)) (a':(array BuiltIn.int)),
  (forall (i:BuiltIn.int), (((left1 - (right1 - left1)%Z)%Z < i)%Z /\
  (i < right1)%Z) -> ((get1 a i) = (get1 a' i))) -> ((phase1 left1 right1 a0
  a) -> (phase1 left1 right1 a0 a')).

Axiom phase1_frame2 : forall (left1:BuiltIn.int) (right1:BuiltIn.int)
  (a0:(array BuiltIn.int)) (a0':(array BuiltIn.int)) (a:(array BuiltIn.int)),
  (forall (i:BuiltIn.int), (((left1 - (right1 - left1)%Z)%Z < i)%Z /\
  (i < right1)%Z) -> ((get1 a0 i) = (get1 a0' i))) -> ((phase1 left1 right1
  a0 a) -> (phase1 left1 right1 a0' a)).

(* Why3 assumption *)
Definition partial_sum(left1:BuiltIn.int) (right1:BuiltIn.int) (a0:(array
  BuiltIn.int)) (a:(array BuiltIn.int)): Prop := forall (i:BuiltIn.int),
  (((left1 - (right1 - left1)%Z)%Z < i)%Z /\ (i <= right1)%Z) -> ((get1 a
  i) = (sum1 a0 0%Z i)).

Require Import Why3.

(* Why3 goal *)
Theorem WP_parameter_main : (0%Z <= 8%Z)%Z -> (((0%Z <= 0%Z)%Z /\
  (0%Z < 8%Z)%Z) -> forall (a:(map BuiltIn.int BuiltIn.int)),
  (a = (set (const 0%Z:(map BuiltIn.int BuiltIn.int)) 0%Z 3%Z)) ->
  (((0%Z <= 1%Z)%Z /\ (1%Z < 8%Z)%Z) -> forall (a1:(map BuiltIn.int
  BuiltIn.int)), (a1 = (set a 1%Z 1%Z)) -> (((0%Z <= 2%Z)%Z /\
  (2%Z < 8%Z)%Z) -> forall (a2:(map BuiltIn.int BuiltIn.int)), (a2 = (set a1
  2%Z 7%Z)) -> (((0%Z <= 3%Z)%Z /\ (3%Z < 8%Z)%Z) -> forall (a3:(map
  BuiltIn.int BuiltIn.int)), (a3 = (set a2 3%Z 0%Z)) -> (((0%Z <= 4%Z)%Z /\
  (4%Z < 8%Z)%Z) -> forall (a4:(map BuiltIn.int BuiltIn.int)), (a4 = (set a3
  4%Z 4%Z)) -> (((0%Z <= 5%Z)%Z /\ (5%Z < 8%Z)%Z) -> forall (a5:(map
  BuiltIn.int BuiltIn.int)), (a5 = (set a4 5%Z 1%Z)) -> (((0%Z <= 6%Z)%Z /\
  (6%Z < 8%Z)%Z) -> forall (a6:(map BuiltIn.int BuiltIn.int)), (a6 = (set a5
  6%Z 6%Z)) -> (((0%Z <= 7%Z)%Z /\ (7%Z < 8%Z)%Z) -> forall (a7:(map
  BuiltIn.int BuiltIn.int)), (a7 = (set a6 7%Z 3%Z)) ->
  forall (a0:BuiltIn.int) (a01:(map BuiltIn.int BuiltIn.int)), ((a0 = 8%Z) /\
  forall (i:BuiltIn.int), ((0%Z <= i)%Z /\ (i < a0)%Z) -> ((get a01
  i) = (get a7 i))) -> (((int.Power.power 2%Z 2%Z) = 4%Z) ->
  (((((0%Z <= 3%Z)%Z /\ (3%Z < 7%Z)%Z) /\ (7%Z < 8%Z)%Z) /\
  (is_power_of_2 (7%Z - 3%Z)%Z)) -> forall (a8:(map BuiltIn.int
  BuiltIn.int)), ((phase1 3%Z 7%Z (mk_array 8%Z a7) (mk_array 8%Z a8)) /\
  (((get a8 7%Z) = (sum a7 ((3%Z - (7%Z - 3%Z)%Z)%Z + 1%Z)%Z
  (7%Z + 1%Z)%Z)) /\ ((forall (i:BuiltIn.int),
  (i <= (3%Z - (7%Z - 3%Z)%Z)%Z)%Z -> ((get a8 i) = (get a7 i))) /\
  forall (i:BuiltIn.int), (7%Z < i)%Z -> ((get a8 i) = (get a7 i))))) ->
  (((0%Z <= 7%Z)%Z /\ (7%Z < 8%Z)%Z) -> forall (a9:(map BuiltIn.int
  BuiltIn.int)), (a9 = (set a8 7%Z 0%Z)) -> (phase1 3%Z 7%Z (mk_array a0 a01)
  (mk_array 8%Z a9))))))))))))).
intros h1 (h2,h3) a h4 (h5,h6) a1 h7 (h8,h9) a2 h10 (h11,h12) a3 h13
(h14,h15) a4 h16 (h17,h18) a5 h19 (h20,h21) a6 h22 (h23,h24) a7 h25 a0 a01
(h26,h27) h28 (((h29,h30),h31),h32) a8 (h33,(h34,(h35,h36))) (h37,h38) a9
h39.
apply (phase1_frame 3 7 (mk_array a0 a01) (mk_array 8 a8) (mk_array 8 a9)).
why3 "cvc3".
apply (phase1_frame2 3 7 (mk_array 8 a7) (mk_array a0 a01) (mk_array 8 a8)).
why3 "cvc3".
assumption.
Qed.


