(* This file is generated by Why3's Coq 8.4 driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require int.Int.
Require map.Map.
Require map.MapPermut.

(* Why3 assumption *)
Definition unit := unit.

(* Why3 assumption *)
Inductive ref (a:Type) {a_WT:WhyType a} :=
  | mk_ref : a -> ref a.
Axiom ref_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (ref a).
Existing Instance ref_WhyType.
Implicit Arguments mk_ref [[a] [a_WT]].

(* Why3 assumption *)
Definition contents {a:Type} {a_WT:WhyType a} (v:(ref a)): a :=
  match v with
  | (mk_ref x) => x
  end.

(* Why3 assumption *)
Inductive array
  (a:Type) {a_WT:WhyType a} :=
  | mk_array : Z -> (map.Map.map Z a) -> array a.
Axiom array_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (array a).
Existing Instance array_WhyType.
Implicit Arguments mk_array [[a] [a_WT]].

(* Why3 assumption *)
Definition elts {a:Type} {a_WT:WhyType a} (v:(array a)): (map.Map.map Z a) :=
  match v with
  | (mk_array x x1) => x1
  end.

(* Why3 assumption *)
Definition length {a:Type} {a_WT:WhyType a} (v:(array a)): Z :=
  match v with
  | (mk_array x x1) => x
  end.

(* Why3 assumption *)
Definition get {a:Type} {a_WT:WhyType a} (a1:(array a)) (i:Z): a :=
  (map.Map.get (elts a1) i).

(* Why3 assumption *)
Definition set {a:Type} {a_WT:WhyType a} (a1:(array a)) (i:Z) (v:a): (array
  a) := (mk_array (length a1) (map.Map.set (elts a1) i v)).

(* Why3 assumption *)
Definition make {a:Type} {a_WT:WhyType a} (n:Z) (v:a): (array a) :=
  (mk_array n (map.Map.const v:(map.Map.map Z a))).

(* Why3 assumption *)
Definition sorted_sub (a:(map.Map.map Z Z)) (l:Z) (u:Z): Prop :=
  forall (i1:Z) (i2:Z), (((l <= i1)%Z /\ (i1 <= i2)%Z) /\ (i2 < u)%Z) ->
  ((map.Map.get a i1) <= (map.Map.get a i2))%Z.

(* Why3 assumption *)
Definition sorted_sub1 (a:(array Z)) (l:Z) (u:Z): Prop := (sorted_sub
  (elts a) l u).

(* Why3 assumption *)
Definition sorted (a:(array Z)): Prop := (sorted_sub (elts a) 0%Z
  (length a)).

(* Why3 assumption *)
Definition exchange {a:Type} {a_WT:WhyType a} (a1:(array a)) (a2:(array a))
  (i:Z) (j:Z): Prop := (map.MapPermut.exchange (elts a1) (elts a2) i j).

(* Why3 assumption *)
Definition permut_sub {a:Type} {a_WT:WhyType a} (a1:(array a)) (a2:(array a))
  (l:Z) (u:Z): Prop := (map.MapPermut.permut_sub (elts a1) (elts a2) l u).

(* Why3 assumption *)
Definition permut {a:Type} {a_WT:WhyType a} (a1:(array a)) (a2:(array
  a)): Prop := ((length a1) = (length a2)) /\ (map.MapPermut.permut_sub
  (elts a1) (elts a2) 0%Z (length a1)).

Axiom exchange_permut : forall {a:Type} {a_WT:WhyType a}, forall (a1:(array
  a)) (a2:(array a)) (i:Z) (j:Z), (exchange a1 a2 i j) ->
  (((length a1) = (length a2)) -> (((0%Z <= i)%Z /\ (i < (length a1))%Z) ->
  (((0%Z <= j)%Z /\ (j < (length a1))%Z) -> (permut a1 a2)))).

Axiom permut_sym : forall {a:Type} {a_WT:WhyType a}, forall (a1:(array a))
  (a2:(array a)), (permut a1 a2) -> (permut a2 a1).

Axiom permut_trans : forall {a:Type} {a_WT:WhyType a}, forall (a1:(array a))
  (a2:(array a)) (a3:(array a)), (permut a1 a2) -> ((permut a2 a3) -> (permut
  a1 a3)).

(* Why3 assumption *)
Definition map_eq_sub {a:Type} {a_WT:WhyType a} (a1:(map.Map.map Z a))
  (a2:(map.Map.map Z a)) (l:Z) (u:Z): Prop := forall (i:Z), ((l <= i)%Z /\
  (i < u)%Z) -> ((map.Map.get a1 i) = (map.Map.get a2 i)).

(* Why3 assumption *)
Definition array_eq_sub {a:Type} {a_WT:WhyType a} (a1:(array a)) (a2:(array
  a)) (l:Z) (u:Z): Prop := (map_eq_sub (elts a1) (elts a2) l u).

(* Why3 assumption *)
Definition array_eq {a:Type} {a_WT:WhyType a} (a1:(array a)) (a2:(array
  a)): Prop := ((length a1) = (length a2)) /\ (array_eq_sub a1 a2 0%Z
  (length a1)).

Axiom array_eq_sub_permut : forall {a:Type} {a_WT:WhyType a},
  forall (a1:(array a)) (a2:(array a)) (l:Z) (u:Z), (array_eq_sub a1 a2 l
  u) -> (permut_sub a1 a2 l u).

Axiom array_eq_permut : forall {a:Type} {a_WT:WhyType a}, forall (a1:(array
  a)) (a2:(array a)), (array_eq a1 a2) -> (permut a1 a2).


Import MapPermut.

(* Why3 goal *)
Theorem WP_parameter_quick_rec : forall (t:Z) (l:Z) (r:Z),
  forall (t1:(map.Map.map Z Z)), ((0%Z <= t)%Z /\ ((0%Z <= l)%Z /\
  (r < t)%Z)) -> ((l < r)%Z -> (((0%Z <= l)%Z /\ (l < t)%Z) -> let v :=
  (map.Map.get t1 l) in (((l + 1%Z)%Z <= r)%Z -> forall (m:Z)
  (t2:(map.Map.map Z Z)), forall (i:Z), (((l + 1%Z)%Z <= i)%Z /\
  (i <= r)%Z) -> (((forall (j:Z), ((l < j)%Z /\ (j <= m)%Z) ->
  ((map.Map.get t2 j) < v)%Z) /\ ((forall (j:Z), ((m < j)%Z /\ (j < i)%Z) ->
  (v <= (map.Map.get t2 j))%Z) /\ ((map.MapPermut.permut_sub t1 t2 l
  (r + 1%Z)%Z) /\ (((map.Map.get t2 l) = v) /\ ((l <= m)%Z /\
  (m < i)%Z))))) -> (((0%Z <= t)%Z /\ ((0%Z <= i)%Z /\ (i < t)%Z)) ->
  (((map.Map.get t2 i) < v)%Z -> forall (m1:Z), (m1 = (m + 1%Z)%Z) ->
  ((((0%Z <= i)%Z /\ (i < t)%Z) /\ ((0%Z <= m1)%Z /\ (m1 < t)%Z)) ->
  forall (t3:(map.Map.map Z Z)), ((0%Z <= t)%Z /\ (map.MapPermut.exchange t2
  t3 i m1)) -> (map.MapPermut.permut_sub t1 t3 l (r + 1%Z)%Z)))))))).
(* intros t l r t1 (h1,(h2,h3)) h4 (h5,h6) v h7 m t2 i (h8,h9)
   (h10,(h11,(h12,(h13,(h14,h15))))) (h16,(h17,h18)) h19 m1 h20
   ((h21,h22),(h23,h24)) t3 (h25,h26). *)
(* YOU MAY EDIT THE PROOF BELOW *)
intuition.
intuition.
apply permut_trans with t2; auto.
apply permut_exchange with i m1; try omega.
auto.
Qed.


