(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import ZArith.
Require Import Rbase.
Require int.Int.

(* Why3 assumption *)
Definition unit  := unit.

(* Why3 assumption *)
Inductive list (a:Type) :=
  | Nil : list a
  | Cons : a -> (list a) -> list a.
Set Contextual Implicit.
Implicit Arguments Nil.
Unset Contextual Implicit.
Implicit Arguments Cons.

(* Why3 assumption *)
Set Implicit Arguments.
Fixpoint length (a:Type)(l:(list a)) {struct l}: Z :=
  match l with
  | Nil => 0%Z
  | (Cons _ r) => (1%Z + (length r))%Z
  end.
Unset Implicit Arguments.

Axiom Length_nonnegative : forall (a:Type), forall (l:(list a)),
  (0%Z <= (length l))%Z.

Axiom Length_nil : forall (a:Type), forall (l:(list a)),
  ((length l) = 0%Z) <-> (l = (Nil :(list a))).

(* Why3 assumption *)
Inductive sorted : (list Z) -> Prop :=
  | Sorted_Nil : (sorted (Nil :(list Z)))
  | Sorted_One : forall (x:Z), (sorted (Cons x (Nil :(list Z))))
  | Sorted_Two : forall (x:Z) (y:Z) (l:(list Z)), (x <= y)%Z ->
      ((sorted (Cons y l)) -> (sorted (Cons x (Cons y l)))).

(* Why3 assumption *)
Set Implicit Arguments.
Fixpoint mem (a:Type)(x:a) (l:(list a)) {struct l}: Prop :=
  match l with
  | Nil => False
  | (Cons y r) => (x = y) \/ (mem x r)
  end.
Unset Implicit Arguments.

Axiom sorted_mem : forall (x:Z) (l:(list Z)), ((forall (y:Z), (mem y l) ->
  (x <= y)%Z) /\ (sorted l)) <-> (sorted (Cons x l)).

(* Why3 assumption *)
Set Implicit Arguments.
Fixpoint infix_plpl (a:Type)(l1:(list a)) (l2:(list a)) {struct l1}: (list
  a) :=
  match l1 with
  | Nil => l2
  | (Cons x1 r1) => (Cons x1 (infix_plpl r1 l2))
  end.
Unset Implicit Arguments.

Axiom Append_assoc : forall (a:Type), forall (l1:(list a)) (l2:(list a))
  (l3:(list a)), ((infix_plpl l1 (infix_plpl l2
  l3)) = (infix_plpl (infix_plpl l1 l2) l3)).

Axiom Append_l_nil : forall (a:Type), forall (l:(list a)), ((infix_plpl l
  (Nil :(list a))) = l).

Axiom Append_length : forall (a:Type), forall (l1:(list a)) (l2:(list a)),
  ((length (infix_plpl l1 l2)) = ((length l1) + (length l2))%Z).

Axiom mem_append : forall (a:Type), forall (x:a) (l1:(list a)) (l2:(list a)),
  (mem x (infix_plpl l1 l2)) <-> ((mem x l1) \/ (mem x l2)).

Axiom mem_decomp : forall (a:Type), forall (x:a) (l:(list a)), (mem x l) ->
  exists l1:(list a), exists l2:(list a), (l = (infix_plpl l1 (Cons x l2))).

Parameter num_occ: forall (a:Type), a -> (list a) -> Z.
Implicit Arguments num_occ.

Axiom num_occ_def : forall (a:Type), forall (x:a) (l:(list a)),
  match l with
  | Nil => ((num_occ x l) = 0%Z)
  | (Cons y r) => ((x = y) -> ((num_occ x l) = (1%Z + (num_occ x r))%Z)) /\
      ((~ (x = y)) -> ((num_occ x l) = (0%Z + (num_occ x r))%Z))
  end.

Axiom Mem_Num_Occ : forall (a:Type), forall (x:a) (l:(list a)), (mem x l) <->
  (0%Z < (num_occ x l))%Z.

Axiom Append_Num_Occ : forall (a:Type), forall (x:a) (l1:(list a)) (l2:(list
  a)), ((num_occ x (infix_plpl l1 l2)) = ((num_occ x l1) + (num_occ x
  l2))%Z).

(* Why3 assumption *)
Definition permut (a:Type)(l1:(list a)) (l2:(list a)): Prop := forall (x:a),
  ((num_occ x l1) = (num_occ x l2)).
Implicit Arguments permut.

Axiom Permut_refl : forall (a:Type), forall (l:(list a)), (permut l l).

Axiom Permut_sym : forall (a:Type), forall (l1:(list a)) (l2:(list a)),
  (permut l1 l2) -> (permut l2 l1).

Axiom Permut_trans : forall (a:Type), forall (l1:(list a)) (l2:(list a))
  (l3:(list a)), (permut l1 l2) -> ((permut l2 l3) -> (permut l1 l3)).

Axiom Permut_cons : forall (a:Type), forall (x:a) (l1:(list a)) (l2:(list
  a)), (permut l1 l2) -> (permut (Cons x l1) (Cons x l2)).

Axiom Permut_swap : forall (a:Type), forall (x:a) (y:a) (l:(list a)),
  (permut (Cons x (Cons y l)) (Cons y (Cons x l))).

Axiom Permut_cons_append : forall (a:Type), forall (x:a) (l1:(list a))
  (l2:(list a)), (permut (infix_plpl (Cons x l1) l2) (infix_plpl l1 (Cons x
  l2))).

Axiom Permut_assoc : forall (a:Type), forall (l1:(list a)) (l2:(list a))
  (l3:(list a)), (permut (infix_plpl (infix_plpl l1 l2) l3) (infix_plpl l1
  (infix_plpl l2 l3))).

Axiom Permut_append : forall (a:Type), forall (l1:(list a)) (l2:(list a))
  (k1:(list a)) (k2:(list a)), (permut l1 k1) -> ((permut l2 k2) ->
  (permut (infix_plpl l1 l2) (infix_plpl k1 k2))).

Axiom Permut_append_swap : forall (a:Type), forall (l1:(list a)) (l2:(list
  a)), (permut (infix_plpl l1 l2) (infix_plpl l2 l1)).

Axiom Permut_mem : forall (a:Type), forall (x:a) (l1:(list a)) (l2:(list a)),
  (permut l1 l2) -> ((mem x l1) -> (mem x l2)).

Axiom Permut_length : forall (a:Type), forall (l1:(list a)) (l2:(list a)),
  (permut l1 l2) -> ((length l1) = (length l2)).



(* Why3 goal *)
Theorem WP_parameter_mergesort : forall (l:(list Z)),
  match l with
  | (Nil|(Cons _ Nil)) => True
  | _ => (2%Z <= (length l))%Z -> forall (result:(list Z)) (result1:(list
      Z)), ((1%Z <= (length result))%Z /\ ((1%Z <= (length result1))%Z /\
      (permut l (infix_plpl result result1)))) -> (((0%Z <= (length l))%Z /\
      ((length result1) < (length l))%Z) -> forall (o:(list Z)),
      ((sorted o) /\ (permut o result1)) -> (((0%Z <= (length l))%Z /\
      ((length result) < (length l))%Z) -> forall (o1:(list Z)),
      ((sorted o1) /\ (permut o1 result)) -> (((sorted o1) /\ (sorted o)) ->
      forall (result2:(list Z)), ((sorted result2) /\ (permut result2
      (infix_plpl o1 o))) -> (permut result2 l))))
  end.
(* YOU MAY EDIT THE PROOF BELOW *)
destruct l; try trivial.
destruct l; try trivial.
intuition.
apply Permut_trans with (infix_plpl o1 o); auto.
apply Permut_trans with (infix_plpl result result1); auto.
apply Permut_append; auto.
apply Permut_sym; auto.
Qed.


