(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require Import ZOdiv.
Require BuiltIn.
Require int.Int.
Require int.Abs.
Require int.EuclideanDivision.
Require int.ComputerDivision.
Require number.Parity.
Require number.Divisibility.
Require number.Prime.
Require map.Map.

(* Why3 assumption *)
Definition unit  := unit.

(* Why3 assumption *)
Definition lt_nat(x:Z) (y:Z): Prop := (0%Z <= y)%Z /\ (x < y)%Z.

(* Why3 assumption *)
Inductive lex : (Z* Z)%type -> (Z* Z)%type -> Prop :=
  | Lex_1 : forall (x1:Z) (x2:Z) (y1:Z) (y2:Z), (lt_nat x1 x2) -> (lex (x1,
      y1) (x2, y2))
  | Lex_2 : forall (x:Z) (y1:Z) (y2:Z), (lt_nat y1 y2) -> (lex (x, y1) (x,
      y2)).

(* Why3 assumption *)
Inductive ref (a:Type) {a_WT:WhyType a} :=
  | mk_ref : a -> ref a.
Axiom ref_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (ref a).
Existing Instance ref_WhyType.
Implicit Arguments mk_ref [[a] [a_WT]].

(* Why3 assumption *)
Definition contents {a:Type} {a_WT:WhyType a}(v:(ref a)): a :=
  match v with
  | (mk_ref x) => x
  end.

(* Why3 assumption *)
Inductive array (a:Type) {a_WT:WhyType a} :=
  | mk_array : Z -> (map.Map.map Z a) -> array a.
Axiom array_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (array a).
Existing Instance array_WhyType.
Implicit Arguments mk_array [[a] [a_WT]].

(* Why3 assumption *)
Definition elts {a:Type} {a_WT:WhyType a}(v:(array a)): (map.Map.map Z a) :=
  match v with
  | (mk_array x x1) => x1
  end.

(* Why3 assumption *)
Definition length {a:Type} {a_WT:WhyType a}(v:(array a)): Z :=
  match v with
  | (mk_array x x1) => x
  end.

(* Why3 assumption *)
Definition get {a:Type} {a_WT:WhyType a}(a1:(array a)) (i:Z): a :=
  (map.Map.get (elts a1) i).

(* Why3 assumption *)
Definition set {a:Type} {a_WT:WhyType a}(a1:(array a)) (i:Z) (v:a): (array
  a) := (mk_array (length a1) (map.Map.set (elts a1) i v)).

(* Why3 assumption *)
Definition make {a:Type} {a_WT:WhyType a}(n:Z) (v:a): (array a) :=
  (mk_array n (map.Map.const v:(map.Map.map Z a))).

(* Why3 assumption *)
Definition no_prime_in(l:Z) (u:Z): Prop := forall (x:Z), ((l < x)%Z /\
  (x < u)%Z) -> ~ (number.Prime.prime x).

(* Why3 assumption *)
Definition first_primes(p:(array Z)) (u:Z): Prop := ((get p 0%Z) = 2%Z) /\
  ((forall (i:Z) (j:Z), (((0%Z <= i)%Z /\ (i < j)%Z) /\ (j < u)%Z) -> ((get p
  i) < (get p j))%Z) /\ ((forall (i:Z), ((0%Z <= i)%Z /\ (i < u)%Z) ->
  (number.Prime.prime (get p i))) /\ forall (i:Z), ((0%Z <= i)%Z /\
  (i < (u - 1%Z)%Z)%Z) -> (no_prime_in (get p i) (get p (i + 1%Z)%Z)))).

Axiom exists_prime : forall (p:(array Z)) (u:Z), (1%Z <= u)%Z ->
  ((first_primes p u) -> forall (d:Z), ((2%Z <= d)%Z /\ (d <= (get p
  (u - 1%Z)%Z))%Z) -> ((number.Prime.prime d) -> exists i:Z, ((0%Z <= i)%Z /\
  (i < u)%Z) /\ (d = (get p i)))).

Axiom Bertrand_postulate : forall (p:Z), (number.Prime.prime p) ->
  ~ (no_prime_in p (2%Z * p)%Z).

(* Why3 goal *)
Theorem WP_parameter_prime_numbers : forall (m:Z), (2%Z <= m)%Z ->
  ((0%Z <= m)%Z -> ((0%Z <= m)%Z -> (((0%Z <= 0%Z)%Z /\ (0%Z < m)%Z) ->
  forall (p:(map.Map.map Z Z)), ((0%Z <= m)%Z /\
  (p = (map.Map.set (map.Map.const 0%Z:(map.Map.map Z Z)) 0%Z 2%Z))) ->
  (((0%Z <= 1%Z)%Z /\ (1%Z < m)%Z) -> forall (p1:(map.Map.map Z Z)),
  ((0%Z <= m)%Z /\ (p1 = (map.Map.set p 1%Z 3%Z))) ->
  ((2%Z <= (m - 1%Z)%Z)%Z -> forall (n:Z) (p2:(map.Map.map Z Z)),
  forall (j:Z), ((2%Z <= j)%Z /\ (j <= (m - 1%Z)%Z)%Z) ->
  (((((first_primes (mk_array m p2) j) /\ (((map.Map.get p2
  (j - 1%Z)%Z) < n)%Z /\ (n < (2%Z * (map.Map.get p2 (j - 1%Z)%Z))%Z)%Z)) /\
  (number.Parity.odd n)) /\ (no_prime_in (map.Map.get p2 (j - 1%Z)%Z) n)) ->
  forall (k:Z), forall (n1:Z) (p3:(map.Map.map Z Z)), ((0%Z <= m)%Z /\
  (((((((1%Z <= k)%Z /\ (k < j)%Z) /\ (first_primes (mk_array m p3) j)) /\
  (((map.Map.get p3 (j - 1%Z)%Z) < n1)%Z /\ (n1 < (2%Z * (map.Map.get p3
  (j - 1%Z)%Z))%Z)%Z)) /\ (number.Parity.odd n1)) /\
  (no_prime_in (map.Map.get p3 (j - 1%Z)%Z) n1)) /\ forall (i:Z),
  ((0%Z <= i)%Z /\ (i < k)%Z) ->
  ~ (number.Divisibility.divides (map.Map.get p3 i) n1))) ->
  (((0%Z <= k)%Z /\ (k < m)%Z) -> (((ZOmod n1 (map.Map.get p3 k)) = 0%Z) ->
  ((~ (number.Prime.prime n1)) -> forall (n2:Z), (n2 = (n1 + 2%Z)%Z) ->
  (n2 < (2%Z * (map.Map.get p3 (j - 1%Z)%Z))%Z)%Z))))))))).
Proof.
intros.
assert (case: (n2 < 2 * Map.get p3 (j-1) \/ n2 >= 2 * Map.get p3 (j-1))%Z) by omega.
destruct case.
auto.
apply False_ind.
apply Bertrand_postulate with (Map.get p3 (j-1)%Z); intuition.
red in H31; decompose [and] H31; clear H31.
apply H34; omega.
red; intros.
assert (case: (x < n1 \/ x = n1 \/ x = n1+1)%Z) by omega. destruct case.
apply H27; omega.
destruct H34; subst x.
intuition.
intro K.
apply Prime.even_prime in K.
omega.
now apply Parity.odd_even.
Qed.


