(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import ZArith.
Require Import Rbase.
Require int.Int.

Parameter pow2: Z -> Z.

Axiom Power_0 : ((pow2 0%Z) = 1%Z).

Axiom Power_s : forall (n:Z), (0%Z <= n)%Z ->
  ((pow2 (n + 1%Z)%Z) = (2%Z * (pow2 n))%Z).

Axiom Power_1 : ((pow2 1%Z) = 2%Z).

Open Scope Z_scope.
Require Import Why3.

(* Why3 goal *)
Theorem Power_sum : forall (n:Z) (m:Z), ((0%Z <= n)%Z /\ (0%Z <= m)%Z) ->
  ((pow2 (n + m)%Z) = ((pow2 n) * (pow2 m))%Z).
intros n m (Hn & Hm).
generalize Hm.
pattern m; apply Z_lt_induction; auto.
clear m Hm.
intros m Hind Hm.
assert (h:(m = 0 \/ m > 0)) by omega; destruct h.
why3 "alt-ergo".
replace m with ((m-1)+1) by omega.
rewrite Power_s; auto with zarith.
why3 "alt-ergo".
Qed.


