(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import ZArith.
Require Import Rbase.
Require int.Int.
Require real.Real.
Require real.RealInfix.

Parameter pow2: Z -> R.

Axiom Power_0 : ((pow2 0%Z) = 1%R).

Axiom Power_s : forall (n:Z), (0%Z <= n)%Z ->
  ((pow2 (n + 1%Z)%Z) = (2%R * (pow2 n))%R).

Axiom Power_p : forall (n:Z), (n <= 0%Z)%Z ->
  ((pow2 (n - 1%Z)%Z) = ((05 / 10)%R * (pow2 n))%R).

Axiom Power_s_all : forall (n:Z), ((pow2 (n + 1%Z)%Z) = (2%R * (pow2 n))%R).

Axiom Power_p_all : forall (n:Z),
  ((pow2 (n - 1%Z)%Z) = ((05 / 10)%R * (pow2 n))%R).

Axiom Power_1_2 : ((05 / 10)%R = (Rdiv 1%R 2%R)%R).

Axiom Power_1 : ((pow2 1%Z) = 2%R).

Axiom Power_neg1 : ((pow2 (-1%Z)%Z) = (05 / 10)%R).

Axiom Power_non_null_aux : forall (n:Z), (0%Z <= n)%Z -> ~ ((pow2 n) = 0%R).

Open Scope R_scope.
Open Scope Z_scope.

(* Why3 goal *)
Theorem Power_neg_aux : forall (n:Z), (0%Z <= n)%Z ->
  ((pow2 (-n)%Z) = (Rdiv 1%R (pow2 n))%R).
(* YOU MAY EDIT THE PROOF BELOW *)
intros n H.
cut (0 <=n);auto.
apply Z_lt_induction with
  (P:= fun n => 
      0 <= n -> pow2 (- n) = (1 / pow2 n)%R);
  auto with zarith.
intros x Hind Hxpos.
assert (hx:x>0\/x=0) by omega.
destruct hx.
replace (x) with (x-1+1) by omega.
replace (- (x - 1 + 1)) with (-(x-1) -1)  by omega.
rewrite Power_p;auto with zarith.
rewrite Power_s;auto with zarith.
rewrite Hind;auto with *.
rewrite Power_1_2.
unfold Rdiv in |-*.
repeat rewrite Rmult_1_l.
rewrite<-Rinv_mult_distr;auto.
apply Rgt_not_eq;auto with *.
apply Power_non_null_aux; omega.
(*x = 0*)
subst x.
replace (-0) with 0 by omega.
rewrite Power_0.
unfold Rdiv in |-*.
rewrite Rinv_r;auto with *.

Qed.


