(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require int.Int.
Require list.List.
Require list.Length.
Require list.Mem.
Require list.Append.
Require list.Reverse.

(* Why3 assumption *)
Definition unit := unit.

(* Why3 assumption *)
Inductive tree :=
  | Leaf : tree
  | Node : tree -> tree -> tree.
Axiom tree_WhyType : WhyType tree.
Existing Instance tree_WhyType.

(* Why3 assumption *)
Fixpoint depths (d:Z) (t:tree) {struct t}: (list Z) :=
  match t with
  | Leaf => (cons d nil)
  | (Node l r) => (List.app (depths (d + 1%Z)%Z l) (depths (d + 1%Z)%Z r))
  end.

Axiom depths_head : forall (t:tree) (d:Z), match (depths d
  t) with
  | (cons x _) => (d <= x)%Z
  | nil => False
  end.

Axiom depths_unique : forall (t1:tree) (t2:tree) (d:Z) (s1:(list Z))
  (s2:(list Z)), ((List.app (depths d t1) s1) = (List.app (depths d
  t2) s2)) -> ((t1 = t2) /\ (s1 = s2)).

Axiom depths_prefix : forall (t:tree) (d1:Z) (d2:Z) (s1:(list Z))
  (s2:(list Z)), ((List.app (depths d1 t) s1) = (List.app (depths d2
  t) s2)) -> (d1 = d2).

Axiom depths_prefix_simple : forall (t:tree) (d1:Z) (d2:Z), ((depths d1
  t) = (depths d2 t)) -> (d1 = d2).

Axiom depths_subtree : forall (t1:tree) (t2:tree) (d1:Z) (d2:Z)
  (s1:(list Z)), ((List.app (depths d1 t1) s1) = (depths d2 t2)) ->
  (d2 <= d1)%Z.

Axiom depths_unique2 : forall (t1:tree) (t2:tree) (d1:Z) (d2:Z), ((depths d1
  t1) = (depths d2 t2)) -> ((d1 = d2) /\ (t1 = t2)).

(* Why3 assumption *)
Fixpoint forest_depths (f:(list (Z* tree)%type)) {struct f}: (list Z) :=
  match f with
  | nil => nil
  | (cons (d, t) r) => (List.app (depths d t) (forest_depths r))
  end.

Axiom forest_depths_append : forall (f1:(list (Z* tree)%type)) (f2:(list (Z*
  tree)%type)),
  ((forest_depths (List.app f1 f2)) = (List.app (forest_depths f1) (forest_depths f2))).

(* Why3 assumption *)
Fixpoint greedy (d:Z) (d1:Z) (t1:tree) {struct t1}: Prop := (~ (d = d1)) /\
  match t1 with
  | Leaf => True
  | (Node l1 _) => (greedy d (d1 + 1%Z)%Z l1)
  end.

(* Why3 assumption *)
Inductive g : (list (Z* tree)%type) -> Prop :=
  | Gnil : (g nil)
  | Gone : forall (d:Z) (t:tree), (g (cons (d, t) nil))
  | Gtwo : forall (d1:Z) (d2:Z) (t1:tree) (t2:tree) (l:(list (Z*
      tree)%type)), (greedy d1 d2 t2) -> ((g (cons (d1, t1) l)) -> (g (cons (
      d2, t2) (cons (d1, t1) l)))).

Axiom g_append : forall (l1:(list (Z* tree)%type)) (l2:(list (Z*
  tree)%type)), (g (List.app l1 l2)) -> (g l1).

Axiom right_nil : forall (l:(list (Z* tree)%type)),
  (2%Z <= (list.Length.length l))%Z -> ((g l) -> forall (t:tree) (d:Z),
  ~ ((forest_depths (List.rev l)) = (depths d t))).

Axiom main_lemma : forall (l:(list (Z* tree)%type)) (d1:Z) (d2:Z) (t1:tree)
  (t2:tree), (~ (d1 = d2)) -> ((g (cons (d1, t1) l)) ->
  (match t2 with
  | (Node l2 _) => (greedy d1 (d2 + 1%Z)%Z l2)
  | Leaf => True
  end -> (g (cons (d2, t2) (cons (d1, t1) l))))).

(* Why3 assumption *)
Fixpoint only_leaf (l:(list (Z* tree)%type)) {struct l}: Prop :=
  match l with
  | nil => True
  | (cons (_, t) r) => (t = Leaf) /\ (only_leaf r)
  end.

(* Why3 goal *)
Theorem WP_parameter_tc : forall (left1:(list (Z* tree)%type))
  (right1:(list (Z* tree)%type)), ((g left1) /\
  (match left1 with
  | (cons (d1, t1) nil) => (~ (d1 = 0%Z)) \/ ~ (right1 = nil)
  | _ => True
  end /\
  match right1 with
  | (cons (d2, t2) right') => (only_leaf right') /\
      match t2 with
      | (Node l2 _) => (g (cons ((d2 + 1%Z)%Z, l2) left1))
      | Leaf => True
      end
  | nil => True
  end)) ->
  match right1 with
  | (cons x x1) =>
      match x1 with
      | nil => True
      | _ =>
          match x with
          | (x2, x3) =>
              match left1 with
              | (cons x4 x5) =>
                  match x4 with
                  | (x6, x7) => (x6 = x2) -> (((g x5) /\
                      (match x5 with
                      | (cons (d1, t1) nil) => True
                      | _ => True
                      end /\ ((only_leaf x1) /\ (g (cons (
                      ((x6 - 1%Z)%Z + 1%Z)%Z, x7) x5))))) ->
                      forall (result:tree), ((depths 0%Z
                      result) = (forest_depths (List.app (List.rev x5) (cons (
                      (x6 - 1%Z)%Z, (Node x7 x3)) x1)))) -> ((depths 0%Z
                      result) = (forest_depths (List.app (List.rev left1) right1))))
                  end
              | nil => True
              end
          end
      end
  | nil => True
  end.
(* Why3 intros left1 right1 (h1,(h2,h3)). *)
intuition.
destruct right1; auto.
destruct right1; auto.
destruct left1; auto.
destruct p; auto.
destruct p; destruct p1.
intros eq _ result.
rewrite Reverse.reverse_append.
subst z0.
intro eq; rewrite eq; clear eq.
do 2 rewrite forest_depths_append.
apply f_equal.
simpl.
replace (z-1+1)%Z with z by omega.
rewrite Append.Append_assoc; auto.
Qed.


