(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require map.Map.
Require map.Const.
Require int.Int.
Require int.Abs.
Require int.ComputerDivision.
Require int.Power.

(* Why3 assumption *)
Definition unit := unit.

Axiom int31 : Type.
Parameter int31_WhyType : WhyType int31.
Existing Instance int31_WhyType.

Parameter to_int: int31 -> Z.

(* Why3 assumption *)
Definition in_bounds (n:Z): Prop := ((-1073741824%Z)%Z <= n)%Z /\
  (n <= 1073741823%Z)%Z.

Axiom to_int_in_bounds : forall (n:int31), (in_bounds (to_int n)).

Axiom extensionality : forall (x:int31) (y:int31),
  ((to_int x) = (to_int y)) -> (x = y).

(* Why3 assumption *)
Inductive array
  (a:Type) :=
  | mk_array : int31 -> (map.Map.map Z a) -> array a.
Axiom array_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (array a).
Existing Instance array_WhyType.
Implicit Arguments mk_array [[a]].

(* Why3 assumption *)
Definition elts {a:Type} {a_WT:WhyType a} (v:(array a)): (map.Map.map Z a) :=
  match v with
  | (mk_array x x1) => x1
  end.

(* Why3 assumption *)
Definition length {a:Type} {a_WT:WhyType a} (v:(array a)): int31 :=
  match v with
  | (mk_array x x1) => x
  end.

(* Why3 assumption *)
Definition get {a:Type} {a_WT:WhyType a} (a1:(array a)) (i:Z): a :=
  (map.Map.get (elts a1) i).

(* Why3 assumption *)
Definition set {a:Type} {a_WT:WhyType a} (a1:(array a)) (i:Z) (v:a): (array
  a) := (mk_array (length a1) (map.Map.set (elts a1) i v)).

(* Why3 assumption *)
Inductive ref (a:Type) :=
  | mk_ref : a -> ref a.
Axiom ref_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (ref a).
Existing Instance ref_WhyType.
Implicit Arguments mk_ref [[a]].

(* Why3 assumption *)
Definition contents {a:Type} {a_WT:WhyType a} (v:(ref a)): a :=
  match v with
  | (mk_ref x) => x
  end.

Axiom uint32 : Type.
Parameter uint32_WhyType : WhyType uint32.
Existing Instance uint32_WhyType.

Parameter to_int1: uint32 -> Z.

(* Why3 assumption *)
Definition in_bounds1 (n:Z): Prop := (0%Z <= n)%Z /\ (n <= 4294967295%Z)%Z.

Axiom to_int_in_bounds1 : forall (n:uint32), (in_bounds1 (to_int1 n)).

Axiom extensionality1 : forall (x:uint32) (y:uint32),
  ((to_int1 x) = (to_int1 y)) -> (x = y).

Parameter zero_unsigned: uint32.

Axiom zero_unsigned_is_zero : ((to_int1 zero_unsigned) = 0%Z).

(* Why3 assumption *)
Definition limb := uint32.

Axiom limb_max_bound : (1%Z <= 4294967295%Z)%Z.

(* Why3 assumption *)
Inductive t :=
  | mk_t : (array uint32) -> t.
Axiom t_WhyType : WhyType t.
Existing Instance t_WhyType.

(* Why3 assumption *)
Definition digits (v:t): (array uint32) := match v with
  | (mk_t x) => x
  end.

Parameter value_sub: (map.Map.map Z uint32) -> Z -> Z -> Z.

Axiom value_sub_next : forall (x:(map.Map.map Z uint32)) (n:Z) (m:Z),
  ((n < m)%Z -> ((value_sub x n m) = ((to_int1 (map.Map.get x
  n)) + ((4294967295%Z + 1%Z)%Z * (value_sub x (n + 1%Z)%Z m))%Z)%Z)) /\
  ((~ (n < m)%Z) -> ((value_sub x n m) = 0%Z)).

(* Why3 assumption *)
Definition map_eq_sub {a:Type} {a_WT:WhyType a} (a1:(map.Map.map Z a))
  (a2:(map.Map.map Z a)) (l:Z) (u:Z): Prop := forall (i:Z), ((l <= i)%Z /\
  (i < u)%Z) -> ((map.Map.get a1 i) = (map.Map.get a2 i)).

Axiom value_sub_frame : forall (x:(map.Map.map Z uint32)) (y:(map.Map.map Z
  uint32)) (n:Z) (m:Z), (map_eq_sub x y n m) -> ((value_sub x n
  m) = (value_sub y n m)).

Axiom value_sub_tail : forall (x:(map.Map.map Z uint32)) (n:Z) (m:Z),
  (n <= m)%Z -> ((value_sub x n (m + 1%Z)%Z) = ((value_sub x n
  m) + ((to_int1 (map.Map.get x m)) * (int.Power.power (4294967295%Z + 1%Z)%Z
  (m - n)%Z))%Z)%Z).

Axiom value_sub_concat : forall (x:(map.Map.map Z uint32)) (n:Z) (m:Z) (l:Z),
  ((n <= m)%Z /\ (m <= l)%Z) -> ((value_sub x n l) = ((value_sub x n
  m) + ((value_sub x m l) * (int.Power.power (4294967295%Z + 1%Z)%Z
  (m - n)%Z))%Z)%Z).

(* Why3 assumption *)
Definition value_array (x:(array uint32)): Z := (value_sub (elts x) 0%Z
  (to_int (length x))).

(* Why3 assumption *)
Definition value (x:t): Z := (value_array (digits x)).

Axiom value_sub_update : forall (x:(map.Map.map Z uint32)) (i:Z) (n:Z) (m:Z)
  (v:uint32), ((n <= i)%Z /\ (i < m)%Z) -> ((value_sub (map.Map.set x i v) n
  m) = ((value_sub x n m) + ((int.Power.power (4294967295%Z + 1%Z)%Z
  (i - n)%Z) * ((to_int1 v) - (to_int1 (map.Map.get x i)))%Z)%Z)%Z).

Axiom value_zero : forall (x:(map.Map.map Z uint32)) (n:Z) (m:Z), (map_eq_sub
  x (map.Const.const zero_unsigned: (map.Map.map Z uint32)) n m) ->
  ((value_sub x n m) = 0%Z).

Axiom value_sub_lower_bound : forall (x:(map.Map.map Z uint32)) (x1:Z)
  (x2:Z), (0%Z <= (value_sub x x1 x2))%Z.

Axiom value_sub_upper_bound : forall (x:(map.Map.map Z uint32)) (x1:Z)
  (x2:Z), (x1 <= x2)%Z -> ((value_sub x x1
  x2) < (int.Power.power (4294967295%Z + 1%Z)%Z (x2 - x1)%Z))%Z.

Axiom value_sub_lower_bound_tight : forall (x:(map.Map.map Z uint32)) (x1:Z)
  (x2:Z), (x1 < x2)%Z -> (((int.Power.power (4294967295%Z + 1%Z)%Z
  ((x2 - x1)%Z - 1%Z)%Z) * (to_int1 (map.Map.get x
  (x2 - 1%Z)%Z)))%Z <= (value_sub x x1 x2))%Z.

Axiom value_sub_upper_bound_tight : forall (x:(map.Map.map Z uint32)) (x1:Z)
  (x2:Z), (x1 < x2)%Z -> ((value_sub x x1
  x2) < ((int.Power.power (4294967295%Z + 1%Z)%Z
  ((x2 - x1)%Z - 1%Z)%Z) * ((to_int1 (map.Map.get x
  (x2 - 1%Z)%Z)) + 1%Z)%Z)%Z)%Z.

Parameter compare_int: Z -> Z -> Z.

Axiom compare_int_def : forall (x:Z) (y:Z), ((x < y)%Z -> ((compare_int x
  y) = (-1%Z)%Z)) /\ ((~ (x < y)%Z) -> (((x = y) -> ((compare_int x
  y) = 0%Z)) /\ ((~ (x = y)) -> ((compare_int x y) = 1%Z)))).

(* Why3 goal *)
Theorem WP_parameter_mul : forall (x:int31) (x1:(map.Map.map Z uint32))
  (y:int31) (y1:(map.Map.map Z uint32)), ((0%Z <= (to_int x))%Z /\
  (0%Z <= (to_int y))%Z) -> ((in_bounds1 0%Z) -> forall (limb_zero:uint32),
  ((to_int1 limb_zero) = 0%Z) -> ((in_bounds 0%Z) -> forall (zero:int31),
  ((to_int zero) = 0%Z) -> ((in_bounds 1073741823%Z) -> forall (o:int31),
  ((to_int o) = 1073741823%Z) -> ((in_bounds ((to_int o) - (to_int y))%Z) ->
  forall (o1:int31), ((to_int o1) = ((to_int o) - (to_int y))%Z) ->
  forall (result:bool), ((result = true) <-> ((to_int o1) < (to_int x))%Z) ->
  ((~ (result = true)) -> ((in_bounds ((to_int x) + (to_int y))%Z) ->
  forall (o2:int31), ((to_int o2) = ((to_int x) + (to_int y))%Z) ->
  ((0%Z <= (to_int o2))%Z -> forall (zd:int31) (zd1:(map.Map.map Z uint32)),
  ((0%Z <= (to_int zd))%Z /\ ((zd = o2) /\ forall (i:Z), ((0%Z <= i)%Z /\
  (i < (to_int o2))%Z) -> ((map.Map.get zd1 i) = limb_zero))) -> ((map_eq_sub
  zd1 (map.Const.const limb_zero: (map.Map.map Z uint32)) 0%Z
  ((to_int x) + (to_int y))%Z) -> (((value_sub zd1 0%Z
  ((to_int x) + (to_int y))%Z) = 0%Z) -> ((((0%Z <= (to_int zero))%Z /\
  (((to_int zero) <= (to_int x))%Z /\ ((to_int x) <= (to_int x))%Z)) /\
  (((0%Z <= (to_int zero))%Z /\ (((to_int zero) <= (to_int y))%Z /\
  ((to_int y) <= (to_int y))%Z)) /\ ((0%Z <= (to_int zero))%Z /\
  ((((to_int zero) + ((to_int x) - (to_int zero))%Z)%Z + ((to_int y) - (to_int zero))%Z)%Z <= (to_int zd))%Z))) ->
  forall (zd2:(map.Map.map Z uint32)), forall (usc:uint32),
  ((0%Z <= (to_int zd))%Z /\ (((value_sub zd2 0%Z
  (to_int zd)) + ((int.Power.power (4294967295%Z + 1%Z)%Z
  (((to_int zero) + ((to_int x) - (to_int zero))%Z)%Z + ((to_int y) - (to_int zero))%Z)%Z) * (to_int1 usc))%Z)%Z = ((value_sub zd1
  0%Z (to_int zd)) + ((int.Power.power (4294967295%Z + 1%Z)%Z
  (to_int zero)) * ((value_sub x1 (to_int zero) (to_int x)) * (value_sub y1
  (to_int zero) (to_int y)))%Z)%Z)%Z)) -> ((to_int1 usc) = 0%Z))))))))))).
(* Why3 intros x x1 y y1 (h1,h2) h3 limb_zero h4 h5 zero h6 h7 o h8 h9 o1 h10
        result h11 h12 h13 o2 h14 h15 zd zd1 (h16,(h17,h18)) h19 h20
        ((h21,(h22,h23)),((h24,(h25,h26)),(h27,h28))) zd2 usc (h29,h30). *)
Proof.
intros x x1 y y1 (h1,h2) h3 limb_zero h4 h5 zero h6 h7 o h8 h9 o1 h10
        result h11 h12 h13 o2 h14 h15 zd zd1 (h16,(h17,h18)) h19 h20
        ((h21,(h22,h23)),((h24,(h25,h26)),(h27,h28))) zd2 usc (h29,h30).
apply Zle_antisym.
2: apply to_int_in_bounds1.
apply Z.le_ngt.
intros H.
revert h28.
rewrite h6.
rewrite 2!Zminus_0_r.
intros H1.
assert (H2 := value_sub_upper_bound x1 0 (to_int x) h1).
assert (H3 := value_sub_upper_bound y1 0 (to_int y) h2).
rewrite Zminus_0_r in H2, H3.
refine (_ (Zmult_lt_compat _ _ _ _ (conj _ H2) (conj _ H3))).
apply Z.le_ngt.
rewrite <- Power.Power_sum by easy.
pattern ((4294967295 + 1) ^ (to_int x + to_int y))%Z at 1 ;
  replace ((4294967295 + 1) ^ (to_int x + to_int y))%Z with (0 + (4294967295 + 1) ^ (to_int x + to_int y) * 1)%Z by ring.
rewrite Zmult_1_r.
rewrite Zplus_0_l.
rewrite h6 in h30.
rewrite Zminus_0_r in h30.
rewrite Zminus_0_r in h30.
rewrite Zplus_0_l in h30.
2:apply value_sub_lower_bound.
2:apply value_sub_lower_bound.
rewrite <- h14 in h20.
rewrite <- h17 in h20.
rewrite h20 in h30.
rewrite Zplus_0_l in h30.
rewrite Power.Power_0 in h30.
rewrite Zmult_1_l in h30.
rewrite <- h30.
rewrite <- h14.
rewrite <- h17.
set (m := ((4294967295 + 1) ^ to_int zd)%Z).
apply Zle_trans with (m:= (m* to_int1 usc)%Z).
rewrite <- Zmult_1_r at 1.
apply Zmult_le_compat_l.
omega.
apply Power.Power_non_neg.
easy.
rewrite <- Zplus_0_l at 1.
apply Zplus_le_compat_r.
apply value_sub_lower_bound.
Qed.

